/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.data;

import com.google.gson.JsonObject;
import hellfirepvp.astralsorcery.common.perk.AbstractPerk;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.util.ResourceLocation;

public class LoadedPerkData {
    private final AbstractPerk perk;
    private final JsonObject perkDataObject;
    private final Set<ResourceLocation> connections = new HashSet<ResourceLocation>();

    public LoadedPerkData(AbstractPerk perk, JsonObject perkDataObject) {
        this.perk = perk;
        this.perkDataObject = perkDataObject;
    }

    void addConnection(ResourceLocation to) {
        this.connections.add(to);
    }

    public Set<ResourceLocation> getConnections() {
        return Collections.unmodifiableSet(this.connections);
    }

    public AbstractPerk getPerk() {
        return this.perk;
    }

    public JsonObject getPerkDataObject() {
        return this.perkDataObject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadedPerkData that = (LoadedPerkData)o;
        return Objects.equals(this.perk.getRegistryName(), that.perk.getRegistryName());
    }

    public int hashCode() {
        return Objects.hash(this.perk.getRegistryName());
    }
}

