/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.modifier;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.lib.RegistriesAS;
import hellfirepvp.astralsorcery.common.perk.modifier.AttributeConverterPerk;
import hellfirepvp.astralsorcery.common.perk.modifier.DynamicAttributeModifier;
import hellfirepvp.astralsorcery.common.perk.modifier.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.perk.source.AttributeModifierProvider;
import hellfirepvp.astralsorcery.common.perk.type.ModifierType;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public class AttributeModifierPerk
extends AttributeConverterPerk
implements AttributeModifierProvider {
    private final Set<PerkAttributeModifier> modifiers = Sets.newHashSet();

    public AttributeModifierPerk(ResourceLocation name, float x, float y) {
        super(name, x, y);
    }

    @Nonnull
    public <V extends AttributeModifierPerk> V addModifier(float modifier, ModifierType mode, PerkAttributeType type) {
        return this.addModifier(type.createModifier(modifier, mode));
    }

    @Nonnull
    public <T extends PerkAttributeModifier, V extends AttributeModifierPerk> V addModifier(T modifier) {
        this.modifiers.add(modifier);
        return (V)this;
    }

    @Override
    public Collection<PerkAttributeModifier> getModifiers(PlayerEntity player, LogicalSide side, boolean ignoreRequirements) {
        if (!ignoreRequirements && ResearchHelper.getProgress(player, side).getPerkData().isPerkSealed(this)) {
            return Collections.emptyList();
        }
        return new ArrayList<PerkAttributeModifier>(this.modifiers);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean addLocalizedTooltip(Collection<IFormattableTextComponent> tooltip) {
        boolean addEmptyLine;
        Collection<PerkAttributeModifier> modifiers = this.getModifiers((PlayerEntity)Minecraft.func_71410_x().field_71439_g, LogicalSide.CLIENT, true);
        boolean bl = addEmptyLine = !modifiers.isEmpty();
        if (this.canSeeClient()) {
            for (PerkAttributeModifier modifier : modifiers) {
                String modifierDisplay = modifier.getLocalizedDisplayString();
                if (modifierDisplay != null) {
                    tooltip.add((IFormattableTextComponent)new StringTextComponent(modifierDisplay));
                    continue;
                }
                addEmptyLine = false;
            }
        }
        return addEmptyLine;
    }

    @Override
    public void deserializeData(JsonObject perkData) {
        super.deserializeData(perkData);
        this.modifiers.clear();
        if (JSONUtils.func_151204_g((JsonObject)perkData, (String)"modifiers")) {
            JsonArray array = JSONUtils.func_151214_t((JsonObject)perkData, (String)"modifiers");
            for (int i = 0; i < array.size(); ++i) {
                ModifierType mode;
                JsonObject serializedModifier = JSONUtils.func_151210_l((JsonElement)array.get(i), (String)"modifiers[%s]");
                if (serializedModifier.has("custom")) {
                    String customKey = JSONUtils.func_151200_h((JsonObject)serializedModifier, (String)"custom");
                    PerkAttributeModifier customModifier = (PerkAttributeModifier)RegistriesAS.REGISTRY_PERK_CUSTOM_MODIFIERS.getValue(new ResourceLocation(customKey));
                    if (customModifier == null) {
                        throw new IllegalArgumentException("Unknown specified modifier: " + customKey);
                    }
                    this.addModifier(customModifier);
                    continue;
                }
                String typeKey = JSONUtils.func_151200_h((JsonObject)serializedModifier, (String)"type");
                PerkAttributeType type = (PerkAttributeType)RegistriesAS.REGISTRY_PERK_ATTRIBUTE_TYPES.getValue(new ResourceLocation(typeKey));
                if (type == null) {
                    throw new IllegalArgumentException("Unknown modifier type: " + typeKey);
                }
                String modeKey = JSONUtils.func_151200_h((JsonObject)serializedModifier, (String)"mode");
                try {
                    mode = ModifierType.valueOf(modeKey);
                }
                catch (Exception exc) {
                    throw new IllegalArgumentException("Unknown mode: " + modeKey);
                }
                float value = JSONUtils.func_151217_k((JsonObject)serializedModifier, (String)"value");
                this.addModifier(value, mode, type);
            }
        }
    }

    @Override
    public void serializeData(JsonObject perkData) {
        super.serializeData(perkData);
        if (!this.modifiers.isEmpty()) {
            JsonArray array = new JsonArray();
            for (PerkAttributeModifier modifier : this.modifiers) {
                if (modifier instanceof DynamicAttributeModifier) continue;
                JsonObject serializedModifier = new JsonObject();
                if (modifier.getRegistryName() != null) {
                    serializedModifier.addProperty("custom", modifier.getRegistryName().toString());
                } else {
                    serializedModifier.addProperty("type", modifier.getAttributeType().getRegistryName().toString());
                    serializedModifier.addProperty("mode", modifier.getMode().name());
                    serializedModifier.addProperty("value", (Number)Float.valueOf(modifier.getRawValue()));
                }
                array.add((JsonElement)serializedModifier);
            }
            perkData.add("modifiers", (JsonElement)array);
        }
    }
}

