/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingSprite;
import hellfirepvp.astralsorcery.client.effect.vfx.FXLightbeam;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.client.lib.SpritesAS;
import hellfirepvp.astralsorcery.client.util.sound.FadeLoopSound;
import hellfirepvp.astralsorcery.client.util.sound.PositionedLoopSound;
import hellfirepvp.astralsorcery.common.base.MoonPhase;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.SkyHandler;
import hellfirepvp.astralsorcery.common.constellation.star.StarConnection;
import hellfirepvp.astralsorcery.common.constellation.star.StarLocation;
import hellfirepvp.astralsorcery.common.constellation.world.ConstellationHandler;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.constellation.world.WorldContext;
import hellfirepvp.astralsorcery.common.crafting.nojson.AttunementCraftingRegistry;
import hellfirepvp.astralsorcery.common.crafting.nojson.CustomRecipe;
import hellfirepvp.astralsorcery.common.crafting.nojson.attunement.AttunementRecipe;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.entity.EntityFlare;
import hellfirepvp.astralsorcery.common.item.ItemConstellationPaper;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.RegistriesAS;
import hellfirepvp.astralsorcery.common.lib.SoundsAS;
import hellfirepvp.astralsorcery.common.lib.StructureTypesAS;
import hellfirepvp.astralsorcery.common.lib.TileEntityTypesAS;
import hellfirepvp.astralsorcery.common.structure.types.StructureType;
import hellfirepvp.astralsorcery.common.tile.TileSpectralRelay;
import hellfirepvp.astralsorcery.common.tile.base.TileEntityTick;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import hellfirepvp.astralsorcery.common.util.sound.SoundHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.items.IItemHandler;

public class TileAttunementAltar
extends TileEntityTick {
    private IConstellation activeConstellation = null;
    private AttunementRecipe.Active<?> currentRecipe = null;
    private Map<BlockPos, Object> activeStarSprites = new HashMap<BlockPos, Object>();
    private Object attunementAltarIdleSound = null;
    public static final int MAX_START_ANIMATION_TICK = 60;
    public static final int MAX_START_ANIMATION_SPIN = 100;
    public int activationTick = 0;
    public int prevActivationTick = 0;
    public boolean animate = false;
    public boolean tesrLocked = true;

    public TileAttunementAltar() {
        super(TileEntityTypesAS.ATTUNEMENT_ALTAR);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().func_201670_d()) {
            if (!this.doesSeeSky() || !this.hasMultiblock()) {
                if (this.activeConstellation != null) {
                    this.activeConstellation = null;
                    this.markForUpdate();
                }
                if (this.currentRecipe != null) {
                    this.currentRecipe = null;
                    this.markForUpdate();
                }
                return;
            }
            this.updateActiveConstellation();
            if (this.currentRecipe == null) {
                this.searchAndStartRecipe();
            } else {
                this.currentRecipe.tick(LogicalSide.SERVER, this);
                if (!this.currentRecipe.matches(this)) {
                    this.currentRecipe = null;
                    this.markForUpdate();
                } else if (this.currentRecipe.isFinished(this)) {
                    this.finishActiveRecipe();
                }
            }
        } else {
            this.tickEffects();
            if (this.currentRecipe != null) {
                this.currentRecipe.tick(LogicalSide.CLIENT, this);
            }
        }
    }

    private void updateActiveConstellation() {
        if (this.getTicksExisted() % 20 == 0) {
            IConstellation found = this.searchActiveConstellation();
            if (this.activeConstellation == null) {
                if (found != null) {
                    this.activeConstellation = found;
                    this.markForUpdate();
                }
            } else if (found != null) {
                if (!this.activeConstellation.equals(found)) {
                    this.activeConstellation = found;
                    this.markForUpdate();
                }
            } else {
                this.activeConstellation = null;
                this.markForUpdate();
            }
            if (this.activeConstellation != null) {
                for (BlockPos pos : this.getConstellationPositions(this.activeConstellation)) {
                    TileSpectralRelay relay = MiscUtils.getTileAt((IBlockReader)this.func_145831_w(), pos, TileSpectralRelay.class, false);
                    if (relay == null || relay.getInventory().getStackInSlot(0).func_190926_b()) continue;
                    ItemUtils.dropInventory((IItemHandler)relay.getInventory(), this.func_145831_w(), pos.func_177984_a());
                    relay.getInventory().clearInventory();
                }
            }
        }
    }

    public void finishActiveRecipe() {
        if (this.currentRecipe != null) {
            this.currentRecipe.finishRecipe(this);
            this.currentRecipe.stopCrafting(this);
            this.currentRecipe = null;
            this.markForUpdate();
            EntityFlare.spawnAmbientFlare(this.func_145831_w(), this.func_174877_v().func_177982_a(-5 + rand.nextInt(11), 1 + rand.nextInt(3), -5 + rand.nextInt(11)));
            EntityFlare.spawnAmbientFlare(this.func_145831_w(), this.func_174877_v().func_177982_a(-5 + rand.nextInt(11), 1 + rand.nextInt(3), -5 + rand.nextInt(11)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickEffects() {
        if (!this.hasMultiblock() || !this.doesSeeSky()) {
            this.tickEffectNonActive();
            return;
        }
        this.spawnAmbientEffects();
        this.spawnHighlightedEffects();
        this.tickEffectsConstellation();
        if (!this.canPlayConstellationActiveEffects()) {
            this.tickEffectNonActive();
            return;
        }
        this.tickEffectActive();
        this.tickConstellationBeams();
        if (this.getActiveRecipe() == null) {
            this.tickSoundIdle();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickEffectsConstellation() {
        if (this.activeConstellation != null) {
            Set<BlockPos> positions = this.getConstellationPositions(this.activeConstellation);
            for (BlockPos blockPos : this.activeStarSprites.keySet()) {
                FXFacingSprite sprite;
                if (positions.contains(blockPos) || (sprite = (FXFacingSprite)this.activeStarSprites.get(blockPos)).isRemoved()) continue;
                sprite.requestRemoval();
            }
            float night = DayTimeHelper.getCurrentDaytimeDistribution(this.func_145831_w());
            for (BlockPos key : positions) {
                if (!this.activeStarSprites.containsKey(key)) {
                    FXFacingSprite sprite = (FXFacingSprite)((EntityComplexFX)((FXFacingSprite)EffectHelper.of(EffectTemplatesAS.FACING_SPRITE).spawn(new Vector3((Vector3i)key).add(0.5, 0.5, 0.5))).setSprite(SpritesAS.SPR_RELAY_FLARE).setScaleMultiplier(1.4f)).refresh(fx -> this.canPlayConstellationActiveEffects());
                    this.activeStarSprites.put(key, sprite);
                } else {
                    FXFacingSprite spr = (FXFacingSprite)this.activeStarSprites.get(key);
                    if (spr.isRemoved()) {
                        EffectHelper.refresh(spr, EffectTemplatesAS.FACING_SPRITE);
                    }
                }
                if (!(night >= 0.1f) || this.getActiveRecipe() != null) continue;
                this.playConstellationHighlightParticles(this.activeConstellation, key, night);
            }
            this.playAltarConstellationHighlightParticles(this.activeConstellation, night);
        } else if (!this.activeStarSprites.isEmpty()) {
            for (BlockPos key : this.activeStarSprites.keySet()) {
                FXFacingSprite fXFacingSprite = (FXFacingSprite)this.activeStarSprites.get(key);
                if (fXFacingSprite.isRemoved()) continue;
                fXFacingSprite.requestRemoval();
            }
            this.activeStarSprites.clear();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickSoundIdle() {
        if (SoundHelper.getSoundVolume(SoundCategory.BLOCKS) <= 0.0f) {
            this.attunementAltarIdleSound = null;
            return;
        }
        if (this.attunementAltarIdleSound == null || ((PositionedLoopSound)((Object)this.attunementAltarIdleSound)).hasStoppedPlaying()) {
            this.attunementAltarIdleSound = ((FadeLoopSound)((Object)SoundHelper.playSoundLoopFadeInClient(SoundsAS.ATTUNEMENT_ATLAR_IDLE, new Vector3(this).add(0.5, 1.0, 0.5), 0.4f, 1.0f, false, s -> !this.canPlayConstellationActiveEffects() || SoundHelper.getSoundVolume(SoundCategory.BLOCKS) <= 0.0f || this.getActiveRecipe() != null).setFadeInTicks(20.0f))).setFadeOutTicks(20.0f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickConstellationBeams() {
        VFXColorFunction beamColor = VFXColorFunction.constant(ColorsAS.DEFAULT_GENERIC_PARTICLE);
        float beamSize = 0.8f;
        for (Tuple<BlockPos, BlockPos> conn : this.getConstellationConnectionPositions(this.activeConstellation)) {
            Vector3 from = new Vector3((Vector3i)conn.func_76341_a()).add(0.5, 0.5, 0.5);
            Vector3 to = new Vector3((Vector3i)conn.func_76340_b()).add(0.5, 0.5, 0.5);
            if (this.getTicksExisted() % 50 == 0) {
                ((FXLightbeam)EffectHelper.of(EffectTemplatesAS.LIGHTBEAM).spawn(from)).setup(to, beamSize, beamSize).color(beamColor);
                ((FXLightbeam)EffectHelper.of(EffectTemplatesAS.LIGHTBEAM).spawn(to)).setup(from, beamSize, beamSize).color(beamColor);
            }
            if (!rand.nextBoolean()) continue;
            Vector3 at = from.clone().subtract(to).multiply(rand.nextFloat()).add(to).add(Vector3.random().multiply(rand.nextFloat() * 0.25f));
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at)).alpha(VFXAlphaFunction.FADE_OUT)).color(VFXColorFunction.constant(this.activeConstellation.getConstellationColor()))).setScaleMultiplier(0.2f + rand.nextFloat() * 0.1f)).setMaxAge(20 + rand.nextInt(10));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickEffectNonActive() {
        this.animate = false;
        this.prevActivationTick = this.activationTick;
        if (this.activationTick > 0) {
            --this.activationTick;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickEffectActive() {
        this.animate = true;
        this.prevActivationTick = this.activationTick;
        if (this.activationTick < 60) {
            ++this.activationTick;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean canPlayConstellationActiveEffects() {
        WorldContext ctx = SkyHandler.getContext(this.func_145831_w(), LogicalSide.CLIENT);
        return ctx != null && !this.func_145837_r() && this.hasMultiblock() && this.doesSeeSky() && this.getActiveConstellation() != null && DayTimeHelper.isNight(this.func_145831_w()) && ctx.getConstellationHandler().isActiveCurrently(this.getActiveConstellation(), MoonPhase.fromWorld((IWorld)this.func_145831_w()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnAmbientEffects() {
        if (rand.nextBoolean()) {
            Vector3 pos = new Vector3(this).add((double)(rand.nextFloat() * 15.0f - 7.0f), 0.01, (double)(rand.nextFloat() * 15.0f - 7.0f));
            ((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(pos)).color(VFXColorFunction.WHITE)).setAlphaMultiplier(0.7f)).setScaleMultiplier(0.3f + rand.nextFloat() * 0.1f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnHighlightedEffects() {
        float night;
        ItemStack cstPaper;
        IConstellation cst;
        if (this.canPlayConstellationActiveEffects()) {
            return;
        }
        WorldContext ctx = SkyHandler.getContext(this.func_145831_w(), LogicalSide.CLIENT);
        if (ctx == null) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || player.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.func_174877_v())) >= 256.0) {
            return;
        }
        Tuple<Hand, ItemStack> heldTpl = MiscUtils.getMainOrOffHand((LivingEntity)player, stack -> stack.func_77973_b() instanceof ItemConstellationPaper);
        if (heldTpl != null && (cst = ((ItemConstellationPaper)(cstPaper = (ItemStack)heldTpl.func_76340_b()).func_77973_b()).getConstellation(cstPaper)) != null && ResearchHelper.getClientProgress().hasConstellationDiscovered(cst) && (night = DayTimeHelper.getCurrentDaytimeDistribution(this.func_145831_w())) >= 0.1f) {
            for (BlockPos pos : this.getConstellationPositions(cst)) {
                this.playConstellationHighlightParticles(cst, pos, night);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playConstellationHighlightParticles(IConstellation cst, BlockPos pos, float nightPercent) {
        Vector3 at = new Vector3((Vector3i)pos).add(0.5, 0.0, 0.5);
        Vector3 offset = Vector3.random().multiply(0.5f).setY(0);
        if (rand.nextInt(3) == 0) {
            offset.multiply(0.5);
            ((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at.add(offset))).color(VFXColorFunction.constant(cst.getConstellationColor()))).setGravityStrength(-0.002f)).setMotion(Vector3.random().addY(3.0).normalize().multiply(0.03 + (double)rand.nextFloat() * 0.01))).setAlphaMultiplier(0.6f * nightPercent)).setScaleMultiplier(0.15f + rand.nextFloat() * 0.1f)).alpha(VFXAlphaFunction.FADE_OUT);
        } else if (rand.nextInt(3) == 0) {
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at.add(offset))).setGravityStrength(-5.0E-4f)).setMotion(Vector3.random().addY(3.0).normalize().multiply(0.005))).setAlphaMultiplier(0.6f * nightPercent)).setScaleMultiplier(0.4f + rand.nextFloat() * 0.2f)).alpha(VFXAlphaFunction.FADE_OUT)).setMaxAge(60 + rand.nextInt(40));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playAltarConstellationHighlightParticles(IConstellation cst, float nightPercent) {
        Vector3 at = new Vector3((Vector3i)this.func_174877_v()).add(0.5, 0.0, 0.5).add(Vector3.random().setY(0).multiply(0.65f));
        ((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at)).color(VFXColorFunction.constant(cst.getConstellationColor().brighter()))).setGravityStrength(-0.0015f)).setMotion(Vector3.random().addY(3.0).normalize().multiply(0.03 + (double)rand.nextFloat() * 0.015))).setAlphaMultiplier(0.85f * nightPercent)).setScaleMultiplier(0.2f + rand.nextFloat() * 0.1f)).alpha(VFXAlphaFunction.FADE_OUT);
    }

    @Nullable
    public IConstellation getActiveConstellation() {
        return this.activeConstellation;
    }

    @Nullable
    public AttunementRecipe.Active<?> getActiveRecipe() {
        return this.currentRecipe;
    }

    @Override
    @Nullable
    public StructureType getRequiredStructureType() {
        return StructureTypesAS.PTYPE_ATTUNEMENT_ALTAR;
    }

    private void searchAndStartRecipe() {
        if (this.currentRecipe != null) {
            return;
        }
        AttunementRecipe<?> match = this.searchMatchingRecipe();
        if (match != null) {
            this.currentRecipe = match.createRecipe(this);
            this.currentRecipe.startCrafting(this);
            this.markForUpdate();
        }
    }

    @Nullable
    private AttunementRecipe<?> searchMatchingRecipe() {
        for (AttunementRecipe recipe : AttunementCraftingRegistry.INSTANCE.getRecipes()) {
            if (!recipe.canStartCrafting(this)) continue;
            return recipe;
        }
        return null;
    }

    @Nullable
    private IConstellation searchActiveConstellation() {
        WorldContext ctx = SkyHandler.getContext(this.func_145831_w());
        if (ctx == null) {
            return null;
        }
        ConstellationHandler cstHandler = ctx.getConstellationHandler();
        IConstellation match = null;
        for (IConstellation cst : RegistriesAS.REGISTRY_CONSTELLATIONS.getValues()) {
            boolean isValid = true;
            for (BlockPos expectedRelayPos : this.getConstellationPositions(cst)) {
                TileEntity tile;
                if (expectedRelayPos.equals((Object)this.func_174877_v()) || (tile = MiscUtils.getTileAt((IBlockReader)this.func_145831_w(), expectedRelayPos, TileEntity.class, true)) instanceof TileSpectralRelay || tile instanceof TileAttunementAltar) continue;
                isValid = false;
                break;
            }
            if (!isValid) continue;
            match = cst;
            break;
        }
        if (match != null && cstHandler.isActiveCurrently(match, MoonPhase.fromWorld((IWorld)this.func_145831_w()))) {
            return match;
        }
        return null;
    }

    public Set<BlockPos> getConstellationPositions(IConstellation cst) {
        HashSet<BlockPos> offsetPositions = new HashSet<BlockPos>();
        for (StarLocation sl : cst.getStars()) {
            int x = sl.x / 2;
            int z = sl.y / 2;
            offsetPositions.add(new BlockPos(x - 7, 0, z - 7).func_177971_a((Vector3i)this.func_174877_v()));
        }
        return offsetPositions;
    }

    private Set<Tuple<BlockPos, BlockPos>> getConstellationConnectionPositions(IConstellation cst) {
        HashSet<Tuple<BlockPos, BlockPos>> offsetPositions = new HashSet<Tuple<BlockPos, BlockPos>>();
        for (StarConnection conn : cst.getStarConnections()) {
            StarLocation from = (StarLocation)conn.getLeft();
            StarLocation to = (StarLocation)conn.getRight();
            int fX = from.x / 2;
            int fZ = from.y / 2;
            int tX = to.x / 2;
            int tZ = to.y / 2;
            offsetPositions.add((Tuple<BlockPos, BlockPos>)new Tuple((Object)new BlockPos(fX - 7, 0, fZ - 7).func_177971_a((Vector3i)this.func_174877_v()), (Object)new BlockPos(tX - 7, 0, tZ - 7).func_177971_a((Vector3i)this.func_174877_v())));
        }
        return offsetPositions;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72321_a(3.5, 2.0, 3.5);
    }

    @Override
    public void writeNetNBT(CompoundNBT compound) {
        super.writeNetNBT(compound);
        if (this.activeConstellation != null) {
            compound.func_74778_a("activeConstellation", this.activeConstellation.getRegistryName().toString());
        }
        if (this.currentRecipe != null) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a("recipe", ((CustomRecipe)this.currentRecipe.getRecipe()).getKey().toString());
            this.currentRecipe.writeToNBT(nbt);
            compound.func_218657_a("currentRecipe", (INBT)nbt);
        }
    }

    @Override
    public void readNetNBT(CompoundNBT compound) {
        super.readNetNBT(compound);
        this.activeConstellation = compound.func_74764_b("activeConstellation") ? ConstellationRegistry.getConstellation(new ResourceLocation(compound.func_74779_i("activeConstellation"))) : null;
        if (compound.func_74764_b("currentRecipe")) {
            CompoundNBT nbt = compound.func_74775_l("currentRecipe");
            AttunementRecipe recipe = (AttunementRecipe)AttunementCraftingRegistry.INSTANCE.getRecipe(new ResourceLocation(nbt.func_74779_i("recipe")));
            if (recipe != null) {
                this.currentRecipe = recipe.deserialize(this, nbt, this.currentRecipe);
            } else if (this.currentRecipe != null) {
                this.currentRecipe.stopEffects(this);
                this.currentRecipe = null;
            }
        } else if (this.currentRecipe != null) {
            this.currentRecipe.stopEffects(this);
            this.currentRecipe = null;
        }
    }
}

