/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public class ColorUtils {
    public static Color blendColors(Color color1, Color color2, float color1Ratio) {
        return new Color(ColorUtils.blendColors(color1.getRGB(), color2.getRGB(), color1Ratio), true);
    }

    public static int blendColors(int color1, int color2, float color1Ratio) {
        float ratio1 = MathHelper.func_76131_a((float)color1Ratio, (float)0.0f, (float)1.0f);
        float ratio2 = 1.0f - ratio1;
        int a1 = (color1 & 0xFF000000) >> 24;
        int r1 = (color1 & 0xFF0000) >> 16;
        int g1 = (color1 & 0xFF00) >> 8;
        int b1 = color1 & 0xFF;
        int a2 = (color2 & 0xFF000000) >> 24;
        int r2 = (color2 & 0xFF0000) >> 16;
        int g2 = (color2 & 0xFF00) >> 8;
        int b2 = color2 & 0xFF;
        int a = MathHelper.func_76125_a((int)Math.round((float)a1 * ratio1 + (float)a2 * ratio2), (int)0, (int)255);
        int r = MathHelper.func_76125_a((int)Math.round((float)r1 * ratio1 + (float)r2 * ratio2), (int)0, (int)255);
        int g = MathHelper.func_76125_a((int)Math.round((float)g1 * ratio1 + (float)g2 * ratio2), (int)0, (int)255);
        int b = MathHelper.func_76125_a((int)Math.round((float)b1 * ratio1 + (float)b2 * ratio2), (int)0, (int)255);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static Color overlayColor(Color base, Color overlay) {
        return new Color(ColorUtils.overlayColor(base.getRGB(), overlay.getRGB()), true);
    }

    public static int overlayColor(int base, int overlay) {
        int alpha = (base & 0xFF000000) >> 24;
        int baseR = (base & 0xFF0000) >> 16;
        int baseG = (base & 0xFF00) >> 8;
        int baseB = base & 0xFF;
        int overlayR = (overlay & 0xFF0000) >> 16;
        int overlayG = (overlay & 0xFF00) >> 8;
        int overlayB = overlay & 0xFF;
        int r = Math.round((float)baseR * ((float)overlayR / 255.0f)) & 0xFF;
        int g = Math.round((float)baseG * ((float)overlayG / 255.0f)) & 0xFF;
        int b = Math.round((float)baseB * ((float)overlayB / 255.0f)) & 0xFF;
        return alpha << 24 | r << 16 | g << 8 | b;
    }

    public static int getOverlayColor(FluidStack stack) {
        if (stack.isEmpty()) {
            return -1;
        }
        return stack.getFluid().getAttributes().getColor(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getOverlayColor(ItemStack stack) {
        if (stack.func_190926_b()) {
            return -1;
        }
        if (stack.func_77973_b() instanceof BlockItem) {
            BlockState state = ItemUtils.createBlockState(stack);
            if (state == null) {
                return -1;
            }
            return Minecraft.func_71410_x().func_184125_al().func_228054_a_(state, null, null, 0);
        }
        return Minecraft.func_71410_x().getItemColors().func_186728_a(stack, 0);
    }

    @Nonnull
    public static IFormattableTextComponent getTranslation(DyeColor color) {
        return new TranslationTextComponent(String.format("color.minecraft.%s", color.func_176762_d()));
    }

    @Nonnull
    public static Color flareColorFromDye(DyeColor color) {
        return ColorsAS.DYE_COLOR_PARTICLES[color.func_196059_a()];
    }

    @Nonnull
    public static TextFormatting textFormattingForDye(DyeColor color) {
        switch (color) {
            case WHITE: {
                return TextFormatting.WHITE;
            }
            case ORANGE: {
                return TextFormatting.GOLD;
            }
            case MAGENTA: {
                return TextFormatting.DARK_PURPLE;
            }
            case LIGHT_BLUE: {
                return TextFormatting.DARK_AQUA;
            }
            case YELLOW: {
                return TextFormatting.YELLOW;
            }
            case LIME: {
                return TextFormatting.GREEN;
            }
            case PINK: {
                return TextFormatting.LIGHT_PURPLE;
            }
            case GRAY: {
                return TextFormatting.DARK_GRAY;
            }
            case LIGHT_GRAY: {
                return TextFormatting.GRAY;
            }
            case CYAN: {
                return TextFormatting.BLUE;
            }
            case PURPLE: {
                return TextFormatting.DARK_PURPLE;
            }
            case BLUE: {
                return TextFormatting.DARK_BLUE;
            }
            case BROWN: {
                return TextFormatting.GOLD;
            }
            case GREEN: {
                return TextFormatting.DARK_GREEN;
            }
            case RED: {
                return TextFormatting.DARK_RED;
            }
            case BLACK: {
                return TextFormatting.DARK_GRAY;
            }
        }
        return TextFormatting.WHITE;
    }
}

