/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.object;

import java.util.Collection;
import java.util.function.Predicate;

public class PredicateBuilder<T> {
    private Predicate<T> predicate;

    private PredicateBuilder(Predicate<T> predicate) {
        this.predicate = predicate;
    }

    public static <T> Predicate<T> joinOr(Collection<? extends Predicate<T>> collection) {
        PredicateBuilder<T> builder = PredicateBuilder.startOr();
        collection.forEach(builder::or);
        return builder.build();
    }

    public static <T> Predicate<T> joinAnd(Collection<? extends Predicate<T>> collection) {
        PredicateBuilder<T> builder = PredicateBuilder.startAnd();
        collection.forEach(builder::and);
        return builder.build();
    }

    public static <T> PredicateBuilder<T> startOr() {
        return new PredicateBuilder<Object>(el -> false);
    }

    public static <T> PredicateBuilder<T> startAnd() {
        return new PredicateBuilder<Object>(el -> true);
    }

    public PredicateBuilder<T> or(Predicate<T> predicate) {
        this.predicate = this.predicate.or(predicate);
        return this;
    }

    public PredicateBuilder<T> and(Predicate<T> predicate) {
        this.predicate = this.predicate.and(predicate);
        return this;
    }

    public Predicate<T> build() {
        return this.predicate;
    }
}

