/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.datagen.data.advancements;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.advancement.AttuneCrystalTrigger;
import hellfirepvp.astralsorcery.common.advancement.AttuneSelfTrigger;
import hellfirepvp.astralsorcery.common.advancement.DiscoverConstellationTrigger;
import hellfirepvp.astralsorcery.common.advancement.instance.AltarRecipeInstance;
import hellfirepvp.astralsorcery.common.advancement.instance.ConstellationInstance;
import hellfirepvp.astralsorcery.common.advancement.instance.PerkLevelInstance;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.TickTrigger;
import net.minecraft.data.AdvancementProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AstralAdvancementProvider
extends AdvancementProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public AstralAdvancementProvider(DataGenerator generator) {
        super(generator);
        this.generator = generator;
    }

    public void func_200398_a(DirectoryCache cache) {
        Path path = this.generator.func_200391_b();
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> registrar = advancement -> {
            if (!set.add(advancement.func_192067_g())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.func_192067_g());
            }
            Path outPath = this.getPath(path, (Advancement)advancement);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)advancement.func_192075_a().func_200273_b(), (Path)outPath);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save advancement {}", (Object)outPath, (Object)ioexception);
            }
        };
        this.registerAdvancements(registrar);
    }

    private Path getPath(Path base, Advancement advancement) {
        return base.resolve(String.format("data/%s/advancements/%s.json", advancement.func_192067_g().func_110624_b(), advancement.func_192067_g().func_110623_a()));
    }

    private TranslationTextComponent title(String key) {
        return new TranslationTextComponent(String.format("advancements.astralsorcery.%s.title", key));
    }

    private TranslationTextComponent description(String key) {
        return new TranslationTextComponent(String.format("advancements.astralsorcery.%s.desc", key));
    }

    private void registerAdvancements(Consumer<Advancement> registrar) {
        Advancement root = Advancement.Builder.func_200278_a().func_203902_a((IItemProvider)ItemsAS.TOME, (ITextComponent)this.title("root"), (ITextComponent)this.description("root"), AstralSorcery.key("textures/block/black_marble_raw.png"), FrameType.TASK, false, false, false).func_200275_a("astralsorcery_present", (ICriterionInstance)new TickTrigger.Instance(EntityPredicate.AndPredicate.field_234582_a_)).func_203904_a(registrar, AstralSorcery.key("root").toString());
        Advancement foundRockCrystals = Advancement.Builder.func_200278_a().func_203905_a(root).func_203902_a((IItemProvider)ItemsAS.ROCK_CRYSTAL, (ITextComponent)this.title("rock_crystals"), (ITextComponent)this.description("rock_crystals"), null, FrameType.TASK, true, true, false).func_200275_a("rock_crystal_in_inventory", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{ItemsAS.ROCK_CRYSTAL})).func_203904_a(registrar, AstralSorcery.key("rock_crystals").toString());
        Advancement foundCelestialCrystals = Advancement.Builder.func_200278_a().func_203905_a(foundRockCrystals).func_203902_a((IItemProvider)ItemsAS.CELESTIAL_CRYSTAL, (ITextComponent)this.title("celestial_crystals"), (ITextComponent)this.description("celestial_crystals"), null, FrameType.TASK, true, true, false).func_200275_a("celestial_crystal_in_inventory", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{ItemsAS.CELESTIAL_CRYSTAL})).func_203904_a(registrar, AstralSorcery.key("celestial_crystals").toString());
        Advancement craftAltarT2 = Advancement.Builder.func_200278_a().func_203905_a(foundRockCrystals).func_203902_a((IItemProvider)BlocksAS.ALTAR_ATTUNEMENT, (ITextComponent)this.title("craft_t2_altar"), (ITextComponent)this.description("craft_t2_altar"), null, FrameType.TASK, true, true, false).func_200275_a("altar_craft_t2_altar", (ICriterionInstance)AltarRecipeInstance.withOutput(new IItemProvider[]{BlocksAS.ALTAR_ATTUNEMENT})).func_203904_a(registrar, AstralSorcery.key("craft_t2_altar").toString());
        Advancement craftAltarT3 = Advancement.Builder.func_200278_a().func_203905_a(craftAltarT2).func_203902_a((IItemProvider)BlocksAS.ALTAR_CONSTELLATION, (ITextComponent)this.title("craft_t3_altar"), (ITextComponent)this.description("craft_t3_altar"), null, FrameType.TASK, true, true, false).func_200275_a("altar_craft_t3_altar", (ICriterionInstance)AltarRecipeInstance.withOutput(new IItemProvider[]{BlocksAS.ALTAR_CONSTELLATION})).func_203904_a(registrar, AstralSorcery.key("craft_t3_altar").toString());
        Advancement craftAltarT4 = Advancement.Builder.func_200278_a().func_203905_a(craftAltarT3).func_203902_a((IItemProvider)BlocksAS.ALTAR_CONSTELLATION, (ITextComponent)this.title("craft_t4_altar"), (ITextComponent)this.description("craft_t4_altar"), null, FrameType.CHALLENGE, true, true, false).func_200275_a("altar_craft_t3_altar", (ICriterionInstance)AltarRecipeInstance.withOutput(new IItemProvider[]{BlocksAS.ALTAR_RADIANCE})).func_203904_a(registrar, AstralSorcery.key("craft_t4_altar").toString());
        Advancement findAnyConstellation = Advancement.Builder.func_200278_a().func_203905_a(root).func_203902_a((IItemProvider)BlocksAS.TELESCOPE, (ITextComponent)this.title("find_constellation"), (ITextComponent)this.description("find_constellation"), null, FrameType.TASK, true, true, false).func_200275_a("any_constellation_discovered", (ICriterionInstance)ConstellationInstance.any(DiscoverConstellationTrigger.ID)).func_203904_a(registrar, AstralSorcery.key("find_constellation").toString());
        Advancement findWeakConstellation = Advancement.Builder.func_200278_a().func_203905_a(findAnyConstellation).func_203902_a((IItemProvider)BlocksAS.TELESCOPE, (ITextComponent)this.title("find_weak_constellation"), (ITextComponent)this.description("find_weak_constellation"), null, FrameType.TASK, true, true, false).func_200275_a("weak_constellation_discovered", (ICriterionInstance)ConstellationInstance.anyWeak(DiscoverConstellationTrigger.ID)).func_203904_a(registrar, AstralSorcery.key("find_weak_constellation").toString());
        Advancement findMinorConstellation = Advancement.Builder.func_200278_a().func_203905_a(findWeakConstellation).func_203902_a((IItemProvider)BlocksAS.OBSERVATORY, (ITextComponent)this.title("find_minor_constellation"), (ITextComponent)this.description("find_minor_constellation"), null, FrameType.TASK, true, true, false).func_200275_a("minor_constellation_discovered", (ICriterionInstance)ConstellationInstance.anyMinor(DiscoverConstellationTrigger.ID)).func_203904_a(registrar, AstralSorcery.key("find_minor_constellation").toString());
        Advancement attuneSelf = Advancement.Builder.func_200278_a().func_203905_a(findAnyConstellation).func_203902_a((IItemProvider)BlocksAS.ATTUNEMENT_ALTAR, (ITextComponent)this.title("attune_self"), (ITextComponent)this.description("attune_self"), null, FrameType.TASK, true, true, false).func_200275_a("attune_self", (ICriterionInstance)ConstellationInstance.any(AttuneSelfTrigger.ID)).func_203904_a(registrar, AstralSorcery.key("attune_self").toString());
        Advancement attuneCrystal = Advancement.Builder.func_200278_a().func_203905_a(attuneSelf).func_203902_a((IItemProvider)BlocksAS.RITUAL_PEDESTAL, (ITextComponent)this.title("attune_crystal"), (ITextComponent)this.description("attune_crystal"), null, FrameType.TASK, true, true, false).func_200275_a("attune_crystal", (ICriterionInstance)ConstellationInstance.anyWeak(AttuneCrystalTrigger.ID)).func_203904_a(registrar, AstralSorcery.key("attune_crystal").toString());
        Advancement attuneCrystalTrait = Advancement.Builder.func_200278_a().func_203905_a(attuneCrystal).func_203902_a((IItemProvider)BlocksAS.RITUAL_PEDESTAL, (ITextComponent)this.title("attune_trait"), (ITextComponent)this.description("attune_trait"), null, FrameType.TASK, true, true, false).func_200275_a("attune_trait", (ICriterionInstance)ConstellationInstance.anyMinor(AttuneCrystalTrigger.ID)).func_203904_a(registrar, AstralSorcery.key("attune_trait").toString());
        Advancement perkLevelSmall = Advancement.Builder.func_200278_a().func_203905_a(attuneSelf).func_203902_a((IItemProvider)BlocksAS.SPECTRAL_RELAY, (ITextComponent)this.title("perk_level_small"), (ITextComponent)this.description("perk_level_small"), null, FrameType.TASK, true, true, false).func_200275_a("gain_perk_level_small", (ICriterionInstance)PerkLevelInstance.reachLevel(10)).func_203904_a(registrar, AstralSorcery.key("perk_level_small").toString());
        Advancement perkLevelMedium = Advancement.Builder.func_200278_a().func_203905_a(perkLevelSmall).func_203902_a((IItemProvider)BlocksAS.SPECTRAL_RELAY, (ITextComponent)this.title("perk_level_medium"), (ITextComponent)this.description("perk_level_medium"), null, FrameType.TASK, true, true, false).func_200275_a("gain_perk_level_medium", (ICriterionInstance)PerkLevelInstance.reachLevel(25)).func_203904_a(registrar, AstralSorcery.key("perk_level_medium").toString());
        Advancement perkLevelLarge = Advancement.Builder.func_200278_a().func_203905_a(perkLevelMedium).func_203902_a((IItemProvider)BlocksAS.SPECTRAL_RELAY, (ITextComponent)this.title("perk_level_large"), (ITextComponent)this.description("perk_level_large"), null, FrameType.CHALLENGE, true, true, false).func_200275_a("gain_perk_level_large", (ICriterionInstance)PerkLevelInstance.reachLevel(40)).func_203904_a(registrar, AstralSorcery.key("perk_level_large").toString());
    }
}

