/*
 * Decompiled with CFR 0.152.
 */
package com.github.phylogeny.jeienchantmentinfo;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="jeienchantmentinfo")
@JeiPlugin
public class JEIEnchantmentInfo
implements IModPlugin {
    public static final String MOD_ID = "jeienchantmentinfo";

    public ResourceLocation getPluginUid() {
        return new ResourceLocation(MOD_ID, "jei");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        String missingDescription = I18n.func_135052_a((String)this.getLangKey("missing_description"), (Object[])new Object[0]);
        String conflictsTitle = "\n" + I18n.func_135052_a((String)this.getLangKey("conflicts"), (Object[])new Object[0]);
        String maxLevelKey = this.getLangKey("max_level");
        String typeKey = this.getLangKey("type");
        String typeKeyPrefix = typeKey + ".";
        boolean escapePercents = ((ModContainer)ModList.get().getModContainerById("minecraft").get()).getModInfo().getVersion().getMinorVersion() == 15;
        ForgeRegistries.ENCHANTMENTS.getValues().forEach(enchantment -> {
            String enchantmentKey = enchantment.func_77320_a();
            String descriptionKey = enchantmentKey.replace(".minecraft.", ".jeienchantmentinfo.") + ".description";
            String description = I18n.func_135052_a((String)descriptionKey, (Object[])new Object[0]);
            if (escapePercents) {
                description = description.replace("%", "%%");
            }
            if (descriptionKey.equals(description)) {
                description = missingDescription;
            }
            description = TextFormatting.BOLD + "" + TextFormatting.UNDERLINE + I18n.func_135052_a((String)enchantmentKey, (Object[])new Object[0]) + TextFormatting.RESET + "\n" + description;
            EnchantmentType type = enchantment.field_77351_y;
            ArrayList<String> types = new ArrayList<String>();
            if (type.name().equals("ALL") || type.func_77557_a(Items.field_151111_aL)) {
                types.add("vanishable");
            } else if (type.func_77557_a(Items.field_185159_cQ)) {
                types.add("breakable");
            } else {
                if (type.func_77557_a(Items.field_185160_cR)) {
                    types.add("wearable");
                } else {
                    boolean helmet = type.func_77557_a(Items.field_151028_Y);
                    boolean chestplate = type.func_77557_a(Items.field_151030_Z);
                    boolean leggings = type.func_77557_a(Items.field_151165_aa);
                    boolean boots = type.func_77557_a(Items.field_151167_ab);
                    if (helmet && chestplate && leggings && boots) {
                        types.add("armor");
                    } else {
                        if (helmet) {
                            types.add("armor.helmet");
                        }
                        if (chestplate) {
                            types.add("armor.chestplate");
                        }
                        if (leggings) {
                            types.add("armor.leggings");
                        }
                        if (boots) {
                            types.add("armor.boots");
                        }
                    }
                }
                if (type.func_77557_a(Items.field_151037_a)) {
                    types.add("tool");
                } else if (type.func_77557_a(Items.field_151036_c)) {
                    types.add("axe");
                }
                if (type.func_77557_a(Items.field_151040_l)) {
                    types.add("sword");
                }
                if (type.func_77557_a(Items.field_151112_aM)) {
                    types.add("fishing_rod");
                }
                if (type.func_77557_a(Items.field_203184_eO)) {
                    types.add("trident");
                }
                if (type.func_77557_a(Items.field_151031_f)) {
                    types.add("bow");
                }
                if (type.func_77557_a(Items.field_222114_py)) {
                    types.add("crossbow");
                }
            }
            description = description + "\n" + I18n.func_135052_a((String)typeKey, (Object[])new Object[]{types.stream().map(suffix -> I18n.func_135052_a((String)(typeKeyPrefix + suffix), (Object[])new Object[0])).collect(Collectors.joining(", "))});
            int maxLevel = enchantment.func_77325_b();
            description = description + "\n" + I18n.func_135052_a((String)maxLevelKey, (Object[])new Object[]{maxLevel});
            StringBuilder conflictBuilder = new StringBuilder();
            ForgeRegistries.ENCHANTMENTS.getValues().stream().filter(enchantment2 -> enchantment != enchantment2 && !enchantment.func_191560_c(enchantment2)).forEach(enchantment2 -> conflictBuilder.append("\n-").append(I18n.func_135052_a((String)enchantment2.func_77320_a(), (Object[])new Object[0])));
            String conflicts = conflictBuilder.toString();
            if (!conflicts.isEmpty()) {
                description = description + conflictsTitle + conflicts;
            }
            List books = IntStream.range(1, maxLevel + 1).mapToObj(i -> {
                ItemStack book = new ItemStack((IItemProvider)Items.field_151134_bR);
                EnchantedBookItem.func_92115_a((ItemStack)book, (EnchantmentData)new EnchantmentData(enchantment, i));
                return book;
            }).collect(Collectors.toList());
            registration.addIngredientInfo(books, VanillaTypes.ITEM, new String[]{description});
        });
    }

    private String getLangKey(String name) {
        return String.join((CharSequence)".", "enchantment", MOD_ID, name);
    }
}

