/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import mods.flammpfeil.slashblade.capability.inputstate.CapabilityInputState;
import mods.flammpfeil.slashblade.event.InputCommandEvent;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.InputCommand;
import mods.flammpfeil.slashblade.util.RayTraceHelper;
import mods.flammpfeil.slashblade.util.TargetSelector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class LockOnManager {
    public static LockOnManager getInstance() {
        return SingletonHolder.instance;
    }

    private LockOnManager() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onInputChange(InputCommandEvent event) {
        Entity targetEntity;
        if (event.getOld().contains((Object)InputCommand.SNEAK) == event.getCurrent().contains((Object)InputCommand.SNEAK)) {
            return;
        }
        ServerPlayerEntity player = event.getPlayer();
        ItemStack stack = event.getPlayer().func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        if (!(stack.func_77973_b() instanceof ItemSlashBlade)) {
            return;
        }
        if (event.getOld().contains((Object)InputCommand.SNEAK) && !event.getCurrent().contains((Object)InputCommand.SNEAK)) {
            targetEntity = null;
        } else {
            Optional<RayTraceResult> result = RayTraceHelper.rayTrace(player.field_70170_p, (Entity)player, player.func_174824_e(1.0f), player.func_70040_Z(), 12.0, 12.0, null);
            Optional<Entity> foundEntity = result.filter(r -> r.func_216346_c() == RayTraceResult.Type.ENTITY).filter(r -> {
                EntityRayTraceResult er = (EntityRayTraceResult)r;
                Entity target = ((EntityRayTraceResult)r).func_216348_a();
                boolean isMatch = true;
                if (target instanceof LivingEntity) {
                    isMatch = TargetSelector.lockon_focus.func_221015_a((LivingEntity)player, (LivingEntity)target);
                }
                return isMatch;
            }).map(r -> ((EntityRayTraceResult)r).func_216348_a());
            if (!foundEntity.isPresent()) {
                List entities = player.field_70170_p.func_217374_a(LivingEntity.class, TargetSelector.lockon, (LivingEntity)player, player.func_174813_aQ().func_72314_b(12.0, 6.0, 12.0));
                foundEntity = entities.stream().map(s -> s).min(Comparator.comparingDouble(e -> e.func_70068_e((Entity)player)));
            }
            targetEntity = foundEntity.orElse(null);
        }
        stack.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(s -> s.setTargetEntityId(targetEntity));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onEntityUpdate(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        if (!(stack.func_77973_b() instanceof ItemSlashBlade)) {
            return;
        }
        stack.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(s -> {
            Entity target = s.getTargetEntity(player.field_70170_p);
            if (target == null) {
                return;
            }
            if (!target.func_70089_S()) {
                return;
            }
            ClientPlayerEntity entity = player;
            if (!entity.field_70170_p.field_72995_K) {
                return;
            }
            if (!entity.getCapability(CapabilityInputState.INPUT_STATE).filter(input -> input.getCommands().contains((Object)InputCommand.SNEAK)).isPresent()) {
                return;
            }
            float partialTicks = Minecraft.func_71410_x().func_184121_ak();
            float oldYawHead = entity.field_70759_as;
            float oldYawOffset = entity.field_70761_aq;
            float oldPitch = entity.field_70125_A;
            float oldYaw = entity.field_70177_z;
            float prevYawHead = entity.field_70758_at;
            float prevYawOffset = entity.field_70760_ar;
            float prevYaw = entity.field_70126_B;
            float prevPitch = entity.field_70127_C;
            entity.func_200602_a(EntityAnchorArgument.Type.EYES, target.func_213303_ch().func_72441_c(0.0, (double)target.func_70047_e() / 2.0, 0.0));
            float step = 0.125f * partialTicks;
            step = (float)((double)step * Math.min(1.0, Math.abs((double)MathHelper.func_76142_g((float)(oldYaw - entity.field_70759_as)) * 0.5)));
            entity.field_70125_A = MathHelper.func_219805_h((float)step, (float)oldPitch, (float)entity.field_70125_A);
            entity.field_70177_z = MathHelper.func_219805_h((float)step, (float)oldYaw, (float)entity.field_70177_z);
            entity.field_70759_as = MathHelper.func_219805_h((float)step, (float)oldYawHead, (float)entity.field_70759_as);
            entity.field_70761_aq = oldYawOffset;
            entity.field_70760_ar = prevYawOffset;
            entity.field_70758_at = prevYawHead;
            entity.field_70126_B = prevYaw;
            entity.field_70127_C = prevPitch;
        });
    }

    private static final class SingletonHolder {
        private static final LockOnManager instance = new LockOnManager();

        private SingletonHolder() {
        }
    }
}

