/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.ability.Untouchable;
import mods.flammpfeil.slashblade.capability.mobeffect.CapabilityMobEffect;
import mods.flammpfeil.slashblade.entity.EntityAbstractSummonedSword;
import mods.flammpfeil.slashblade.event.InputCommandEvent;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.InputCommand;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SlayerStyleArts {
    static final EnumSet<InputCommand> fowerd_sprint_sneak = EnumSet.of(InputCommand.FORWARD, InputCommand.SPRINT, InputCommand.SNEAK);
    static final EnumSet<InputCommand> move = EnumSet.of(InputCommand.FORWARD, InputCommand.BACK, InputCommand.LEFT, InputCommand.RIGHT);

    public static SlayerStyleArts getInstance() {
        return SingletonHolder.instance;
    }

    private SlayerStyleArts() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onInputChange(InputCommandEvent event) {
        EnumSet<InputCommand> old = event.getOld();
        EnumSet<InputCommand> current = event.getCurrent();
        final ServerPlayerEntity sender = event.getPlayer();
        World worldIn = sender.field_70170_p;
        if (!old.contains((Object)InputCommand.SPRINT)) {
            boolean isHandled = false;
            if (current.containsAll(fowerd_sprint_sneak)) {
                isHandled = sender.func_184614_ca().getCapability(ItemSlashBlade.BLADESTATE).map(state -> {
                    Entity target = state.getTargetEntity(worldIn);
                    if (target == null) {
                        return false;
                    }
                    if (target == sender.func_110144_aD() && sender.field_70173_aa < sender.func_142013_aG() + 100) {
                        SlayerStyleArts.doTeleport((Entity)sender, sender.func_110144_aD());
                    } else {
                        EntityAbstractSummonedSword ss = new EntityAbstractSummonedSword(SlashBlade.RegistryEvents.SummonedSword, worldIn){

                            @Override
                            protected void onHitEntity(EntityRayTraceResult p_213868_1_) {
                                super.onHitEntity(p_213868_1_);
                                if (this.getHitEntity() == sender.func_110144_aD()) {
                                    SlayerStyleArts.doTeleport((Entity)sender, sender.func_110144_aD());
                                }
                            }
                        };
                        Vector3d lastPos = sender.func_174824_e(1.0f);
                        ss.field_70142_S = lastPos.field_72450_a;
                        ss.field_70137_T = lastPos.field_72448_b;
                        ss.field_70136_U = lastPos.field_72449_c;
                        Vector3d targetPos = target.func_213303_ch().func_72441_c(0.0, (double)target.func_213302_cg() / 2.0, 0.0).func_178787_e(sender.func_70040_Z().func_186678_a(-2.0));
                        ss.func_70107_b(targetPos.field_72450_a, targetPos.field_72448_b, targetPos.field_72449_c);
                        Vector3d dir = sender.func_70040_Z();
                        ss.func_70186_c(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c, 0.5f, 0.0f);
                        ss.func_212361_a((Entity)sender);
                        ss.setDamage(0.01f);
                        ss.setColor(state.getColorCode());
                        worldIn.func_217376_c((Entity)ss);
                        sender.func_213823_a(SoundEvents.field_187544_ad, SoundCategory.PLAYERS, 0.2f, 1.45f);
                    }
                    return true;
                }).orElse(false);
            }
            if (!isHandled && sender.func_233570_aj_() && current.contains((Object)InputCommand.SPRINT) && current.stream().anyMatch(cc -> move.contains(cc))) {
                int count = sender.getCapability(CapabilityMobEffect.MOB_EFFECT).map(ef -> ef.doAvoid(sender.field_70170_p.func_82737_E())).orElse(0);
                if (0 < count) {
                    float moveForward;
                    Untouchable.setUntouchable((LivingEntity)sender, 10);
                    float f = current.contains((Object)InputCommand.FORWARD) == current.contains((Object)InputCommand.BACK) ? 0.0f : (moveForward = current.contains((Object)InputCommand.FORWARD) ? 1.0f : -1.0f);
                    float moveStrafe = current.contains((Object)InputCommand.LEFT) == current.contains((Object)InputCommand.RIGHT) ? 0.0f : (current.contains((Object)InputCommand.LEFT) ? 1.0f : -1.0f);
                    Vector3d input = new Vector3d((double)moveStrafe, 0.0, (double)moveForward);
                    sender.func_213309_a(3.0f, input);
                    Vector3d motion = this.maybeBackOffFromEdge(sender.func_213322_ci(), (LivingEntity)sender);
                    sender.func_213823_a(SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 0.5f, 1.2f);
                    sender.func_213315_a(MoverType.SELF, motion);
                    sender.func_233576_c_(sender.func_213303_ch());
                    sender.func_184614_ca().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> state.updateComboSeq((LivingEntity)sender, state.getComboRootAir()));
                }
                isHandled = true;
            }
        }
    }

    private static void doTeleport(Entity entityIn, LivingEntity target) {
        if (!(entityIn.field_70170_p instanceof ServerWorld)) {
            return;
        }
        if (entityIn instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityIn;
            player.func_213823_a(SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 0.75f, 1.25f);
            player.func_184614_ca().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> state.updateComboSeq((LivingEntity)player, state.getComboRootAir()));
            Untouchable.setUntouchable((LivingEntity)player, 10);
        }
        ServerWorld worldIn = (ServerWorld)entityIn.field_70170_p;
        Vector3d tereportPos = target.func_213303_ch().func_72441_c(0.0, (double)target.func_213302_cg() / 2.0, 0.0).func_178787_e(entityIn.func_70040_Z().func_186678_a(-2.0));
        double x = tereportPos.field_72450_a;
        double y = tereportPos.field_72448_b;
        double z = tereportPos.field_72449_c;
        float yaw = entityIn.field_70177_z;
        float pitch = entityIn.field_70125_A;
        Set relativeList = Collections.emptySet();
        BlockPos blockpos = new BlockPos(x, y, z);
        if (!World.func_234935_k_((BlockPos)blockpos)) {
            return;
        }
        if (entityIn instanceof ServerPlayerEntity) {
            ChunkPos chunkpos = new ChunkPos(new BlockPos(x, y, z));
            worldIn.func_72863_F().func_217228_a(TicketType.field_223185_g, chunkpos, 1, (Object)entityIn.func_145782_y());
            entityIn.func_184210_p();
            if (((ServerPlayerEntity)entityIn).func_70608_bn()) {
                ((ServerPlayerEntity)entityIn).func_225652_a_(true, true);
            }
            if (worldIn == entityIn.field_70170_p) {
                ((ServerPlayerEntity)entityIn).field_71135_a.func_175089_a(x, y, z, yaw, pitch, relativeList);
            } else {
                ((ServerPlayerEntity)entityIn).func_200619_a(worldIn, x, y, z, yaw, pitch);
            }
            entityIn.func_70034_d(yaw);
        } else {
            float f1 = MathHelper.func_76142_g((float)yaw);
            float f = MathHelper.func_76142_g((float)pitch);
            f = MathHelper.func_76131_a((float)f, (float)-90.0f, (float)90.0f);
            if (worldIn == entityIn.field_70170_p) {
                entityIn.func_70012_b(x, y, z, f1, f);
                entityIn.func_70034_d(f1);
            } else {
                entityIn.func_213319_R();
                Entity entity = entityIn;
                entityIn = entityIn.func_200600_R().func_200721_a((World)worldIn);
                if (entityIn == null) {
                    return;
                }
                entityIn.func_180432_n(entity);
                entityIn.func_70012_b(x, y, z, f1, f);
                entityIn.func_70034_d(f1);
                worldIn.func_217460_e(entityIn);
            }
        }
        if (!(entityIn instanceof LivingEntity) || !((LivingEntity)entityIn).func_184613_cA()) {
            entityIn.func_213317_d(entityIn.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
            entityIn.func_230245_c_(false);
        }
        if (entityIn instanceof CreatureEntity) {
            ((CreatureEntity)entityIn).func_70661_as().func_75499_g();
        }
    }

    protected Vector3d maybeBackOffFromEdge(Vector3d vec, LivingEntity mover) {
        double d0 = vec.field_72450_a;
        double d1 = vec.field_72449_c;
        double d2 = 0.05;
        while (d0 != 0.0 && mover.field_70170_p.func_226665_a__((Entity)mover, mover.func_174813_aQ().func_72317_d(d0, (double)(-mover.field_70138_W), 0.0))) {
            if (d0 < 0.05 && d0 >= -0.05) {
                d0 = 0.0;
                continue;
            }
            if (d0 > 0.0) {
                d0 -= 0.05;
                continue;
            }
            d0 += 0.05;
        }
        while (d1 != 0.0 && mover.field_70170_p.func_226665_a__((Entity)mover, mover.func_174813_aQ().func_72317_d(0.0, (double)(-mover.field_70138_W), d1))) {
            if (d1 < 0.05 && d1 >= -0.05) {
                d1 = 0.0;
                continue;
            }
            if (d1 > 0.0) {
                d1 -= 0.05;
                continue;
            }
            d1 += 0.05;
        }
        while (d0 != 0.0 && d1 != 0.0 && mover.field_70170_p.func_226665_a__((Entity)mover, mover.func_174813_aQ().func_72317_d(d0, (double)(-mover.field_70138_W), d1))) {
            d0 = d0 < 0.05 && d0 >= -0.05 ? 0.0 : (d0 > 0.0 ? (d0 -= 0.05) : (d0 += 0.05));
            if (d1 < 0.05 && d1 >= -0.05) {
                d1 = 0.0;
                continue;
            }
            if (d1 > 0.0) {
                d1 -= 0.05;
                continue;
            }
            d1 += 0.05;
        }
        vec = new Vector3d(d0, vec.field_72448_b, d1);
        return vec;
    }

    private static final class SingletonHolder {
        private static final SlayerStyleArts instance = new SlayerStyleArts();

        private SingletonHolder() {
        }
    }
}

