/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import java.util.Optional;
import mods.flammpfeil.slashblade.ability.StunManager;
import mods.flammpfeil.slashblade.capability.mobeffect.CapabilityMobEffect;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class Untouchable {
    static final int JUMP_TICKS = 10;

    public static Untouchable getInstance() {
        return SingletonHolder.instance;
    }

    private Untouchable() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void setUntouchable(LivingEntity entity, int ticks) {
        entity.getCapability(CapabilityMobEffect.MOB_EFFECT).ifPresent(ef -> {
            ef.setManagedUntouchable(entity.field_70170_p.func_82737_E(), ticks);
            ef.storeEffects(entity.func_193076_bZ().keySet());
            ef.storeHealth(entity.func_110143_aJ());
        });
    }

    private boolean checkUntouchable(LivingEntity entity) {
        Optional isUntouchable = entity.getCapability(CapabilityMobEffect.MOB_EFFECT).map(ef -> ef.isUntouchable(entity.func_130014_f_().func_82737_E()));
        return isUntouchable.orElseGet(() -> false);
    }

    private void doWitchTime(Entity entity) {
        if (entity == null) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        StunManager.setStun((LivingEntity)entity);
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        if (this.checkUntouchable(event.getEntityLiving())) {
            event.setCanceled(true);
            this.doWitchTime(event.getSource().func_76346_g());
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent event) {
        if (this.checkUntouchable(event.getEntityLiving())) {
            event.setCanceled(true);
            this.doWitchTime(event.getSource().func_76346_g());
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (this.checkUntouchable(event.getEntityLiving())) {
            event.setCanceled(true);
            this.doWitchTime(event.getSource().func_76346_g());
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (this.checkUntouchable(event.getEntityLiving())) {
            event.setCanceled(true);
            this.doWitchTime(event.getSource().func_76346_g());
            LivingEntity entity = event.getEntityLiving();
            entity.getCapability(CapabilityMobEffect.MOB_EFFECT).ifPresent(ef -> {
                if (ef.hasUntouchableWorked()) {
                    entity.func_193076_bZ().keySet().stream().filter(p -> !ef.getEffectSet().contains(p) && !p.func_188408_i()).forEach(p -> entity.func_195063_d(p));
                    float storedHealth = ef.getStoredHealth();
                    if (ef.getStoredHealth() < storedHealth) {
                        entity.func_70606_j(ef.getStoredHealth());
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void onLivingTicks(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        entity.getCapability(CapabilityMobEffect.MOB_EFFECT).ifPresent(ef -> {
            if (ef.hasUntouchableWorked()) {
                ef.setUntouchableWorked(false);
                entity.func_193076_bZ().keySet().stream().filter(p -> !ef.getEffectSet().contains(p) && !p.func_188408_i()).forEach(p -> entity.func_195063_d(p));
                float storedHealth = ef.getStoredHealth();
                if (ef.getStoredHealth() < storedHealth) {
                    entity.func_70606_j(ef.getStoredHealth());
                }
            }
        });
    }

    @SubscribeEvent
    public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        if (!event.getEntityLiving().func_184614_ca().getCapability(ItemSlashBlade.BLADESTATE).isPresent()) {
            return;
        }
        Untouchable.setUntouchable(event.getEntityLiving(), 10);
    }

    private static final class SingletonHolder {
        private static final Untouchable instance = new Untouchable();

        private SingletonHolder() {
        }
    }
}

