/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.capability.slashblade;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class BladeStateCapabilityProvider
implements ICapabilityProvider,
INBTSerializable<CompoundNBT> {
    @CapabilityInject(value=ISlashBladeState.class)
    public static Capability<ISlashBladeState> CAP = null;
    @CapabilityInject(value=IEnergyStorage.class)
    public static Capability<IEnergyStorage> ENERGY = null;
    protected LazyOptional<ISlashBladeState> state = LazyOptional.of(() -> CAP.getDefaultInstance());
    protected LazyOptional<IEnergyStorage> storage = LazyOptional.of(() -> new EnergyStorage(1000000));
    static final int defaultCapacity = 1000000;
    private final String tagState = "State";
    private final String tagEnergy = "Energy";

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ENERGY) {
            return this.state.filter(iSlashBladeState -> iSlashBladeState.hasEnergy()).isPresent() ? this.storage.cast() : LazyOptional.empty();
        }
        return CAP.orEmpty(cap, this.state);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT baseTag = new CompoundNBT();
        this.state.ifPresent(iSlashBladeState -> baseTag.func_218657_a("State", CAP.writeNBT(iSlashBladeState, null)));
        this.storage.ifPresent(iEnergyStorage -> baseTag.func_218657_a("Energy", ENERGY.writeNBT(iEnergyStorage, null)));
        return baseTag;
    }

    public void deserializeNBT(CompoundNBT baseTag) {
        this.state.ifPresent(iSlashBladeState -> CAP.readNBT(iSlashBladeState, null, baseTag.func_74781_a("State")));
        this.storage.ifPresent(iEnergyStorage -> ENERGY.readNBT(iEnergyStorage, null, baseTag.func_74781_a("Energy")));
    }
}

