/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.capability.slashblade;

import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mods.flammpfeil.slashblade.ability.ArrowReflector;
import mods.flammpfeil.slashblade.ability.StunManager;
import mods.flammpfeil.slashblade.capability.inputstate.IInputState;
import mods.flammpfeil.slashblade.capability.slashblade.combo.Extra;
import mods.flammpfeil.slashblade.event.FallHandler;
import mods.flammpfeil.slashblade.event.KnockBackHandler;
import mods.flammpfeil.slashblade.event.client.UserPoseOverrider;
import mods.flammpfeil.slashblade.init.DefaultResources;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.specialattack.JudgementCut;
import mods.flammpfeil.slashblade.specialattack.SlashArts;
import mods.flammpfeil.slashblade.util.AttackManager;
import mods.flammpfeil.slashblade.util.InputCommand;
import mods.flammpfeil.slashblade.util.KnockBacks;
import mods.flammpfeil.slashblade.util.RegistryBase;
import mods.flammpfeil.slashblade.util.TimeValueHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public class ComboState
extends RegistryBase<ComboState> {
    @CapabilityInject(value=IInputState.class)
    public static Capability<IInputState> INPUT_STATE = null;
    public static final ComboState NONE = new ComboState(BaseInstanceName, 1000, () -> 0, () -> 1, () -> Float.valueOf(1.0f), () -> true, () -> 0, DefaultResources.ExMotionLocation, a -> NONE, () -> NONE).addTickAction(e -> UserPoseOverrider.resetRot((Entity)e));
    static List<Map.Entry<EnumSet<InputCommand>, Supplier<ComboState>>> standbyMap = new HashMap<EnumSet<InputCommand>, Supplier<ComboState>>(){
        {
            this.put(EnumSet.of(InputCommand.ON_GROUND, InputCommand.SNEAK, InputCommand.FORWARD, InputCommand.R_CLICK), () -> ARTS_RAPID_SLASH);
            this.put(EnumSet.of(InputCommand.ON_GROUND, InputCommand.L_CLICK), () -> COMBO_B1);
            this.put(EnumSet.of(InputCommand.ON_GROUND, InputCommand.BACK, InputCommand.SNEAK, InputCommand.R_CLICK), () -> COMBO_B1);
            this.put(EnumSet.of(InputCommand.ON_GROUND, InputCommand.R_CLICK), () -> COMBO_A1);
            this.put(EnumSet.of(InputCommand.ON_AIR, InputCommand.SNEAK, InputCommand.FORWARD, InputCommand.R_CLICK), () -> ARTS_HELM_BREAKER);
            this.put(EnumSet.of(InputCommand.ON_AIR), () -> COMBO_AA1);
        }
    }.entrySet().stream().collect(Collectors.toList());
    public static final ComboState STANDBY = new ComboState("standby_old", 10, () -> 30, () -> 31, () -> Float.valueOf(1.0f), () -> true, () -> 1000, DefaultResources.BaseMotionLocation, a -> {
        EnumSet commands = a.getCapability(INPUT_STATE).map(state -> state.getCommands((LivingEntity)a)).orElseGet(() -> EnumSet.noneOf(InputCommand.class));
        return standbyMap.stream().filter(entry -> commands.containsAll((Collection)entry.getKey())).min(Comparator.comparingInt(entry -> ((ComboState)((Object)((Object)((Object)((Supplier)entry.getValue()).get())))).getPriority())).map(entry -> (ComboState)((Object)((Object)((Object)((Supplier)entry.getValue()).get())))).orElseGet(() -> NONE);
    }, () -> NONE);
    public static final ComboState COMBO_A1 = new ComboState("combo_a1", 100, () -> 60, () -> 70, () -> Float.valueOf(1.5f), () -> false, () -> 1000, DefaultResources.BaseMotionLocation, a -> COMBO_A2, () -> NONE).setClickAction(e -> AttackManager.areaAttack(e, KnockBackHandler::setCancel)).addHitEffect(StunManager::setStun);
    public static final ComboState COMBO_A2 = new ComboState("combo_a2", 100, () -> 70, () -> 80, () -> Float.valueOf(1.5f), () -> false, () -> 1000, DefaultResources.BaseMotionLocation, a -> COMBO_A3, () -> NONE).setClickAction(e -> AttackManager.areaAttack(e, KnockBackHandler::setCancel)).addHitEffect(StunManager::setStun);
    public static final ComboState COMBO_A3 = new ComboState("combo_a3", 100, () -> 80, () -> 90, () -> Float.valueOf(1.75f), () -> false, () -> 600, DefaultResources.BaseMotionLocation, a -> NONE, () -> COMBO_A3_F).setClickAction(e -> AttackManager.areaAttack(e, ee -> KnockBackHandler.setSmash(ee, 1.5)));
    public static final ComboState COMBO_A3_F = new ComboState("combo_a3_f", 100, () -> 90, () -> 120, () -> Float.valueOf(1.5f), () -> false, () -> 2000, DefaultResources.BaseMotionLocation, a -> NONE, () -> NONE);
    private static final EnumSet<InputCommand> combo_b1_alt = EnumSet.of(InputCommand.BACK, InputCommand.R_DOWN);
    public static final ComboState COMBO_B1 = new ComboState("combo_b1", 90, () -> 150, () -> 160, () -> Float.valueOf(1.0f), () -> false, () -> 1000, DefaultResources.BaseMotionLocation, a -> COMBO_B2, () -> COMBO_B1_F).setClickAction(e -> AttackManager.areaAttack(e, ee -> KnockBackHandler.setVertical(ee, 0.5))).addHoldAction(player -> {
        int elapsed = player.func_184612_cw();
        EnumSet commands = player.getCapability(INPUT_STATE).map(state -> state.getCommands((LivingEntity)player)).orElseGet(() -> EnumSet.noneOf(InputCommand.class));
        if (5 == elapsed && commands.containsAll(combo_b1_alt)) {
            Vector3d motion = player.func_213322_ci();
            player.func_213293_j(motion.field_72450_a, motion.field_72448_b + 0.7, motion.field_72449_c);
            player.func_230245_c_(false);
            player.field_70160_al = true;
        }
    }).addHitEffect((e, a) -> StunManager.setStun(e, 15L)).addTickAction(playerIn -> FallHandler.fallDecrease(playerIn));
    public static final ComboState COMBO_B1_F = new ComboState("combo_b1_f", 100, () -> 165, () -> 185, () -> Float.valueOf(1.0f), () -> false, () -> 1000, DefaultResources.BaseMotionLocation, a -> NONE, () -> NONE).addTickAction(playerIn -> FallHandler.fallDecrease(playerIn));
    public static final ComboState COMBO_B2 = new ComboState("combo_b2", 90, () -> 200, () -> 215, () -> Float.valueOf(1.0f), () -> false, () -> 1000, DefaultResources.BaseMotionLocation, a -> NONE, () -> COMBO_B2_F).addHitEffect(StunManager::setStun).setClickAction(e -> AttackManager.areaAttack(e, ee -> KnockBackHandler.setVertical(ee, -5.0)));
    public static final ComboState COMBO_B2_F = new ComboState("combo_b2_f", 100, () -> 215, () -> 240, () -> Float.valueOf(1.0f), () -> false, () -> 1000, DefaultResources.BaseMotionLocation, a -> NONE, () -> NONE);
    public static final ComboState COMBO_AA1 = new ComboState("combo_aa1", 80, () -> 245, () -> 270, () -> Float.valueOf(1.0f), () -> false, () -> 500, DefaultResources.BaseMotionLocation, a -> COMBO_AA2, () -> COMBO_AA1_F).setClickAction(e -> AttackManager.areaAttack(e, KnockBackHandler::setCancel)).setIsAerial().addTickAction(playerIn -> {
        FallHandler.fallDecrease(playerIn);
        playerIn.func_184614_ca().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
            long elapsed = state.getElapsedTime((LivingEntity)playerIn);
            if (elapsed == 4L) {
                AttackManager.areaAttack(playerIn, KnockBackHandler::setCancel);
            }
        });
    }).addHitEffect(StunManager::setStun).setIsAerial();
    public static final ComboState COMBO_AA1_F = new ComboState("combo_aa1_f", 80, () -> 269, () -> 270, () -> Float.valueOf(20.0f), () -> true, () -> 1000, DefaultResources.BaseMotionLocation, a -> COMBO_AA2, () -> NONE);
    public static final ComboState COMBO_AA2 = new ComboState("combo_aa2", 80, () -> 270, () -> 295, () -> Float.valueOf(1.0f), () -> false, () -> 1000, DefaultResources.BaseMotionLocation, a -> NONE, () -> COMBO_AA2_F).setClickAction(e -> AttackManager.areaAttack(e, ee -> KnockBackHandler.setSmash(ee, 1.5))).setIsAerial().addTickAction(playerIn -> FallHandler.fallDecrease(playerIn));
    public static final ComboState COMBO_AA2_F = new ComboState("combo_aa2_f", 100, () -> 295, () -> 300, () -> Float.valueOf(1.0f), () -> false, () -> 400, DefaultResources.BaseMotionLocation, a -> NONE, () -> NONE).addTickAction(playerIn -> FallHandler.fallDecrease(playerIn));
    public static final ComboState ARTS_RAPID_SLASH = new ComboState("arts_rapid_slash", 70, () -> 80, () -> 90, () -> Float.valueOf(1.0f), () -> false, () -> 1000, DefaultResources.BaseMotionLocation, a -> ARTS_RAPID_SLASH_F, () -> ARTS_RAPID_SLASH_F).setClickAction(e -> AttackManager.areaAttack(e, KnockBackHandler::setCancel)).addHitEffect(StunManager::setStun).addHoldAction(playerIn -> {
        int elapsed = playerIn.func_184612_cw();
        if (elapsed < 6) {
            playerIn.func_184614_ca().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> AttackManager.areaAttack(playerIn, KnockBackHandler::setCancel, 1.0f, false, false, true));
            if (elapsed % 3 == 1) {
                playerIn.field_70170_p.func_184148_a((PlayerEntity)null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187730_dW, SoundCategory.PLAYERS, 0.5f, 0.4f / (playerIn.func_70681_au().nextFloat() * 0.4f + 0.8f));
            }
        }
        if (elapsed <= 3 && playerIn.func_233570_aj_()) {
            playerIn.func_213309_a(playerIn.func_70090_H() ? 0.35f : 0.8f, new Vector3d(0.0, 0.0, 1.0));
        }
        if (elapsed == 10 && (!playerIn.field_70170_p.field_72995_K || playerIn.func_233570_aj_())) {
            playerIn.func_184614_ca().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
                ComboState combo = ARTS_RISING_STAR;
                state.setComboSeq(combo);
                state.setLastActionTime(playerIn.field_70170_p.func_82737_E());
                combo.clickAction((LivingEntity)playerIn);
            });
        }
    });
    public static final ComboState ARTS_RAPID_SLASH_F = new ComboState("arts_rapid_slash_f", 70, () -> 90, () -> 120, () -> Float.valueOf(1.0f), () -> false, () -> 1000, DefaultResources.BaseMotionLocation, a -> NONE, () -> NONE);
    public static final ComboState ARTS_RISING_STAR = new ComboState("arts_rising_star", 100, () -> 250, () -> 255, () -> Float.valueOf(0.75f), () -> false, () -> 1000, DefaultResources.BaseMotionLocation, a -> NONE, () -> COMBO_A3_F).addHitEffect(StunManager::setStun).setIsAerial().setClickAction(playerIn -> {
        AttackManager.areaAttack(playerIn, ee -> KnockBackHandler.setVertical(ee, 0.5), 1.0f, true, false, false);
        Vector3d motion = playerIn.func_213322_ci();
        playerIn.func_213293_j(0.0, motion.field_72448_b + 0.7, 0.0);
        playerIn.func_230245_c_(false);
        playerIn.field_70160_al = true;
    }).addHoldAction(playerIn -> {
        int elapsed = playerIn.func_184612_cw();
        if (elapsed < 6) {
            playerIn.func_184614_ca().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> AttackManager.areaAttack(playerIn, ee -> KnockBackHandler.setVertical(ee, 0.5), 1.0f, false, false, true));
            if (elapsed % 2 == 1) {
                playerIn.field_70170_p.func_184148_a((PlayerEntity)null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187730_dW, SoundCategory.PLAYERS, 0.5f, 0.4f / (playerIn.func_70681_au().nextFloat() * 0.4f + 0.8f));
            }
        }
    }).addTickAction(playerIn -> FallHandler.fallDecrease(playerIn));
    public static final ComboState ARTS_HELM_BREAKER = new ComboState("arts_helm_breaker", 70, () -> 200, () -> 215, () -> Float.valueOf(1.0f), () -> false, () -> 1000, DefaultResources.BaseMotionLocation, a -> NONE, () -> ARTS_HELM_BREAKER_F).addHitEffect(StunManager::setStun).setClickAction(playerIn -> {
        AttackManager.areaAttack(playerIn, KnockBacks.meteor.action, 1.0f, true, false, false);
        Vector3d motion = playerIn.func_213322_ci();
        playerIn.func_213293_j(motion.field_72450_a, motion.field_72448_b - 0.7, motion.field_72449_c);
    }).addHoldAction(playerIn -> {
        int elapsed = playerIn.func_184612_cw();
        if (!playerIn.func_233570_aj_()) {
            playerIn.func_184614_ca().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> AttackManager.areaAttack(playerIn, ee -> KnockBackHandler.setVertical(ee, -5.0), 1.0f, false, false, true));
            if (elapsed % 2 == 1) {
                playerIn.field_70170_p.func_184148_a((PlayerEntity)null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187730_dW, SoundCategory.PLAYERS, 0.5f, 0.4f / (playerIn.func_70681_au().nextFloat() * 0.4f + 0.8f));
            }
        }
    }).addTickAction(playerIn -> {
        if (!playerIn.func_233570_aj_()) {
            playerIn.field_70143_R = 1.0f;
        } else {
            playerIn.func_184614_ca().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
                AttackManager.areaAttack(playerIn, ee -> KnockBackHandler.setVertical(ee, -5.0), 1.3f, true, true, true);
                state.setComboSeq(ARTS_HELM_BREAKER_F);
                state.setLastActionTime(playerIn.field_70170_p.func_82737_E());
                FallHandler.spawnLandingParticle(playerIn, 20.0f);
            });
        }
    });
    public static final ComboState ARTS_HELM_BREAKER_F = new ComboState("arts_helm_breaker_f", 70, () -> 214, () -> 215, () -> Float.valueOf(20.0f), () -> true, () -> 600, DefaultResources.BaseMotionLocation, a -> NONE, () -> COMBO_B2_F);
    static final EnumSet<InputCommand> jc_cycle_input = EnumSet.of(InputCommand.L_DOWN, InputCommand.R_CLICK);
    static final RangeMap<Long, SlashArts.ArtsType> jc_cycle_accept = ImmutableRangeMap.builder().put(Range.lessThan((Comparable)Long.valueOf(7L)), (Object)SlashArts.ArtsType.Fail).put(Range.closedOpen((Comparable)Long.valueOf(7L), (Comparable)Long.valueOf(8L)), (Object)SlashArts.ArtsType.Jackpot).put(Range.closed((Comparable)Long.valueOf(8L), (Comparable)Long.valueOf(9L)), (Object)SlashArts.ArtsType.Success).put(Range.greaterThan((Comparable)Long.valueOf(9L)), (Object)SlashArts.ArtsType.Fail).build();
    public static final ComboState SLASH_ARTS_JC = new ComboState("slash_arts_jc", 50, () -> 115, () -> 120, () -> Float.valueOf(0.5f), () -> false, () -> 600, DefaultResources.BaseMotionLocation, a -> {
        EnumSet commands = a.getCapability(INPUT_STATE).map(state -> state.getCommands((LivingEntity)a)).orElseGet(() -> EnumSet.noneOf(InputCommand.class));
        if (commands.containsAll(jc_cycle_input)) {
            return a.func_184614_ca().getCapability(ItemSlashBlade.BLADESTATE).map(s -> {
                long time = a.field_70170_p.func_82737_E();
                long lastAction = s.getLastActionTime();
                long count = time - lastAction;
                SlashArts.ArtsType type = (SlashArts.ArtsType)((Object)((Object)((Object)jc_cycle_accept.get((Comparable)Long.valueOf(count)))));
                return s.getSlashArts().doArts(type, (LivingEntity)a);
            }).orElse(NONE);
        }
        return NONE;
    }, () -> NONE).addTickAction(playerIn -> FallHandler.fallResist(playerIn)).addTickAction(TimeLineTickAction.getBuilder().put(0, JudgementCut::doJudgementCut).build());
    public static ComboState ExtraStandBy = Extra.STANDBY_EX;
    private ResourceLocation motionLoc;
    private Supplier<Integer> start;
    private Supplier<Integer> end;
    private Supplier<Float> speed;
    private Supplier<Boolean> roop;
    public Supplier<Integer> timeout;
    private Function<LivingEntity, ComboState> next;
    private Supplier<ComboState> nextOfTimeout;
    private Consumer<LivingEntity> holdAction;
    private Consumer<LivingEntity> tickAction;
    private BiConsumer<LivingEntity, LivingEntity> hitEffect;
    private Consumer<LivingEntity> clickAction;
    private BiFunction<LivingEntity, Integer, SlashArts.ArtsType> releaseAction;
    private boolean isAerial;
    private int priority;

    public ResourceLocation getMotionLoc() {
        return this.motionLoc;
    }

    public int getStartFrame() {
        return this.start.get();
    }

    public int getEndFrame() {
        return this.end.get();
    }

    public float getSpeed() {
        return this.speed.get().floatValue();
    }

    public boolean getRoop() {
        return this.roop.get();
    }

    public int getTimeoutMS() {
        return (int)(TimeValueHelper.getMSecFromFrames(Math.abs(this.getEndFrame() - this.getStartFrame())) / (double)this.getSpeed()) + this.timeout.get();
    }

    public void holdAction(LivingEntity user) {
        this.holdAction.accept(user);
    }

    public ComboState addHoldAction(Consumer<LivingEntity> holdAction) {
        this.holdAction = this.holdAction.andThen(holdAction);
        return this;
    }

    public void tickAction(LivingEntity user) {
        this.tickAction.accept(user);
    }

    public ComboState addTickAction(Consumer<LivingEntity> tickAction) {
        this.tickAction = this.tickAction.andThen(tickAction);
        return this;
    }

    public void hitEffect(LivingEntity target, LivingEntity attacker) {
        this.hitEffect.accept(target, attacker);
    }

    public ComboState addHitEffect(BiConsumer<LivingEntity, LivingEntity> hitEffect) {
        this.hitEffect = this.hitEffect.andThen(hitEffect);
        return this;
    }

    public void clickAction(LivingEntity user) {
        this.clickAction.accept(user);
    }

    public ComboState setClickAction(Consumer<LivingEntity> clickAction) {
        this.clickAction = clickAction;
        return this;
    }

    public SlashArts.ArtsType releaseAction(LivingEntity user, int elapsed) {
        return this.releaseAction.apply(user, elapsed);
    }

    public ComboState setReleaseAction(BiFunction<LivingEntity, Integer, SlashArts.ArtsType> clickAction) {
        this.releaseAction = clickAction;
        return this;
    }

    public ComboState(String name, int priority, Supplier<Integer> start, Supplier<Integer> end, Supplier<Float> speed, Supplier<Boolean> roop, Supplier<Integer> timeout, ResourceLocation motionLoc, Function<LivingEntity, ComboState> next, Supplier<ComboState> nextOfTimeout) {
        super(name);
        this.start = start;
        this.end = end;
        this.speed = speed;
        this.timeout = timeout;
        this.roop = roop;
        this.motionLoc = motionLoc;
        this.next = next;
        this.nextOfTimeout = nextOfTimeout;
        this.holdAction = a -> {};
        this.tickAction = ArrowReflector::doTicks;
        this.hitEffect = (a, b) -> {};
        this.clickAction = user -> {};
        this.releaseAction = (u, e) -> SlashArts.ArtsType.Fail;
        this.isAerial = false;
        this.priority = priority;
    }

    @Override
    public String getPath() {
        return "combostate";
    }

    @Override
    public ComboState getNone() {
        return NONE;
    }

    public ComboState getNext(LivingEntity living) {
        return this.next.apply(living);
    }

    public ComboState getNextOfTimeout() {
        return this.nextOfTimeout.get();
    }

    @Nonnull
    public ComboState checkTimeOut(float msec) {
        return (float)this.getTimeoutMS() < msec ? this.nextOfTimeout.get() : this;
    }

    public boolean isAerial() {
        return this.isAerial;
    }

    public ComboState setIsAerial() {
        this.isAerial = true;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public static SlashArts.ArtsType releaseActionQuickCharge(LivingEntity user, Integer elapsed) {
        int level = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_234847_l_, (LivingEntity)user);
        if (elapsed <= 3 + level) {
            return SlashArts.ArtsType.Jackpot;
        }
        return SlashArts.ArtsType.Fail;
    }

    public static long getElapsed(LivingEntity livingEntity) {
        return livingEntity.func_184614_ca().getCapability(ItemSlashBlade.BLADESTATE).map(state -> state.getElapsedTime(livingEntity)).orElseGet(() -> 0L);
    }

    public static class TimeLineTickAction
    implements Consumer<LivingEntity> {
        long offset = -1L;
        Map<Integer, Consumer<LivingEntity>> timeLine = Maps.newHashMap();

        public static TimeLineTickActionBuilder getBuilder() {
            return new TimeLineTickActionBuilder();
        }

        TimeLineTickAction(Map<Integer, Consumer<LivingEntity>> timeLine) {
            this.timeLine.putAll(timeLine);
        }

        @Override
        public void accept(LivingEntity livingEntity) {
            long elapsed = ComboState.getElapsed(livingEntity);
            if (this.offset < 0L) {
                this.offset = elapsed;
            }
            Consumer<LivingEntity> action = this.timeLine.getOrDefault((int)(elapsed -= this.offset), this::defaultConsumer);
            action.accept(livingEntity);
        }

        void defaultConsumer(LivingEntity entityIn) {
        }

        public static class TimeLineTickActionBuilder {
            Map<Integer, Consumer<LivingEntity>> timeLine = Maps.newHashMap();

            public TimeLineTickActionBuilder put(int ticks, Consumer<LivingEntity> action) {
                this.timeLine.put(ticks, action);
                return this;
            }

            public TimeLineTickAction build() {
                return new TimeLineTickAction(this.timeLine);
            }
        }
    }

    public static class TimeoutNext
    implements Function<LivingEntity, ComboState> {
        long timeout;
        Function<LivingEntity, ComboState> next;

        public static TimeoutNext buildFromFrame(int timeoutFrame, Function<LivingEntity, ComboState> next) {
            return new TimeoutNext((int)TimeValueHelper.getTicksFromFrames(timeoutFrame), next);
        }

        public TimeoutNext(long timeout, Function<LivingEntity, ComboState> next) {
            this.timeout = timeout;
            this.next = next;
        }

        @Override
        public ComboState apply(LivingEntity livingEntity) {
            long elapsed = ComboState.getElapsed(livingEntity);
            if (this.timeout <= elapsed) {
                return this.next.apply(livingEntity);
            }
            return livingEntity.func_184614_ca().getCapability(ItemSlashBlade.BLADESTATE).map(state -> state.getComboSeq()).orElseGet(() -> NONE);
        }
    }
}

