/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import mods.flammpfeil.slashblade.capability.inputstate.CapabilityInputState;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.Face;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.InputCommand;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class LockonCircleRender {
    static final ResourceLocation modelLoc = new ResourceLocation("slashblade", "model/util/lockon.obj");
    static final ResourceLocation textureLoc = new ResourceLocation("slashblade", "model/util/lockon.png");

    public static LockonCircleRender getInstance() {
        return SingletonHolder.instance;
    }

    private LockonCircleRender() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onRenderLiving(RenderWorldLastEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (!player.getCapability(CapabilityInputState.INPUT_STATE).filter(input -> input.getCommands().contains((Object)InputCommand.SNEAK)).isPresent()) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        if (!(stack.func_77973_b() instanceof ItemSlashBlade)) {
            return;
        }
        stack.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(arg_0 -> LockonCircleRender.lambda$onRenderLiving$1((PlayerEntity)player, event, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$onRenderLiving$1(PlayerEntity player, RenderWorldLastEvent event, ISlashBladeState s) {
        Entity tmpTarget = s.getTargetEntity(player.field_70170_p);
        if (tmpTarget == null) {
            return;
        }
        if (!tmpTarget.func_70089_S()) {
            return;
        }
        if (!tmpTarget.func_203003_aK()) {
            return;
        }
        LivingEntity target = (LivingEntity)tmpTarget;
        float health = 1.0f - target.func_110143_aJ() / target.func_110138_aP();
        float partialTicks = event.getPartialTicks();
        ActiveRenderInfo ari = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        Vector3d pos = target.func_174824_e(partialTicks).func_178786_a(0.0, (double)target.func_70047_e() / 2.0, 0.0).func_178788_d(ari.func_216785_c());
        float[] col = s.getEffectColor().getColorComponents(null);
        float alpha = 0.6640625f;
        try {
            RenderSystem.pushMatrix();
            RenderSystem.multMatrix((Matrix4f)event.getMatrixStack().func_227866_c_().func_227870_a_());
            RenderSystem.translated((double)pos.field_72450_a, (double)pos.field_72448_b, (double)pos.field_72449_c);
            double scale = 0.00625;
            RenderSystem.scaled((double)scale, (double)scale, (double)scale);
            double rotYaw = ari.func_216778_f();
            double rotPitch = ari.func_216777_e();
            RenderSystem.rotatef((float)((float)(rotYaw + 180.0)), (float)0.0f, (float)-1.0f, (float)0.0f);
            RenderSystem.rotatef((float)((float)rotPitch), (float)-1.0f, (float)0.0f, (float)0.0f);
            RenderSystem.disableCull();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.alphaFunc((int)519, (float)0.05f);
            RenderSystem.enableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.depthFunc((int)519);
            RenderSystem.shadeModel((int)7425);
            WavefrontObject model = BladeModelManager.getInstance().getModel(modelLoc);
            ResourceLocation resourceTexture = textureLoc;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceTexture);
            BufferBuilder bb = Tessellator.func_178181_a().func_178180_c();
            bb.func_181668_a(4, WavefrontObject.POSITION_TEX_LMAP_COL_NORMAL);
            Face.setCol(new Color(s.getEffectColor().getRGB() & 0xFFFFFF | 0xAA000000, true));
            model.tessellatePart((IVertexBuilder)bb, "lockonBase");
            Tessellator.func_178181_a().func_78381_a();
            try {
                RenderSystem.pushMatrix();
                RenderSystem.translatef((float)0.0f, (float)0.0f, (float)(health * 10.0f));
                bb.func_181668_a(4, WavefrontObject.POSITION_TEX_LMAP_COL_NORMAL);
                Face.setCol(new Color(0, true));
                model.tessellatePart((IVertexBuilder)bb, "lockonHealthMask");
                Tessellator.func_178181_a().func_78381_a();
            }
            finally {
                RenderSystem.popMatrix();
            }
            RenderSystem.depthFunc((int)515);
            bb.func_181668_a(4, WavefrontObject.POSITION_TEX_LMAP_COL_NORMAL);
            Face.setCol(new Color(s.getEffectColor().getRGB() & 0xFFFFFF | 0xAA000000, true));
            model.tessellatePart((IVertexBuilder)bb, "lockonHealth");
            Tessellator.func_178181_a().func_78381_a();
            Face.resetCol();
            RenderSystem.alphaFunc((int)518, (float)0.01f);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.shadeModel((int)7424);
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            RenderSystem.disableFog();
            RenderSystem.defaultBlendFunc();
        }
        finally {
            RenderSystem.popMatrix();
        }
    }

    private static final class SingletonHolder {
        private static final LockonCircleRender instance = new LockonCircleRender();

        private SingletonHolder() {
        }
    }
}

