/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.EnumSet;
import mods.flammpfeil.slashblade.client.renderer.model.BladeFirstPersonRender;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModel;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import mods.flammpfeil.slashblade.entity.BladeStandEntity;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.item.SwordType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.entity.Pose;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class SlashBladeTEISR
extends ItemStackTileEntityRenderer {
    private void bindTexture(ResourceLocation res) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(res);
    }

    public void func_239207_a_(ItemStack itemStackIn, ItemCameraTransforms.TransformType type, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!(itemStackIn.func_77973_b() instanceof ItemSlashBlade)) {
            return;
        }
        ItemSlashBlade item = (ItemSlashBlade)itemStackIn.func_77973_b();
        CompoundNBT capsTag = itemStackIn.func_179543_a("SlashBladeIcon");
        if (capsTag != null) {
            itemStackIn.readShareTag(capsTag);
            itemStackIn.func_196083_e("SlashBladeIcon");
        }
        this.renderBlade(itemStackIn, type, matrixStack, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    boolean checkRenderNaked() {
        ItemStack mainHand = BladeModel.user.func_184614_ca();
        return !(mainHand.func_77973_b() instanceof ItemSlashBlade);
    }

    private boolean renderBlade(ItemStack stack, ItemCameraTransforms.TransformType transformType, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND || transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND || transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || transformType == ItemCameraTransforms.TransformType.NONE) {
            if (BladeModel.user == null) {
                return false;
            }
            EnumSet<SwordType> types = SwordType.from(stack);
            boolean handle = false;
            if (!types.contains((Object)SwordType.NoScabbard)) {
                boolean bl = BladeModel.user.func_184591_cq() == HandSide.RIGHT ? transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : (handle = transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND);
            }
            if (handle) {
                BladeFirstPersonRender.getInstance().render(matrixStack, bufferIn, combinedLightIn);
            }
            return false;
        }
        try (MSAutoCloser msacA = MSAutoCloser.pushMatrix(matrixStack);){
            matrixStack.func_227861_a_(0.5, 0.5, 0.5);
            if (transformType == ItemCameraTransforms.TransformType.GROUND) {
                matrixStack.func_227861_a_(0.0, (double)0.15f, 0.0);
                this.renderIcon(stack, matrixStack, bufferIn, combinedLightIn, 0.005f);
            } else if (transformType == ItemCameraTransforms.TransformType.GUI) {
                this.renderIcon(stack, matrixStack, bufferIn, combinedLightIn, 0.008f, true);
            } else if (transformType == ItemCameraTransforms.TransformType.FIXED) {
                if (stack.func_82839_y() && stack.func_82836_z() instanceof BladeStandEntity) {
                    this.renderModel(stack, matrixStack, bufferIn, combinedLightIn);
                } else {
                    matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                    this.renderIcon(stack, matrixStack, bufferIn, combinedLightIn, 0.0095f);
                }
            } else {
                this.renderIcon(stack, matrixStack, bufferIn, combinedLightIn, 0.0095f);
            }
        }
        return true;
    }

    private void renderIcon(ItemStack stack, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int lightIn, float scale) {
        this.renderIcon(stack, matrixStack, bufferIn, lightIn, scale, false);
    }

    private void renderIcon(ItemStack stack, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int lightIn, float scale, boolean renderDurability) {
        matrixStack.func_227862_a_(scale, scale, scale);
        EnumSet<SwordType> types = SwordType.from(stack);
        ResourceLocation modelLocation = stack.getCapability(ItemSlashBlade.BLADESTATE).filter(s -> s.getModel().isPresent()).map(s -> s.getModel().get()).orElseGet(() -> BladeModelManager.resourceDefaultModel);
        WavefrontObject model = BladeModelManager.getInstance().getModel(modelLocation);
        ResourceLocation textureLocation = stack.getCapability(ItemSlashBlade.BLADESTATE).filter(s -> s.getTexture().isPresent()).map(s -> s.getTexture().get()).orElseGet(() -> BladeModelManager.resourceDefaultTexture);
        String renderTarget = types.contains((Object)SwordType.Broken) ? "item_damaged" : (!types.contains((Object)SwordType.NoScabbard) ? "item_blade" : "item_bladens");
        BladeRenderState.renderOverrided(stack, model, renderTarget, textureLocation, matrixStack, bufferIn, lightIn);
        BladeRenderState.renderOverridedLuminous(stack, model, renderTarget + "_luminous", textureLocation, matrixStack, bufferIn, lightIn);
        if (renderDurability) {
            WavefrontObject durabilityModel = BladeModelManager.getInstance().getModel(BladeModelManager.resourceDurabilityModel);
            float durability = stack.getCapability(ItemSlashBlade.BLADESTATE).map(s -> Float.valueOf(s.getDurabilityForDisplay())).orElse(Float.valueOf(0.0f)).floatValue();
            matrixStack.func_227861_a_(0.0, 0.0, (double)0.1f);
            if (BladeModel.user != null && BladeModel.user.func_184614_ca() == stack) {
                BladeRenderState.setCol(new Color(0xEEEEEE));
                BladeRenderState.renderOverrided(stack, durabilityModel, "base", BladeModelManager.resourceDurabilityTexture, matrixStack, bufferIn, lightIn);
                matrixStack.func_227861_a_(0.0, 0.0, (double)0.1f);
                BladeRenderState.setCol(Color.black);
                BladeRenderState.renderOverrided(stack, durabilityModel, "color_r", BladeModelManager.resourceDurabilityTexture, matrixStack, bufferIn, lightIn);
            } else {
                Color aCol = new Color(0.25f, 0.25f, 0.25f, 1.0f);
                Color bCol = new Color(10824803);
                int r = 0xFF & (int)MathHelper.func_219799_g((float)aCol.getRed(), (float)bCol.getRed(), (float)durability);
                int g = 0xFF & (int)MathHelper.func_219799_g((float)aCol.getGreen(), (float)bCol.getGreen(), (float)durability);
                int b = 0xFF & (int)MathHelper.func_219799_g((float)aCol.getBlue(), (float)bCol.getBlue(), (float)durability);
                BladeRenderState.setCol(new Color(r, g, b));
                BladeRenderState.renderOverrided(stack, durabilityModel, "base", BladeModelManager.resourceDurabilityTexture, matrixStack, bufferIn, lightIn);
                boolean isBroken = types.contains((Object)SwordType.Broken);
                matrixStack.func_227861_a_(0.0, 0.0, (double)(-2.0f * durability));
                BladeRenderState.renderOverrided(stack, durabilityModel, isBroken ? "color_r" : "color", BladeModelManager.resourceDurabilityTexture, matrixStack, bufferIn, lightIn);
            }
        }
    }

    private void renderModel(ItemStack stack, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int lightIn) {
        double offset;
        String renderTarget;
        boolean hasScabbard;
        float scale = 0.003125f;
        matrixStack.func_227862_a_(scale, scale, scale);
        float defaultOffset = 130.0f;
        matrixStack.func_227861_a_((double)defaultOffset, 0.0, 0.0);
        EnumSet<SwordType> types = SwordType.from(stack);
        ResourceLocation modelLocation = stack.getCapability(ItemSlashBlade.BLADESTATE).filter(s -> s.getModel().isPresent()).map(s -> s.getModel().get()).orElseGet(() -> BladeModelManager.resourceDefaultModel);
        WavefrontObject model = BladeModelManager.getInstance().getModel(modelLocation);
        ResourceLocation textureLocation = stack.getCapability(ItemSlashBlade.BLADESTATE).filter(s -> s.getTexture().isPresent()).map(s -> s.getTexture().get()).orElseGet(() -> BladeModelManager.resourceDefaultTexture);
        Vector3d bladeOffset = Vector3d.field_186680_a;
        float bladeOffsetRot = 0.0f;
        float bladeOffsetBaseRot = -3.0f;
        Vector3d sheathOffset = Vector3d.field_186680_a;
        float sheathOffsetRot = 0.0f;
        float sheathOffsetBaseRot = -3.0f;
        boolean vFlip = false;
        boolean hFlip = false;
        boolean bl = hasScabbard = !types.contains((Object)SwordType.NoScabbard);
        if (stack.func_82839_y() && stack.func_82836_z() instanceof BladeStandEntity) {
            BladeStandEntity stand = (BladeStandEntity)stack.func_82836_z();
            Item type = stand.currentType;
            Pose pose = stand.func_213283_Z();
            switch (pose.ordinal()) {
                case 0: {
                    vFlip = false;
                    hFlip = false;
                    break;
                }
                case 1: {
                    vFlip = true;
                    hFlip = false;
                    break;
                }
                case 2: {
                    vFlip = true;
                    hFlip = true;
                    break;
                }
                case 3: {
                    vFlip = false;
                    hFlip = true;
                    break;
                }
                case 4: {
                    vFlip = false;
                    hFlip = false;
                    hasScabbard = false;
                    break;
                }
                case 5: {
                    vFlip = false;
                    hFlip = true;
                    hasScabbard = false;
                }
            }
            if (type == SBItems.bladestand_1) {
                bladeOffset = Vector3d.field_186680_a;
                sheathOffset = Vector3d.field_186680_a;
            } else if (type == SBItems.bladestand_2) {
                bladeOffset = new Vector3d(0.0, 21.5, 0.0);
                sheathOffset = hFlip ? new Vector3d(-40.0, -27.0, 0.0) : new Vector3d(40.0, -27.0, 0.0);
                sheathOffsetBaseRot = -4.0f;
            } else if (type == SBItems.bladestand_v) {
                bladeOffset = new Vector3d(-100.0, 230.0, 0.0);
                sheathOffset = new Vector3d(-100.0, 230.0, 0.0);
                bladeOffsetRot = 80.0f;
                sheathOffsetRot = 80.0f;
            } else if (type == SBItems.bladestand_s) {
                if (hFlip) {
                    bladeOffset = new Vector3d(60.0, -25.0, 0.0);
                    sheathOffset = new Vector3d(60.0, -25.0, 0.0);
                } else {
                    bladeOffset = new Vector3d(-60.0, -25.0, 0.0);
                    sheathOffset = new Vector3d(-60.0, -25.0, 0.0);
                }
            } else if (type == SBItems.bladestand_1w) {
                bladeOffset = Vector3d.field_186680_a;
                sheathOffset = Vector3d.field_186680_a;
            } else if (type == SBItems.bladestand_2w) {
                bladeOffset = new Vector3d(0.0, 21.5, 0.0);
                sheathOffset = hFlip ? new Vector3d(-40.0, -27.0, 0.0) : new Vector3d(40.0, -27.0, 0.0);
                sheathOffsetBaseRot = -4.0f;
            }
        }
        try (MSAutoCloser msac = MSAutoCloser.pushMatrix(matrixStack);){
            renderTarget = types.contains((Object)SwordType.Broken) ? "blade_damaged" : "blade";
            matrixStack.func_227861_a_(bladeOffset.field_72450_a, bladeOffset.field_72448_b, bladeOffset.field_72449_c);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(bladeOffsetRot));
            if (vFlip) {
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
                matrixStack.func_227861_a_(0.0, -15.0, 0.0);
                matrixStack.func_227861_a_(0.0, 5.0, 0.0);
            }
            if (hFlip) {
                offset = defaultOffset;
                matrixStack.func_227861_a_(-offset, 0.0, 0.0);
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                matrixStack.func_227861_a_(offset, 0.0, 0.0);
            }
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(bladeOffsetBaseRot));
            BladeRenderState.renderOverrided(stack, model, renderTarget, textureLocation, matrixStack, bufferIn, lightIn);
            BladeRenderState.renderOverridedLuminous(stack, model, renderTarget + "_luminous", textureLocation, matrixStack, bufferIn, lightIn);
        }
        if (hasScabbard) {
            msac = MSAutoCloser.pushMatrix(matrixStack);
            var21_21 = null;
            try {
                renderTarget = "sheath";
                matrixStack.func_227861_a_(sheathOffset.field_72450_a, sheathOffset.field_72448_b, sheathOffset.field_72449_c);
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(sheathOffsetRot));
                if (vFlip) {
                    matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
                    matrixStack.func_227861_a_(0.0, -15.0, 0.0);
                    matrixStack.func_227861_a_(0.0, 5.0, 0.0);
                }
                if (hFlip) {
                    offset = defaultOffset;
                    matrixStack.func_227861_a_(-offset, 0.0, 0.0);
                    matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                    matrixStack.func_227861_a_(offset, 0.0, 0.0);
                }
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(sheathOffsetBaseRot));
                BladeRenderState.renderOverrided(stack, model, renderTarget, textureLocation, matrixStack, bufferIn, lightIn);
                BladeRenderState.renderOverridedLuminous(stack, model, renderTarget + "_luminous", textureLocation, matrixStack, bufferIn, lightIn);
            }
            catch (Throwable throwable) {
                var21_21 = throwable;
                throw throwable;
            }
            finally {
                if (msac != null) {
                    if (var21_21 != null) {
                        try {
                            msac.close();
                        }
                        catch (Throwable throwable) {
                            var21_21.addSuppressed(throwable);
                        }
                    } else {
                        msac.close();
                    }
                }
            }
        }
    }
}

