/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.EnumSet;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.item.SwordType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class BladeItemEntityRenderer
extends ItemRenderer {
    public BladeItemEntityRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, Minecraft.func_71410_x().func_175599_af());
    }

    public boolean shouldSpreadItems() {
        return false;
    }

    public boolean shouldBob() {
        return false;
    }

    public void func_225623_a_(ItemEntity itemIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        this.field_76989_e = 0.0f;
        if (!itemIn.func_92059_d().func_190926_b()) {
            this.renderBlade(itemIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        } else {
            partialTicks = (float)((double)itemIn.field_70290_d * 20.0 - (double)itemIn.func_174872_o());
            super.func_225623_a_(itemIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }
    }

    private void renderBlade(ItemEntity itemIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        block46: {
            try (MSAutoCloser msac = MSAutoCloser.pushMatrix(matrixStackIn);){
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(entityYaw));
                ItemStack current = itemIn.func_92059_d();
                EnumSet<SwordType> types = SwordType.from(current);
                ResourceLocation modelLocation = current.getCapability(ItemSlashBlade.BLADESTATE).map(state -> state.getModel().orElseGet(() -> BladeModelManager.resourceDefaultModel)).orElseGet(() -> {
                    if (current.func_77942_o() && current.func_77978_p().func_74764_b("Model")) {
                        return new ResourceLocation(current.func_77978_p().func_74779_i("Model"));
                    }
                    return BladeModelManager.resourceDefaultModel;
                });
                ResourceLocation textureLocation = current.getCapability(ItemSlashBlade.BLADESTATE).map(state -> state.getTexture().orElseGet(() -> BladeModelManager.resourceDefaultTexture)).orElseGet(() -> {
                    if (current.func_77942_o() && current.func_77978_p().func_74764_b("Texture")) {
                        return new ResourceLocation(current.func_77978_p().func_74779_i("Texture"));
                    }
                    return BladeModelManager.resourceDefaultTexture;
                });
                WavefrontObject model = BladeModelManager.getInstance().getModel(modelLocation);
                float scale = 0.00625f;
                try (MSAutoCloser msac2 = MSAutoCloser.pushMatrix(matrixStackIn);){
                    String renderTarget;
                    float heightOffset;
                    float xOffset = 0.0f;
                    if (types.contains((Object)SwordType.EdgeFragment)) {
                        heightOffset = 225.0f;
                        xOffset = 200.0f;
                        renderTarget = "blade_fragment";
                    } else if (types.contains((Object)SwordType.Broken)) {
                        heightOffset = 100.0f;
                        xOffset = 30.0f;
                        renderTarget = "blade_damaged";
                    } else {
                        heightOffset = 225.0f;
                        xOffset = 120.0f;
                        renderTarget = "blade";
                    }
                    if (itemIn.func_70090_H()) {
                        matrixStackIn.func_227861_a_(0.0, (double)0.025f, 0.0);
                        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(itemIn.field_70290_d));
                        matrixStackIn.func_227862_a_(scale, scale, scale);
                        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                    } else if (!itemIn.func_233570_aj_()) {
                        matrixStackIn.func_227862_a_(scale, scale, scale);
                        float speed = -81.0f;
                        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(speed * ((float)itemIn.field_70173_aa + partialTicks)));
                        matrixStackIn.func_227861_a_((double)xOffset, 0.0, 0.0);
                    } else {
                        matrixStackIn.func_227862_a_(scale, scale, scale);
                        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(60.0f + (float)Math.toDegrees((double)itemIn.field_70290_d / 6.0)));
                        matrixStackIn.func_227861_a_((double)heightOffset, 0.0, 0.0);
                    }
                    BladeRenderState.renderOverrided(current, model, renderTarget, textureLocation, matrixStackIn, bufferIn, packedLightIn);
                    BladeRenderState.renderOverridedLuminous(current, model, renderTarget + "_luminous", textureLocation, matrixStackIn, bufferIn, packedLightIn);
                }
                if (!itemIn.func_70090_H() && !itemIn.func_233570_aj_() || types.contains((Object)SwordType.NoScabbard)) break block46;
                msac2 = MSAutoCloser.pushMatrix(matrixStackIn);
                var16_18 = null;
                try {
                    matrixStackIn.func_227861_a_(0.0, (double)0.025f, 0.0);
                    matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(itemIn.field_70290_d));
                    if (!itemIn.func_70090_H()) {
                        matrixStackIn.func_227861_a_(0.75, 0.0, -0.4);
                    }
                    matrixStackIn.func_227862_a_(scale, scale, scale);
                    matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                    String renderTarget = "sheath";
                    BladeRenderState.renderOverrided(current, model, renderTarget, textureLocation, matrixStackIn, bufferIn, packedLightIn);
                    BladeRenderState.renderOverridedLuminous(current, model, renderTarget + "_luminous", textureLocation, matrixStackIn, bufferIn, packedLightIn);
                }
                catch (Throwable throwable) {
                    var16_18 = throwable;
                    throw throwable;
                }
                finally {
                    if (msac2 != null) {
                        if (var16_18 != null) {
                            try {
                                msac2.close();
                            }
                            catch (Throwable throwable) {
                                var16_18.addSuppressed(throwable);
                            }
                        } else {
                            msac2.close();
                        }
                    }
                }
            }
        }
    }
}

