/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import mods.flammpfeil.slashblade.entity.EntityJudgementCut;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class JudgementCutRenderer<T extends EntityJudgementCut>
extends EntityRenderer<T> {
    private static final ResourceLocation modelLocation = new ResourceLocation("slashblade", "model/util/slashdim.obj");
    private static final ResourceLocation textureLocation = new ResourceLocation("slashblade", "model/util/slashdim.png");

    @Nullable
    public ResourceLocation getEntityTexture(T entity) {
        return textureLocation;
    }

    public JudgementCutRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
    }

    public void render(T entity, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        try (MSAutoCloser msac = MSAutoCloser.pushMatrix(matrixStackIn);){
            int l;
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(MathHelper.func_219799_g((float)partialTicks, (float)((EntityJudgementCut)entity).field_70126_B, (float)((EntityJudgementCut)entity).field_70177_z) - 90.0f));
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(MathHelper.func_219799_g((float)partialTicks, (float)((EntityJudgementCut)entity).field_70127_C, (float)((EntityJudgementCut)entity).field_70125_A)));
            WavefrontObject model = BladeModelManager.getInstance().getModel(modelLocation);
            int lifetime = ((EntityJudgementCut)entity).getLifetime();
            double deathTime = lifetime;
            double baseAlpha = Math.min(deathTime, (double)Math.max(0.0f, (float)(lifetime - ((EntityJudgementCut)entity).field_70173_aa) - partialTicks)) / deathTime;
            baseAlpha = -Math.pow(baseAlpha - 1.0, 4.0) + 1.0;
            int seed = ((EntityJudgementCut)entity).getSeed();
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)seed));
            float scale = 0.01f;
            matrixStackIn.func_227862_a_(scale, scale, scale);
            int color = ((EntityJudgementCut)entity).getColor() & 0xFFFFFF;
            Color col = new Color(color);
            float[] hsb = Color.RGBtoHSB(col.getRed(), col.getGreen(), col.getBlue(), null);
            int baseColor = Color.HSBtoRGB(0.5f + hsb[0], hsb[1], 0.2f) & 0xFFFFFF;
            try (MSAutoCloser msacB = MSAutoCloser.pushMatrix(matrixStackIn);){
                for (l = 0; l < 5; ++l) {
                    matrixStackIn.func_227862_a_(0.95f, 0.95f, 0.95f);
                    BladeRenderState.setCol(baseColor | (0xFF & (int)(102.0 * baseAlpha)) << 24);
                    BladeRenderState.renderOverridedReverseLuminous(ItemStack.field_190927_a, model, "base", this.getEntityTexture(entity), matrixStackIn, bufferIn, packedLightIn);
                }
            }
            int loop = 3;
            for (int l2 = 0; l2 < loop; ++l2) {
                try (MSAutoCloser msacB = MSAutoCloser.pushMatrix(matrixStackIn);){
                    float cycleTicks = 15.0f;
                    float wave = ((float)((EntityJudgementCut)entity).field_70173_aa + cycleTicks / (float)loop * (float)l2 + partialTicks) % cycleTicks;
                    float waveScale = 1.0f + 0.03f * wave;
                    matrixStackIn.func_227862_a_(waveScale, waveScale, waveScale);
                    BladeRenderState.setCol(baseColor | (int)((double)(136.0f * ((cycleTicks - wave) / cycleTicks)) * baseAlpha) << 24);
                    BladeRenderState.renderOverridedReverseLuminous(ItemStack.field_190927_a, model, "base", this.getEntityTexture(entity), matrixStackIn, bufferIn, packedLightIn);
                    continue;
                }
            }
            int windCount = 5;
            for (l = 0; l < windCount; ++l) {
                try (MSAutoCloser msacB = MSAutoCloser.pushMatrix(matrixStackIn);){
                    matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(360.0f / (float)windCount * (float)l));
                    matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(30.0f));
                    double rotWind = 18.0;
                    double offsetBase = 7.0;
                    double offset = (double)l * offsetBase;
                    double motionLen = offsetBase * (double)(windCount - 1);
                    double ticks = (float)((EntityJudgementCut)entity).field_70173_aa + partialTicks + (float)seed;
                    double offsetTicks = ticks + offset;
                    double progress = offsetTicks % motionLen / motionLen;
                    double rad = Math.PI * 2;
                    float windScale = (float)(0.4 + progress);
                    matrixStackIn.func_227862_a_(windScale, windScale, windScale);
                    matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)(rotWind * offsetTicks)));
                    Color cc = new Color(col.getRed(), col.getGreen(), col.getBlue(), 0xFF & (int)Math.min(0.0, 255.0 * Math.sin(rad *= progress) * baseAlpha));
                    BladeRenderState.setCol(cc);
                    BladeRenderState.renderOverridedColorWrite(ItemStack.field_190927_a, model, "wind", this.getEntityTexture(entity), matrixStackIn, bufferIn, 0xF000E0);
                    continue;
                }
            }
        }
    }
}

