/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.Face;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import mods.flammpfeil.slashblade.entity.EntitySlashEffect;
import mods.flammpfeil.slashblade.init.SBItems;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SlashEffectRenderer<T extends EntitySlashEffect>
extends EntityRenderer<T> {
    private static final ResourceLocation modelLocation = new ResourceLocation("slashblade", "model/util/slash.obj");
    private static final ResourceLocation textureLocation = new ResourceLocation("slashblade", "model/util/slash.png");
    private static LazyValue<ItemStack> enchantedItem = new LazyValue(() -> new ItemStack((IItemProvider)SBItems.proudsoul));

    @Nullable
    public ResourceLocation getEntityTexture(T entity) {
        return textureLocation;
    }

    public SlashEffectRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
    }

    public void render(T entity, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        try (MSAutoCloser msac = MSAutoCloser.pushMatrix(matrixStackIn);){
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-MathHelper.func_219799_g((float)partialTicks, (float)((EntitySlashEffect)entity).field_70126_B, (float)((EntitySlashEffect)entity).field_70177_z) - 90.0f));
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(MathHelper.func_219799_g((float)partialTicks, (float)((EntitySlashEffect)entity).field_70127_C, (float)((EntitySlashEffect)entity).field_70125_A)));
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(((EntitySlashEffect)entity).getRotationRoll()));
            WavefrontObject model = BladeModelManager.getInstance().getModel(modelLocation);
            int lifetime = ((EntitySlashEffect)entity).getLifetime();
            float progress = Math.min((float)lifetime, (float)((EntitySlashEffect)entity).field_70173_aa + partialTicks) / (float)lifetime;
            double deathTime = lifetime;
            double baseAlpha = Math.min(deathTime, (double)Math.max(0.0f, (float)(lifetime - ((EntitySlashEffect)entity).field_70173_aa) - partialTicks)) / deathTime;
            baseAlpha = -Math.pow(baseAlpha - 1.0, 4.0) + 1.0;
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(((EntitySlashEffect)entity).getRotationOffset() - 135.0f * progress));
            matrixStackIn.func_227862_a_(1.0f, 0.25f, 1.0f);
            float baseScale = 1.2f;
            matrixStackIn.func_227862_a_(baseScale, baseScale, baseScale);
            float scale = ((EntitySlashEffect)entity).getBaseSize() * MathHelper.func_219799_g((float)progress, (float)0.03f, (float)0.035f);
            int color = ((EntitySlashEffect)entity).getColor() & 0xFFFFFF;
            ResourceLocation rl = this.getEntityTexture(entity);
            int alpha = (0xFF & (int)(255.0 * baseAlpha)) << 24;
            try (MSAutoCloser msacb = MSAutoCloser.pushMatrix(matrixStackIn);){
                float windscale = ((EntitySlashEffect)entity).getBaseSize() * MathHelper.func_219799_g((float)progress, (float)0.035f, (float)0.03f);
                matrixStackIn.func_227862_a_(windscale, windscale, windscale);
                Face.setAlphaOverride(Face.alphaOverrideYZZ);
                Face.setUvOperator(1.0f, 1.0f, 0.0f, -0.8f + progress * 0.3f);
                BladeRenderState.setCol(0x222222 | alpha);
                BladeRenderState.renderOverridedColorWrite(ItemStack.field_190927_a, model, "base", rl, matrixStackIn, bufferIn, packedLightIn);
            }
            msacb = MSAutoCloser.pushMatrix(matrixStackIn);
            var22_22 = null;
            try {
                matrixStackIn.func_227862_a_(scale, scale, scale);
                Face.setAlphaOverride(Face.alphaOverrideYZZ);
                Face.setUvOperator(1.0f, 1.0f, 0.0f, -0.35f + progress * -0.15f);
                BladeRenderState.setCol(color | alpha);
                BladeRenderState.renderOverridedColorWrite(ItemStack.field_190927_a, model, "base", rl, matrixStackIn, bufferIn, packedLightIn);
            }
            catch (Throwable windscale) {
                var22_22 = windscale;
                throw windscale;
            }
            finally {
                if (msacb != null) {
                    if (var22_22 != null) {
                        try {
                            msacb.close();
                        }
                        catch (Throwable windscale) {
                            var22_22.addSuppressed(windscale);
                        }
                    } else {
                        msacb.close();
                    }
                }
            }
            msacb = MSAutoCloser.pushMatrix(matrixStackIn);
            var22_22 = null;
            try {
                float windscale = ((EntitySlashEffect)entity).getBaseSize() * MathHelper.func_219799_g((float)progress, (float)0.03f, (float)0.0375f);
                matrixStackIn.func_227862_a_(windscale, windscale, windscale);
                Face.setAlphaOverride(Face.alphaOverrideYZZ);
                Face.setUvOperator(1.0f, 1.0f, 0.0f, -0.5f + progress * -0.2f);
                BladeRenderState.setCol(0x404040 | alpha);
                BladeRenderState.renderOverridedLuminous(ItemStack.field_190927_a, model, "base", rl, matrixStackIn, bufferIn, packedLightIn);
            }
            catch (Throwable throwable) {
                var22_22 = throwable;
                throw throwable;
            }
            finally {
                if (msacb != null) {
                    if (var22_22 != null) {
                        try {
                            msacb.close();
                        }
                        catch (Throwable throwable) {
                            var22_22.addSuppressed(throwable);
                        }
                    } else {
                        msacb.close();
                    }
                }
            }
            msacb = MSAutoCloser.pushMatrix(matrixStackIn);
            var22_22 = null;
            try {
                matrixStackIn.func_227862_a_(scale, scale, scale);
                Face.setAlphaOverride(Face.alphaOverrideYZZ);
                Face.setUvOperator(1.0f, 1.0f, 0.0f, -0.35f + progress * -0.15f);
                BladeRenderState.setCol(color | alpha);
                BladeRenderState.renderOverridedLuminous(ItemStack.field_190927_a, model, "base", rl, matrixStackIn, bufferIn, packedLightIn);
            }
            catch (Throwable throwable) {
                var22_22 = throwable;
                throw throwable;
            }
            finally {
                if (msacb != null) {
                    if (var22_22 != null) {
                        try {
                            msacb.close();
                        }
                        catch (Throwable throwable) {
                            var22_22.addSuppressed(throwable);
                        }
                    } else {
                        msacb.close();
                    }
                }
            }
        }
    }
}

