/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.gui;

import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class RankRenderer {
    static ResourceLocation RankImg = new ResourceLocation("slashblade", "textures/gui/rank.png");

    public static RankRenderer getInstance() {
        return SingletonHolder.instance;
    }

    private RankRenderer() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void renderTick(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (mc.field_71439_g == null) {
            return;
        }
        if (!Minecraft.func_71382_s()) {
            return;
        }
        if (mc.field_71462_r != null && !(mc.field_71462_r instanceof ChatScreen)) {
            return;
        }
        ClientWorld world = mc.field_71441_e;
        ClientPlayerEntity player = mc.field_71439_g;
        long time = System.currentTimeMillis();
        this.renderRankHud(Float.valueOf(event.renderTickTime), player, time);
    }

    private void renderRankHud(Float partialTicks, ClientPlayerEntity player, long time) {
        Minecraft mc = Minecraft.func_71410_x();
        player.getCapability(CapabilityConcentrationRank.RANK_POINT).ifPresent(cr -> {
            long now = player.field_70170_p.func_82737_E();
            IConcentrationRank.ConcentrationRanks rank = cr.getRank(now);
            if (rank == IConcentrationRank.ConcentrationRanks.NONE) {
                return;
            }
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)1048575);
            int k = mc.func_228018_at_().func_198107_o();
            int l = mc.func_228018_at_().func_198087_p();
            GL11.glTranslatef((float)(k * 2 / 3), (float)(l / 5), (float)0.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            mc.func_110434_K().func_110577_a(RankImg);
            boolean showTextRank = false;
            long textTimeout = cr.getLastRankRise() + 20L;
            long visibleTimeout = cr.getLastUpdate() + 120L;
            if (now < textTimeout) {
                showTextRank = true;
            }
            if (now < visibleTimeout) {
                int rankOffset = 32 * (rank.level - 1);
                int textOffset = showTextRank ? 128 : 0;
                int progress = (int)(33.0f * cr.getRankProgress(now));
                int progressIcon = (int)(18.0f * cr.getRankProgress(now));
                int progressIconInv = 17 - progressIcon;
                RankRenderer.drawTexturedQuad(0, 0, 0 + textOffset + 64, rankOffset, 64, 32, -95.0);
                RankRenderer.drawTexturedQuad(0, progressIconInv + 7, 0 + textOffset, rankOffset + progressIconInv + 7, 64, progressIcon, -90.0);
                RankRenderer.drawTexturedQuad(0, 32, 0, 240, 64, 16, -90.0);
                RankRenderer.drawTexturedQuad(16, 32, 16, 224, progress, 16, -95.0);
            }
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        });
    }

    public static void drawTexturedQuad(int x, int y, int u, int v, int width, int height, double zLevel) {
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder wr = tessellator.func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        wr.func_225582_a_((double)(x + 0), (double)(y + height), zLevel).func_225583_a_(((float)u + 0.0f) * var7, (float)(v + height) * var8).func_181675_d();
        wr.func_225582_a_((double)(x + width), (double)(y + height), zLevel).func_225583_a_((float)(u + width) * var7, (float)(v + height) * var8).func_181675_d();
        wr.func_225582_a_((double)(x + width), (double)(y + 0), zLevel).func_225583_a_((float)(u + width) * var7, (float)(v + 0) * var8).func_181675_d();
        wr.func_225582_a_((double)(x + 0), (double)(y + 0), zLevel).func_225583_a_((float)(u + 0) * var7, (float)(v + 0) * var8).func_181675_d();
        tessellator.func_78381_a();
    }

    private static final class SingletonHolder {
        private static final RankRenderer instance = new RankRenderer();

        private SingletonHolder() {
        }
    }
}

