/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import jp.nyatla.nymmd.MmdException;
import jp.nyatla.nymmd.MmdVmdMotionMc;
import mods.flammpfeil.slashblade.init.DefaultResources;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BladeMotionManager {
    MmdVmdMotionMc defaultMotion;
    LoadingCache<ResourceLocation, MmdVmdMotionMc> cache;

    public static BladeMotionManager getInstance() {
        return SingletonHolder.instance;
    }

    private BladeMotionManager() {
        try {
            this.defaultMotion = new MmdVmdMotionMc(DefaultResources.ExMotionLocation);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MmdException e) {
            e.printStackTrace();
        }
        this.cache = CacheBuilder.newBuilder().build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<ResourceLocation, MmdVmdMotionMc>(){

            public MmdVmdMotionMc load(ResourceLocation key) throws Exception {
                try {
                    return new MmdVmdMotionMc(key);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return BladeMotionManager.this.defaultMotion;
                }
            }
        }, (Executor)Executors.newCachedThreadPool()));
    }

    @SubscribeEvent
    public void reload(TextureStitchEvent.Pre event) {
        this.cache.invalidateAll();
        try {
            this.defaultMotion = new MmdVmdMotionMc(DefaultResources.ExMotionLocation);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MmdException e) {
            e.printStackTrace();
        }
    }

    public MmdVmdMotionMc getMotion(ResourceLocation loc) {
        if (loc != null) {
            try {
                return (MmdVmdMotionMc)this.cache.get((Object)loc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.defaultMotion;
    }

    private static final class SingletonHolder {
        private static final BladeMotionManager instance = new BladeMotionManager();

        private SingletonHolder() {
        }
    }
}

