/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.model.obj;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import java.util.function.BiFunction;
import mods.flammpfeil.slashblade.client.renderer.model.obj.TextureCoordinate;
import mods.flammpfeil.slashblade.client.renderer.model.obj.Vertex;
import net.minecraft.util.LazyValue;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Face {
    public static boolean isSmoothShade = true;
    public static int lightmap = 15;
    public static final BiFunction<Vector4f, Integer, Integer> alphaNoOverride = (v, a) -> a;
    public static final BiFunction<Vector4f, Integer, Integer> alphaOverrideYZZ = (v, a) -> v.func_195913_b() == 0.0f ? 0 : a;
    public static BiFunction<Vector4f, Integer, Integer> alphaOverride = alphaNoOverride;
    public static final Vector4f uvDefaultOperator;
    public static Vector4f uvOperator;
    public static Color col;
    private static final LazyValue<Matrix4f> defaultTransform;
    public static MatrixStack matrix;
    public Vertex[] vertices;
    public Vertex[] vertexNormals;
    public Vertex faceNormal;
    public TextureCoordinate[] textureCoordinates;

    public static void setLightMap(int value) {
        lightmap = value;
    }

    public static void resetLightMap() {
        lightmap = 15;
    }

    public static void setAlphaOverride(BiFunction<Vector4f, Integer, Integer> alphaOverride) {
        Face.alphaOverride = alphaOverride;
    }

    public static void resetAlphaOverride() {
        alphaOverride = alphaNoOverride;
    }

    public static void setUvOperator(float uScale, float vScale, float uOffset, float vOffset) {
        uvOperator = new Vector4f(uScale, vScale, uOffset, vOffset);
    }

    public static void resetUvOperator() {
        uvOperator = uvDefaultOperator;
    }

    public static void setCol(Color col) {
        Face.col = col;
    }

    public static void resetCol() {
        col = Color.white;
    }

    public static void setMatrix(MatrixStack ms) {
        matrix = ms;
    }

    public static void resetMatrix() {
        matrix = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addFaceForRender(IVertexBuilder tessellator) {
        this.addFaceForRender(tessellator, 5.0E-4f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addFaceForRender(IVertexBuilder tessellator, float textureOffset) {
        Matrix4f transform;
        if (this.faceNormal == null) {
            this.faceNormal = this.calculateFaceNormal();
        }
        float averageU = 0.0f;
        float averageV = 0.0f;
        if (this.textureCoordinates != null && this.textureCoordinates.length > 0) {
            for (int i = 0; i < this.textureCoordinates.length; ++i) {
                averageU += this.textureCoordinates[i].u * uvOperator.func_195910_a() + uvOperator.func_195914_c();
                averageV += this.textureCoordinates[i].v * uvOperator.func_195913_b() + uvOperator.func_195915_d();
            }
            averageU /= (float)this.textureCoordinates.length;
            averageV /= (float)this.textureCoordinates.length;
        }
        IVertexBuilder wr = tessellator;
        if (matrix != null) {
            MatrixStack.Entry me = matrix.func_227866_c_();
            transform = me.func_227870_a_();
        } else {
            transform = (Matrix4f)defaultTransform.func_179281_c();
        }
        for (int i = 0; i < this.vertices.length; ++i) {
            Vector3f vector3f;
            Vector4f vector4f = new Vector4f(this.vertices[i].x, this.vertices[i].y, this.vertices[i].z, 1.0f);
            vector4f.func_229372_a_(transform);
            wr.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c());
            if (this.textureCoordinates != null && this.textureCoordinates.length > 0) {
                float offsetU = textureOffset;
                float offsetV = textureOffset;
                float textureU = this.textureCoordinates[i].u * uvOperator.func_195910_a() + uvOperator.func_195914_c();
                float textureV = this.textureCoordinates[i].v * uvOperator.func_195913_b() + uvOperator.func_195915_d();
                if (textureU > averageU) {
                    offsetU = -offsetU;
                }
                if (textureV > averageV) {
                    offsetV = -offsetV;
                }
                wr.func_225583_a_(textureU + offsetU, textureV + offsetV);
            } else {
                wr.func_225583_a_(0.0f, 0.0f);
            }
            wr.func_227886_a_(lightmap);
            wr.func_225586_a_(col.getRed(), col.getGreen(), col.getBlue(), alphaOverride.apply(new Vector4f(this.vertices[i].x, this.vertices[i].y, this.vertices[i].z, 1.0f), col.getAlpha()).intValue());
            if (isSmoothShade && this.vertexNormals != null) {
                Vertex normal = this.vertexNormals[i];
                Vector3d nol = new Vector3d((double)normal.x, (double)normal.y, (double)normal.z);
                vector3f = new Vector3f((float)nol.field_72450_a, (float)nol.field_72448_b, (float)nol.field_72449_c);
            } else {
                vector3f = new Vector3f(this.faceNormal.x, this.faceNormal.y, this.faceNormal.z);
            }
            vector3f.func_229188_a_(new Matrix3f(transform));
            vector3f.func_229194_d_();
            wr.func_225584_a_(vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c());
            wr.func_181675_d();
        }
    }

    public Vertex calculateFaceNormal() {
        Vector3d v1 = new Vector3d((double)(this.vertices[1].x - this.vertices[0].x), (double)(this.vertices[1].y - this.vertices[0].y), (double)(this.vertices[1].z - this.vertices[0].z));
        Vector3d v2 = new Vector3d((double)(this.vertices[2].x - this.vertices[0].x), (double)(this.vertices[2].y - this.vertices[0].y), (double)(this.vertices[2].z - this.vertices[0].z));
        Vector3d normalVector = null;
        normalVector = v1.func_72431_c(v2).func_72432_b();
        return new Vertex((float)normalVector.field_72450_a, (float)normalVector.field_72448_b, (float)normalVector.field_72449_c);
    }

    static {
        uvOperator = uvDefaultOperator = new Vector4f(1.0f, 1.0f, 0.0f, 0.0f);
        defaultTransform = new LazyValue(() -> {
            Matrix4f m = new Matrix4f();
            m.func_226591_a_();
            return m;
        });
        matrix = null;
    }
}

