/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.entity.EntitySlashEffect;
import mods.flammpfeil.slashblade.entity.IShootable;
import mods.flammpfeil.slashblade.util.AttackManager;
import mods.flammpfeil.slashblade.util.EnumSetConverter;
import mods.flammpfeil.slashblade.util.KnockBacks;
import mods.flammpfeil.slashblade.util.NBTHelper;
import mods.flammpfeil.slashblade.util.TargetSelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityJudgementCut
extends ProjectileEntity
implements IShootable {
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityJudgementCut.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> FLAGS = EntityDataManager.func_187226_a(EntityJudgementCut.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int lifetime = 10;
    private int seed = -1;
    private double damage = 1.0;
    private boolean cycleHit = false;
    public UUID shootingEntity;
    private SoundEvent livingEntitySound = SoundEvents.field_187851_gB;
    EnumSet<FlagsState> flags = EnumSet.noneOf(FlagsState.class);
    int intFlags = 0;

    public int getSeed() {
        return this.seed;
    }

    public boolean doCycleHit() {
        return this.cycleHit;
    }

    public void setCycleHit(boolean cycleHit) {
        this.cycleHit = cycleHit;
    }

    protected SoundEvent getHitEntitySound() {
        return this.livingEntitySound;
    }

    public EntityJudgementCut(EntityType<? extends ProjectileEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.func_189654_d(true);
        this.seed = this.field_70146_Z.nextInt(360);
    }

    public static EntityJudgementCut createInstance(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        return new EntityJudgementCut(SlashBlade.RegistryEvents.JudgementCut, worldIn);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(COLOR, (Object)0x3333FF);
        this.field_70180_af.func_187214_a(FLAGS, (Object)0);
    }

    protected void func_213281_b(CompoundNBT compound) {
        NBTHelper.getNBTCoupler(compound).put("Color", this.getColor()).put("damage", this.damage).put("crit", this.getIsCritical()).put("clip", this.isNoClip()).put("OwnerUUID", this.shootingEntity).put("Lifetime", this.getLifetime());
    }

    protected void func_70037_a(CompoundNBT compound) {
        NBTHelper.getNBTCoupler(compound).get("Color", this::setColor, new Integer[0]).get("damage", v -> {
            this.damage = v;
        }, this.damage).get("crit", this::setIsCritical, new Boolean[0]).get("clip", this::setNoClip, new Boolean[0]).get("OwnerUUID", v -> {
            this.shootingEntity = v;
        }, true, (T[])new UUID[0]).get("Lifetime", this::setLifetime, new Integer[0]);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        this.func_213293_j(0.0, 0.0, 0.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntityJudgementCut.func_184183_bd()) * d0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.func_213293_j(0.0, 0.0, 0.0);
    }

    private void setFlags(FlagsState value) {
        this.flags.add(value);
        this.refreshFlags();
    }

    private void removeFlags(FlagsState value) {
        this.flags.remove((Object)value);
        this.refreshFlags();
    }

    private void refreshFlags() {
        if (this.field_70170_p.field_72995_K) {
            int newValue = (Integer)this.field_70180_af.func_187225_a(FLAGS);
            if (this.intFlags != newValue) {
                this.intFlags = newValue;
                EnumSetConverter.convertToEnumSet(this.flags, (Enum[])FlagsState.values(), (int)this.intFlags);
            }
        } else {
            int newValue = EnumSetConverter.convertToInt(this.flags);
            if (this.intFlags != newValue) {
                this.field_70180_af.func_187227_b(FLAGS, (Object)newValue);
                this.intFlags = newValue;
            }
        }
    }

    public void setIsCritical(boolean value) {
        if (value) {
            this.setFlags(FlagsState.Critical);
        } else {
            this.removeFlags(FlagsState.Critical);
        }
    }

    public boolean getIsCritical() {
        this.refreshFlags();
        return this.flags.contains((Object)FlagsState.Critical);
    }

    public void setNoClip(boolean value) {
        this.field_70145_X = value;
        if (value) {
            this.setFlags(FlagsState.NoClip);
        } else {
            this.removeFlags(FlagsState.NoClip);
        }
    }

    public boolean isNoClip() {
        if (!this.field_70170_p.field_72995_K) {
            return this.field_70145_X;
        }
        this.refreshFlags();
        return this.flags.contains((Object)FlagsState.NoClip);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa < 8 && this.field_70173_aa % 2 == 0) {
            this.func_184185_a(this.getHitEntitySound(), 0.2f, 0.5f + 0.25f * this.field_70146_Z.nextFloat());
        }
        if (this.getShooter() != null) {
            AxisAlignedBB bb = this.func_174813_aQ();
            if (this.field_70173_aa % 2 == 0) {
                KnockBacks knockBackType = this.getIsCritical() ? KnockBacks.toss : KnockBacks.cancel;
                AttackManager.areaAttack(this, knockBackType.action, 4.0, this.doCycleHit(), false);
            }
            int count = 3;
            if (this.getIsCritical() && 0 < this.field_70173_aa && this.field_70173_aa <= 3) {
                EntitySlashEffect jc = new EntitySlashEffect(SlashBlade.RegistryEvents.SlashEffect, this.field_70170_p);
                jc.func_70080_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 120.0f * (float)this.field_70173_aa + (float)this.seed, 0.0f);
                jc.setRotationRoll(30.0f);
                jc.func_212361_a(this.getShooter());
                jc.setMute(false);
                jc.setIsCritical(true);
                jc.setDamage(0.5);
                jc.setColor(this.getColor());
                jc.setBaseSize(0.5f);
                jc.setKnockBack(KnockBacks.cancel);
                this.field_70170_p.func_217376_c((Entity)jc);
            }
        }
        this.tryDespawn();
    }

    protected void tryDespawn() {
        if (!this.field_70170_p.field_72995_K && this.getLifetime() < this.field_70173_aa) {
            this.burst();
        }
    }

    public int getColor() {
        return (Integer)this.func_184212_Q().func_187225_a(COLOR);
    }

    public void setColor(int value) {
        this.func_184212_Q().func_187227_b(COLOR, (Object)value);
    }

    public int getLifetime() {
        return Math.min(this.lifetime, 1000);
    }

    public void setLifetime(int value) {
        this.lifetime = value;
    }

    @Override
    @Nullable
    public Entity getShooter() {
        return this.shootingEntity != null && this.field_70170_p instanceof ServerWorld ? ((ServerWorld)this.field_70170_p).func_217461_a(this.shootingEntity) : null;
    }

    public void func_212361_a(Entity shooter) {
        this.shootingEntity = shooter != null ? shooter.func_110124_au() : null;
    }

    public List<EffectInstance> getPotionEffects() {
        List effects = PotionUtils.func_185185_a((CompoundNBT)this.getPersistentData());
        if (effects.isEmpty()) {
            effects.add(new EffectInstance(Effects.field_76436_u, 1, 1));
        }
        return effects;
    }

    public void burst() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p instanceof ServerWorld) {
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197614_g, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 16, 0.5, 0.5, 0.5, 0.25);
            }
            this.burst(this.getPotionEffects(), null);
        }
        super.func_70106_y();
    }

    public void burst(List<EffectInstance> effects, @Nullable Entity focusEntity) {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
        List<Entity> list = TargetSelector.getTargettableEntitiesWithinAABB(this.field_70170_p, 2.0, this);
        list.stream().filter(e -> e instanceof LivingEntity).map(e -> (LivingEntity)e).forEach(e -> {
            double distanceSq = this.func_70068_e((Entity)e);
            if (distanceSq < 9.0) {
                double factor = 1.0 - Math.sqrt(distanceSq) / 4.0;
                if (e == focusEntity) {
                    factor = 1.0;
                }
                this.affectEntity((LivingEntity)e, effects, factor);
            }
        });
    }

    public void affectEntity(LivingEntity focusEntity, List<EffectInstance> effects, double factor) {
        for (EffectInstance effectinstance : this.getPotionEffects()) {
            Effect effect = effectinstance.func_188419_a();
            if (effect.func_76403_b()) {
                effect.func_180793_a((Entity)this, this.getShooter(), focusEntity, effectinstance.func_76458_c(), factor);
                continue;
            }
            int duration = (int)(factor * (double)effectinstance.func_76459_b() + 0.5);
            if (duration <= 0) continue;
            focusEntity.func_195064_c(new EffectInstance(effect, duration, effectinstance.func_76458_c(), effectinstance.func_82720_e(), effectinstance.func_188418_e()));
        }
    }

    public void setDamage(double damageIn) {
        this.damage = damageIn;
    }

    @Override
    public double getDamage() {
        return this.damage;
    }

    @Nullable
    public EntityRayTraceResult getRayTrace(Vector3d p_213866_1_, Vector3d p_213866_2_) {
        return ProjectileHelper.func_221269_a((World)this.field_70170_p, (Entity)this, (Vector3d)p_213866_1_, (Vector3d)p_213866_2_, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), p_213871_1_ -> !p_213871_1_.func_175149_v() && p_213871_1_.func_70089_S() && p_213871_1_.func_70067_L() && p_213871_1_ != this.getShooter());
    }

    static enum FlagsState {
        Critical,
        NoClip;

    }
}

