/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.entity.IShootable;
import mods.flammpfeil.slashblade.event.FallHandler;
import mods.flammpfeil.slashblade.util.AttackManager;
import mods.flammpfeil.slashblade.util.EnumSetConverter;
import mods.flammpfeil.slashblade.util.KnockBacks;
import mods.flammpfeil.slashblade.util.NBTHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntitySlashEffect
extends ProjectileEntity
implements IShootable {
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntitySlashEffect.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> FLAGS = EntityDataManager.func_187226_a(EntitySlashEffect.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> ROTATION_OFFSET = EntityDataManager.func_187226_a(EntitySlashEffect.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ROTATION_ROLL = EntityDataManager.func_187226_a(EntitySlashEffect.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> BASESIZE = EntityDataManager.func_187226_a(EntitySlashEffect.class, (IDataSerializer)DataSerializers.field_187193_c);
    private int lifetime = 10;
    private KnockBacks action = KnockBacks.cancel;
    private double damage = 1.0;
    private boolean cycleHit = false;
    private List<Entity> alreadyHits = Lists.newArrayList();
    public UUID shootingEntity;
    private SoundEvent livingEntitySound = SoundEvents.field_187851_gB;
    EnumSet<FlagsState> flags = EnumSet.noneOf(FlagsState.class);
    int intFlags = 0;

    public KnockBacks getKnockBack() {
        return this.action;
    }

    public void setKnockBack(KnockBacks action) {
        this.action = action;
    }

    public void setKnockBackOrdinal(int ordinal) {
        this.action = 0 <= ordinal && ordinal < KnockBacks.values().length ? KnockBacks.values()[ordinal] : KnockBacks.cancel;
    }

    public boolean doCycleHit() {
        return this.cycleHit;
    }

    public void setCycleHit(boolean cycleHit) {
        this.cycleHit = cycleHit;
    }

    protected SoundEvent getHitEntitySound() {
        return this.livingEntitySound;
    }

    public EntitySlashEffect(EntityType<? extends ProjectileEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.func_189654_d(true);
    }

    public static EntitySlashEffect createInstance(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        return new EntitySlashEffect(SlashBlade.RegistryEvents.SlashEffect, worldIn);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(COLOR, (Object)0x3333FF);
        this.field_70180_af.func_187214_a(FLAGS, (Object)0);
        this.field_70180_af.func_187214_a(ROTATION_OFFSET, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ROTATION_ROLL, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(BASESIZE, (Object)Float.valueOf(1.0f));
    }

    protected void func_213281_b(CompoundNBT compound) {
        NBTHelper.getNBTCoupler(compound).put("RotationOffset", Float.valueOf(this.getRotationOffset())).put("RotationRoll", Float.valueOf(this.getRotationRoll())).put("BaseSize", Float.valueOf(this.getBaseSize())).put("Color", this.getColor()).put("damage", this.damage).put("crit", this.getIsCritical()).put("clip", this.isNoClip()).put("OwnerUUID", this.shootingEntity).put("Lifetime", this.getLifetime()).put("Knockback", this.getKnockBack().ordinal());
    }

    protected void func_70037_a(CompoundNBT compound) {
        NBTHelper.getNBTCoupler(compound).get("RotationOffset", this::setRotationOffset, new Float[0]).get("RotationRoll", this::setRotationRoll, new Float[0]).get("BaseSize", this::setBaseSize, new Float[0]).get("Color", this::setColor, new Integer[0]).get("damage", v -> {
            this.damage = v;
        }, this.damage).get("crit", this::setIsCritical, new Boolean[0]).get("clip", this::setNoClip, new Boolean[0]).get("OwnerUUID", v -> {
            this.shootingEntity = v;
        }, true, (T[])new UUID[0]).get("Lifetime", this::setLifetime, new Integer[0]).get("Knockback", this::setKnockBackOrdinal, new Integer[0]);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        this.func_213293_j(0.0, 0.0, 0.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntitySlashEffect.func_184183_bd()) * d0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.func_213293_j(0.0, 0.0, 0.0);
    }

    private void setFlags(FlagsState value) {
        this.flags.add(value);
        this.refreshFlags();
    }

    private void removeFlags(FlagsState value) {
        this.flags.remove((Object)value);
        this.refreshFlags();
    }

    private void refreshFlags() {
        if (this.field_70170_p.field_72995_K) {
            int newValue = (Integer)this.field_70180_af.func_187225_a(FLAGS);
            if (this.intFlags != newValue) {
                this.intFlags = newValue;
                EnumSetConverter.convertToEnumSet(this.flags, (Enum[])FlagsState.values(), (int)this.intFlags);
            }
        } else {
            int newValue = EnumSetConverter.convertToInt(this.flags);
            if (this.intFlags != newValue) {
                this.field_70180_af.func_187227_b(FLAGS, (Object)newValue);
                this.intFlags = newValue;
            }
        }
    }

    public void setMute(boolean value) {
        if (value) {
            this.setFlags(FlagsState.Mute);
        } else {
            this.removeFlags(FlagsState.Mute);
        }
    }

    public boolean getMute() {
        this.refreshFlags();
        return this.flags.contains((Object)FlagsState.Mute);
    }

    public void setIsCritical(boolean value) {
        if (value) {
            this.setFlags(FlagsState.Critical);
        } else {
            this.removeFlags(FlagsState.Critical);
        }
    }

    public boolean getIsCritical() {
        this.refreshFlags();
        return this.flags.contains((Object)FlagsState.Critical);
    }

    public void setNoClip(boolean value) {
        this.field_70145_X = value;
        if (value) {
            this.setFlags(FlagsState.NoClip);
        } else {
            this.removeFlags(FlagsState.NoClip);
        }
    }

    public boolean isNoClip() {
        if (!this.field_70170_p.field_72995_K) {
            return this.field_70145_X;
        }
        this.refreshFlags();
        return this.flags.contains((Object)FlagsState.NoClip);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa == 2) {
            if (!this.getMute()) {
                this.func_184185_a(SoundEvents.field_203274_ip, 0.8f, 0.625f + 0.1f * this.field_70146_Z.nextFloat());
            } else {
                this.func_184185_a(SoundEvents.field_187730_dW, 0.5f, 0.4f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
            }
            if (this.getIsCritical()) {
                this.func_184185_a(this.getHitEntitySound(), 0.2f, 0.4f + 0.25f * this.field_70146_Z.nextFloat());
            }
        }
        if (this.getShooter() != null && !this.getShooter().func_70026_G() && (double)this.field_70173_aa < (double)this.getLifetime() * 0.75) {
            Vector3d start = this.func_213303_ch();
            Vector4f normal = new Vector4f(1.0f, 0.0f, 0.0f, 1.0f);
            float progress = (float)this.field_70173_aa / (float)this.lifetime;
            normal.func_195912_a(new Quaternion(Vector3f.field_229181_d_, -this.field_70177_z - 90.0f, true));
            normal.func_195912_a(new Quaternion(Vector3f.field_229183_f_, this.field_70125_A, true));
            normal.func_195912_a(new Quaternion(Vector3f.field_229179_b_, this.getRotationRoll(), true));
            normal.func_195912_a(new Quaternion(Vector3f.field_229181_d_, 140.0f + this.getRotationOffset() - 200.0f * progress, true));
            Vector3d normal3d = new Vector3d((double)normal.func_195910_a(), (double)normal.func_195913_b(), (double)normal.func_195914_c());
            BlockRayTraceResult rayResult = this.func_130014_f_().func_217299_a(new RayTraceContext(start.func_178787_e(normal3d.func_186678_a(1.5)), start.func_178787_e(normal3d.func_186678_a(3.0)), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, null));
            if (rayResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
                FallHandler.spawnLandingParticle((Entity)this, rayResult.func_216347_e(), normal3d, 3.0f);
            }
        }
        if (this.getShooter() != null) {
            AxisAlignedBB bb = this.func_174813_aQ();
            if (this.field_70173_aa % 2 == 0) {
                List<Entity> hits;
                boolean forceHit = true;
                if (this.getShooter() instanceof LivingEntity) {
                    LivingEntity shooter = (LivingEntity)this.getShooter();
                    float ratio = (float)this.damage * (this.getIsCritical() ? 1.1f : 1.0f);
                    hits = AttackManager.areaAttack(shooter, this.action.action, ratio, forceHit, false, true, this.alreadyHits);
                } else {
                    hits = AttackManager.areaAttack(this, this.action.action, 4.0, forceHit, false, this.alreadyHits);
                }
                if (!this.doCycleHit()) {
                    this.alreadyHits.addAll(hits);
                }
            }
        }
        this.tryDespawn();
    }

    protected void tryDespawn() {
        if (!this.field_70170_p.field_72995_K && this.getLifetime() < this.field_70173_aa) {
            super.func_70106_y();
        }
    }

    public int getColor() {
        return (Integer)this.func_184212_Q().func_187225_a(COLOR);
    }

    public void setColor(int value) {
        this.func_184212_Q().func_187227_b(COLOR, (Object)value);
    }

    public int getLifetime() {
        return Math.min(this.lifetime, 1000);
    }

    public void setLifetime(int value) {
        this.lifetime = value;
    }

    public float getRotationOffset() {
        return ((Float)this.func_184212_Q().func_187225_a(ROTATION_OFFSET)).floatValue();
    }

    public void setRotationOffset(float value) {
        this.func_184212_Q().func_187227_b(ROTATION_OFFSET, (Object)Float.valueOf(value));
    }

    public float getRotationRoll() {
        return ((Float)this.func_184212_Q().func_187225_a(ROTATION_ROLL)).floatValue();
    }

    public void setRotationRoll(float value) {
        this.func_184212_Q().func_187227_b(ROTATION_ROLL, (Object)Float.valueOf(value));
    }

    public float getBaseSize() {
        return ((Float)this.func_184212_Q().func_187225_a(BASESIZE)).floatValue();
    }

    public void setBaseSize(float value) {
        this.func_184212_Q().func_187227_b(BASESIZE, (Object)Float.valueOf(value));
    }

    @Override
    @Nullable
    public Entity getShooter() {
        return this.shootingEntity != null && this.field_70170_p instanceof ServerWorld ? ((ServerWorld)this.field_70170_p).func_217461_a(this.shootingEntity) : null;
    }

    public void func_212361_a(Entity shooter) {
        this.shootingEntity = shooter != null ? shooter.func_110124_au() : null;
    }

    public List<EffectInstance> getPotionEffects() {
        List effects = PotionUtils.func_185185_a((CompoundNBT)this.getPersistentData());
        if (effects.isEmpty()) {
            effects.add(new EffectInstance(Effects.field_76436_u, 1, 1));
        }
        return effects;
    }

    public void setDamage(double damageIn) {
        this.damage = damageIn;
    }

    @Override
    public double getDamage() {
        return this.damage;
    }

    @Nullable
    public EntityRayTraceResult getRayTrace(Vector3d p_213866_1_, Vector3d p_213866_2_) {
        return ProjectileHelper.func_221269_a((World)this.field_70170_p, (Entity)this, (Vector3d)p_213866_1_, (Vector3d)p_213866_2_, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), p_213871_1_ -> !p_213871_1_.func_175149_v() && p_213871_1_.func_70089_S() && p_213871_1_.func_70067_L() && p_213871_1_ != this.getShooter());
    }

    static enum FlagsState {
        Critical,
        NoClip,
        Mute;

    }
}

