/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event;

import java.util.List;
import java.util.Map;
import mods.flammpfeil.slashblade.event.AnvilCraftingRecipe;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.container.RepairContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BladeMaterialTooltips {
    public static BladeMaterialTooltips getInstance() {
        return SingletonHolder.instance;
    }

    private BladeMaterialTooltips() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onLivingDeathEvent(ItemTooltipEvent event) {
        List tooltip = event.getToolTip();
        ItemStack stack = event.getItemStack();
        AnvilCraftingRecipe recipe = AnvilCraftingRecipe.getRecipe(stack);
        if (recipe == null) {
            return;
        }
        ItemStack blade = ItemStack.field_190927_a;
        boolean hasAnvil = false;
        if (event.getPlayer() != null && event.getPlayer().field_71070_bA instanceof RepairContainer) {
            hasAnvil = true;
            blade = event.getPlayer().field_71070_bA.func_75139_a(0).func_75211_c();
        }
        tooltip.add(new TranslationTextComponent("slashblade.tooltip.material").func_240699_a_(TextFormatting.DARK_AQUA));
        tooltip.add(this.getRequirements("slashblade.tooltip.material.requiredobjects.anvil", hasAnvil, new Object[0]));
        tooltip.add(this.getRequirements(recipe.getTranslationKey(), recipe.getTranslationKey().equals(blade.func_77977_a()), new Object[0]));
        if (0 < recipe.getKillcount()) {
            tooltip.add(this.getRequirements("slashblade.tooltip.material.killcount", blade.getCapability(ItemSlashBlade.BLADESTATE).filter(s -> recipe.getKillcount() <= s.getKillCount()).isPresent(), recipe.getKillcount()));
        }
        if (0 < recipe.getRefine()) {
            tooltip.add(this.getRequirements("slashblade.tooltip.material.refine", blade.getCapability(ItemSlashBlade.BLADESTATE).filter(s -> recipe.getRefine() <= s.getRefine()).isPresent(), recipe.getRefine()));
        }
        if (recipe.isBroken()) {
            tooltip.add(this.getRequirements("slashblade.tooltip.material.broken", blade.getCapability(ItemSlashBlade.BLADESTATE).filter(s -> s.isBroken()).isPresent(), new Object[0]));
        }
        if (recipe.isNoScabbard()) {
            tooltip.add(this.getRequirements("slashblade.tooltip.material.noscabbard", blade.getCapability(ItemSlashBlade.BLADESTATE).filter(s -> s.isNoScabbard()).isPresent(), new Object[0]));
        }
        if (0 < recipe.getEnchantments().size()) {
            tooltip.add(this.getRequirements("slashblade.tooltip.material.enchantments", this.checkEnchantments(recipe.getEnchantments(), blade), recipe.getLevel()));
        }
        if (0 < recipe.getLevel()) {
            tooltip.add(this.getRequirements("slashblade.tooltip.material.level", event.getPlayer() != null && recipe.getLevel() <= event.getPlayer().field_71068_ca, recipe.getLevel()));
        }
    }

    private boolean checkEnchantments(Map<Enchantment, Integer> requirements, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (!stack.func_77948_v()) {
            return false;
        }
        for (Map.Entry<Enchantment, Integer> entry : requirements.entrySet()) {
            if (entry.getValue() <= EnchantmentHelper.func_77506_a((Enchantment)entry.getKey(), (ItemStack)stack)) continue;
            return false;
        }
        return true;
    }

    ITextComponent getRequirements(String key, boolean check, Object ... args) {
        TranslationTextComponent tc = new TranslationTextComponent(key, args);
        if (check) {
            tc.func_240699_a_(TextFormatting.GREEN);
        }
        return tc;
    }

    private static final class SingletonHolder {
        private static final BladeMaterialTooltips instance = new BladeMaterialTooltips();

        private SingletonHolder() {
        }
    }
}

