/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event;

import mods.flammpfeil.slashblade.capability.slashblade.ComboState;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FallHandler {
    public static FallHandler getInstance() {
        return SingletonHolder.instance;
    }

    private FallHandler() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        FallHandler.resetState(event.getEntityLiving());
    }

    @SubscribeEvent
    public void onFlyableFall(PlayerFlyableFallEvent event) {
        FallHandler.resetState(event.getEntityLiving());
    }

    public static void resetState(LivingEntity user) {
        user.func_184614_ca().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
            state.setFallDecreaseRate(0.0f);
            ComboState combo = state.getComboSeq();
            if (combo.isAerial()) {
                state.setComboSeq(combo.getNextOfTimeout());
            }
        });
    }

    public static void spawnLandingParticle(LivingEntity user, float fallFactor) {
        if (!user.field_70170_p.field_72995_K) {
            double d0;
            int i;
            int x = MathHelper.func_76128_c((double)user.func_226277_ct_());
            int y = MathHelper.func_76128_c((double)(user.func_226278_cu_() - 0.5));
            int z = MathHelper.func_76128_c((double)user.func_226281_cx_());
            BlockPos pos = new BlockPos(x, y, z);
            BlockState state = user.field_70170_p.func_180495_p(pos);
            float f = MathHelper.func_76123_f((float)fallFactor);
            if (!state.isAir((IBlockReader)user.field_70170_p, pos) && !state.addLandingEffects((ServerWorld)user.field_70170_p, pos, state, user, i = (int)(150.0 * (d0 = Math.min((double)(0.2f + f / 15.0f), 2.5))))) {
                ((ServerWorld)user.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, state), user.func_226277_ct_(), user.func_226278_cu_(), user.func_226281_cx_(), i, 0.0, 0.0, 0.0, (double)0.15f);
            }
        }
    }

    public static void spawnLandingParticle(Entity user, Vector3d targetPos, Vector3d normal, float fallFactor) {
        if (!user.field_70170_p.field_72995_K) {
            Vector3d blockPos = targetPos.func_178787_e(normal.func_72432_b().func_186678_a(0.5));
            int x = MathHelper.func_76128_c((double)blockPos.func_82615_a());
            int y = MathHelper.func_76128_c((double)blockPos.func_82617_b());
            int z = MathHelper.func_76128_c((double)blockPos.func_82616_c());
            BlockPos pos = new BlockPos(x, y, z);
            BlockState state = user.field_70170_p.func_180495_p(pos);
            float f = MathHelper.func_76123_f((float)fallFactor);
            if (!state.isAir((IBlockReader)user.field_70170_p, pos)) {
                double d0 = Math.min((double)(0.2f + f / 15.0f), 2.5);
                int i = (int)(150.0 * d0);
                ((ServerWorld)user.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, state), targetPos.func_82615_a(), targetPos.func_82617_b(), targetPos.func_82616_c(), i, 0.0, 0.0, 0.0, (double)0.15f);
            }
        }
    }

    public static void fallDecrease(LivingEntity user) {
        if (!user.func_189652_ae() && !user.func_233570_aj_()) {
            user.field_70143_R = 1.0f;
            float currentRatio = user.func_184614_ca().getCapability(ItemSlashBlade.BLADESTATE).map(state -> {
                float decRatio = state.getFallDecreaseRate();
                float newDecRatio = decRatio + 0.05f;
                newDecRatio = Math.min(1.0f, newDecRatio);
                state.setFallDecreaseRate(newDecRatio);
                return Float.valueOf(decRatio);
            }).orElseGet(() -> Float.valueOf(1.0f)).floatValue();
            double gravityReductionFactor = 0.85f;
            int level = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_180309_e, (LivingEntity)user);
            if (0 < level) {
                gravityReductionFactor = Math.min(0.93, gravityReductionFactor + 0.2 * (double)level);
            }
            ModifiableAttributeInstance gravity = user.func_110148_a((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            double g = gravity.func_111126_e() * gravityReductionFactor;
            Vector3d motion = user.func_213322_ci();
            if (motion.field_72448_b < 0.0) {
                user.func_213293_j(motion.field_72450_a, (motion.field_72448_b + g) * (double)currentRatio, motion.field_72449_c);
            }
        }
    }

    public static void fallResist(LivingEntity user) {
        if (!user.func_189652_ae() && !user.func_233570_aj_()) {
            user.field_70143_R = 1.0f;
            Vector3d motion = user.func_213322_ci();
            ModifiableAttributeInstance gravity = user.func_110148_a((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            double g = gravity.func_111126_e();
            if (motion.field_72448_b < 0.0) {
                user.func_213293_j(motion.field_72450_a, motion.field_72448_b + g + (double)0.002f, motion.field_72449_c);
            }
        }
    }

    private static final class SingletonHolder {
        private static final FallHandler instance = new FallHandler();

        private SingletonHolder() {
        }
    }
}

