/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event;

import mods.flammpfeil.slashblade.util.NBTHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class KnockBackHandler {
    static final String NBT_KEY = "knockback_factor";

    public static void setCancel(LivingEntity target) {
        KnockBackHandler.setFactor(target, 0.0, 0.0, 0.0);
    }

    public static void setSmash(LivingEntity target, double horizontalFactor) {
        KnockBackHandler.setFactor(target, horizontalFactor, 0.0, 0.0);
    }

    public static void setVertical(LivingEntity target, double verticalFactor) {
        KnockBackHandler.setFactor(target, 0.0, verticalFactor, -verticalFactor);
    }

    public static void setFactor(LivingEntity target, double horizontalFactor, double verticalFactor, double addFallDistance) {
        NBTHelper.putVector3d(target.getPersistentData(), NBT_KEY, new Vector3d(horizontalFactor, verticalFactor, addFallDistance));
    }

    @SubscribeEvent
    public static void onLivingKnockBack(LivingKnockBackEvent event) {
        LivingEntity target = event.getEntityLiving();
        CompoundNBT nbt = target.getPersistentData();
        if (!nbt.func_74764_b(NBT_KEY)) {
            return;
        }
        Vector3d factor = NBTHelper.getVector3d(nbt, NBT_KEY);
        nbt.func_82580_o(NBT_KEY);
        if (target.field_70143_R < 0.0f) {
            target.field_70143_R = 0.0f;
        }
        target.field_70143_R = (float)((double)target.field_70143_R + factor.field_72449_c);
        if (target.func_70681_au().nextDouble() < target.func_110148_a(Attributes.field_233820_c_).func_111126_e()) {
            return;
        }
        target.field_70160_al = true;
        Vector3d motion = target.func_213322_ci();
        if (factor.field_72450_a == 0.0) {
            event.setCanceled(true);
            motion = motion.func_216372_d(0.0, 1.0, 0.0);
        } else {
            event.setStrength((float)((double)event.getStrength() * factor.field_72450_a));
        }
        if (0.0 < factor.field_72448_b) {
            target.func_230245_c_(false);
            event.getEntityLiving().func_213293_j(motion.field_72450_a, Math.max(motion.field_72448_b, factor.field_72448_b), motion.field_72449_c);
        } else if (factor.field_72448_b < 0.0) {
            event.getEntityLiving().func_213293_j(motion.field_72450_a, Math.min(motion.field_72448_b, factor.field_72448_b), motion.field_72449_c);
        }
    }
}

