/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event;

import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RefineHandler {
    private static final ResourceLocation REFINE = new ResourceLocation("slashblade", "tips/refine");

    public static RefineHandler getInstance() {
        return SingletonHolder.instance;
    }

    private RefineHandler() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onAnvilUpdateEvent(AnvilUpdateEvent event) {
        int cost;
        ItemStack base = event.getLeft();
        ItemStack material = event.getRight();
        if (base.func_190926_b()) {
            return;
        }
        if (!(base.func_77973_b() instanceof ItemSlashBlade)) {
            return;
        }
        if (material.func_190926_b()) {
            return;
        }
        boolean isRepairable = base.func_77973_b().func_82789_a(base, material);
        if (!isRepairable) {
            return;
        }
        int level = material.getHarvestLevel(ToolType.get((String)"proudsoul"), null, null);
        if (level < 0) {
            return;
        }
        ItemStack result = base.func_77946_l();
        int refineLimit = 6 <= level ? Integer.MAX_VALUE : Math.max(10, 50 * (level - 1));
        for (cost = 0; cost < material.func_190916_E(); ++cost) {
            float damage = result.getCapability(ItemSlashBlade.BLADESTATE).map(s -> {
                s.setDamage(s.getDamage() - (0.2f + 0.05f * (float)level));
                if (s.getRefine() < refineLimit) {
                    s.setRefine(s.getRefine() + 1);
                }
                return Float.valueOf(s.getDamage());
            }).orElse(Float.valueOf(0.0f)).floatValue();
            if (!(damage <= 0.0f)) continue;
            break;
        }
        event.setMaterialCost(cost);
        int levelCostBase = Math.max(1, 2 * (level - 1));
        event.setCost(levelCostBase * cost);
        event.setOutput(result);
    }

    @SubscribeEvent
    public void onAnvilRepairEvent(AnvilRepairEvent event) {
        if (!(event.getPlayer() instanceof ServerPlayerEntity)) {
            return;
        }
        ItemStack material = event.getIngredientInput();
        ItemStack base = event.getItemInput();
        if (base.func_190926_b()) {
            return;
        }
        if (!(base.func_77973_b() instanceof ItemSlashBlade)) {
            return;
        }
        if (material.func_190926_b()) {
            return;
        }
        boolean isRepairable = base.func_77973_b().func_82789_a(base, material);
        if (!isRepairable) {
            return;
        }
        int level = material.getHarvestLevel(ToolType.get((String)"proudsoul"), null, null);
        if (level < 0) {
            return;
        }
        RefineHandler.grantCriterion((ServerPlayerEntity)event.getPlayer(), REFINE);
    }

    private static void grantCriterion(ServerPlayerEntity player, ResourceLocation resourcelocation) {
        Advancement adv = player.func_184102_h().func_191949_aK().func_192778_a(resourcelocation);
        if (adv == null) {
            return;
        }
        AdvancementProgress advancementprogress = player.func_192039_O().func_192747_a(adv);
        if (advancementprogress.func_192105_a()) {
            return;
        }
        for (String s : advancementprogress.func_192107_d()) {
            player.func_192039_O().func_192750_a(adv, s);
        }
    }

    private static final class SingletonHolder {
        private static final RefineHandler instance = new RefineHandler();

        private SingletonHolder() {
        }
    }
}

