/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class UserPoseOverrider {
    private static final String TAG_ROT = "sb_yrot";
    private static final String TAG_ROT_PREV = "sb_yrot_prev";

    public static UserPoseOverrider getInstance() {
        return SingletonHolder.instance;
    }

    private UserPoseOverrider() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onRenderPlayerEventPre(RenderLivingEvent.Pre event) {
        ItemStack stack = event.getEntity().func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        if (!(stack.func_77973_b() instanceof ItemSlashBlade)) {
            return;
        }
        float rot = event.getEntity().getPersistentData().func_74760_g(TAG_ROT);
        float rotPrev = event.getEntity().getPersistentData().func_74760_g(TAG_ROT_PREV);
        MatrixStack matrixStackIn = event.getMatrixStack();
        LivingEntity entityLiving = event.getEntity();
        float partialTicks = event.getPartialRenderTick();
        float f = MathHelper.func_219805_h((float)partialTicks, (float)entityLiving.field_70760_ar, (float)entityLiving.field_70761_aq);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - f));
        UserPoseOverrider.anotherPoseRotP(matrixStackIn, entityLiving, partialTicks);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(MathHelper.func_219805_h((float)partialTicks, (float)rot, (float)rotPrev)));
        UserPoseOverrider.anotherPoseRotN(matrixStackIn, entityLiving, partialTicks);
        matrixStackIn.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(180.0f - f));
    }

    public static void anotherPoseRotP(MatrixStack matrixStackIn, LivingEntity entityLiving, float partialTicks) {
        boolean isPositive = true;
        float np = 1.0f;
        float f = entityLiving.func_205015_b(partialTicks);
        if (entityLiving.func_184613_cA()) {
            float f1 = (float)entityLiving.func_184599_cB() + partialTicks;
            float f2 = MathHelper.func_76131_a((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!entityLiving.func_204805_cN()) {
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(1.0f * f2 * (-90.0f - entityLiving.field_70125_A)));
            }
            Vector3d vector3d = entityLiving.func_70676_i(partialTicks);
            Vector3d vector3d1 = entityLiving.func_213322_ci();
            double d0 = Entity.func_213296_b((Vector3d)vector3d1);
            double d1 = Entity.func_213296_b((Vector3d)vector3d);
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vector3d1.field_72450_a * vector3d.field_72450_a + vector3d1.field_72449_c * vector3d.field_72449_c) / Math.sqrt(d0 * d1);
                double d3 = vector3d1.field_72450_a * vector3d.field_72449_c - vector3d1.field_72449_c * vector3d.field_72450_a;
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)(1.0 * Math.signum(d3) * Math.acos(d2))));
            }
        } else if (f > 0.0f) {
            float f3 = entityLiving.func_70090_H() ? -90.0f - entityLiving.field_70125_A : -90.0f;
            float f4 = MathHelper.func_219799_g((float)f, (float)0.0f, (float)f3);
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(1.0f * f4));
            if (entityLiving.func_213314_bj()) {
                matrixStackIn.func_227861_a_(0.0, -1.0, (double)0.3f);
            }
        }
    }

    public static void anotherPoseRotN(MatrixStack matrixStackIn, LivingEntity entityLiving, float partialTicks) {
        boolean isPositive = false;
        float np = -1.0f;
        float f = entityLiving.func_205015_b(partialTicks);
        if (entityLiving.func_184613_cA()) {
            Vector3d vector3d = entityLiving.func_70676_i(partialTicks);
            Vector3d vector3d1 = entityLiving.func_213322_ci();
            double d0 = Entity.func_213296_b((Vector3d)vector3d1);
            double d1 = Entity.func_213296_b((Vector3d)vector3d);
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vector3d1.field_72450_a * vector3d.field_72450_a + vector3d1.field_72449_c * vector3d.field_72449_c) / Math.sqrt(d0 * d1);
                double d3 = vector3d1.field_72450_a * vector3d.field_72449_c - vector3d1.field_72449_c * vector3d.field_72450_a;
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)(-1.0 * Math.signum(d3) * Math.acos(d2))));
            }
            float f1 = (float)entityLiving.func_184599_cB() + partialTicks;
            float f2 = MathHelper.func_76131_a((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!entityLiving.func_204805_cN()) {
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-1.0f * f2 * (-90.0f - entityLiving.field_70125_A)));
            }
        } else if (f > 0.0f) {
            if (entityLiving.func_213314_bj()) {
                matrixStackIn.func_227861_a_(0.0, 1.0, (double)-0.3f);
            }
            float f3 = entityLiving.func_70090_H() ? -90.0f - entityLiving.field_70125_A : -90.0f;
            float f4 = MathHelper.func_219799_g((float)f, (float)0.0f, (float)f3);
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-1.0f * f4));
        }
    }

    public static void setRot(Entity target, float rotYaw, boolean isOffset) {
        CompoundNBT tag = target.getPersistentData();
        float prevRot = tag.func_74760_g(TAG_ROT);
        tag.func_74776_a(TAG_ROT_PREV, prevRot);
        if (isOffset) {
            rotYaw += prevRot;
        }
        tag.func_74776_a(TAG_ROT, rotYaw);
    }

    public static void resetRot(Entity target) {
        CompoundNBT tag = target.getPersistentData();
        tag.func_74776_a(TAG_ROT_PREV, 0.0f);
        tag.func_74776_a(TAG_ROT, 0.0f);
    }

    public static void invertRot(MatrixStack matrixStack, Entity entity, float partialTicks) {
        float rot = entity.getPersistentData().func_74760_g(TAG_ROT);
        float rotPrev = entity.getPersistentData().func_74760_g(TAG_ROT_PREV);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(MathHelper.func_219805_h((float)partialTicks, (float)rot, (float)rotPrev)));
    }

    private static final class SingletonHolder {
        private static final UserPoseOverrider instance = new UserPoseOverrider();

        private SingletonHolder() {
        }
    }
}

