/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.item;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.capability.inputstate.IInputState;
import mods.flammpfeil.slashblade.capability.slashblade.ComboState;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.entity.BladeItemEntity;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.util.InputCommand;
import mods.flammpfeil.slashblade.util.NBTHelper;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.SwordItem;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class ItemSlashBlade
extends SwordItem {
    protected static final UUID ATTACK_DAMAGE_AMPLIFIER = UUID.fromString("2D988C13-595B-4E58-B254-39BB6FA077FD");
    protected static final UUID PLAYER_REACH_AMPLIFIER = UUID.fromString("2D988C13-595B-4E58-B254-39BB6FA077FD");
    @CapabilityInject(value=ISlashBladeState.class)
    public static Capability<ISlashBladeState> BLADESTATE = null;
    @CapabilityInject(value=IInputState.class)
    public static Capability<IInputState> INPUT_STATE = null;
    public static final String ICON_TAG_KEY = "SlashBladeIcon";
    RangeMap refineColor = ImmutableRangeMap.builder().put(Range.lessThan((Comparable)Integer.valueOf(10)), (Object)TextFormatting.WHITE).put(Range.closedOpen((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(50)), (Object)TextFormatting.YELLOW).put(Range.closedOpen((Comparable)Integer.valueOf(50), (Comparable)Integer.valueOf(100)), (Object)TextFormatting.GREEN).put(Range.closedOpen((Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(150)), (Object)TextFormatting.AQUA).put(Range.closedOpen((Comparable)Integer.valueOf(150), (Comparable)Integer.valueOf(200)), (Object)TextFormatting.BLUE).put(Range.atLeast((Comparable)Integer.valueOf(200)), (Object)TextFormatting.LIGHT_PURPLE).build();

    public ItemSlashBlade(IItemTier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap def = super.getAttributeModifiers(slot, stack);
        ArrayListMultimap result = ArrayListMultimap.create();
        result.putAll((Object)Attributes.field_233823_f_, (Iterable)def.get((Object)Attributes.field_233823_f_));
        result.putAll((Object)Attributes.field_233825_h_, (Iterable)def.get((Object)Attributes.field_233825_h_));
        if (slot == EquipmentSlotType.MAINHAND) {
            LazyOptional state = stack.getCapability(BLADESTATE);
            state.ifPresent(arg_0 -> ItemSlashBlade.lambda$getAttributeModifiers$0((Multimap)result, arg_0));
        }
        return result;
    }

    public Rarity func_77613_e(ItemStack stack) {
        LazyOptional state = stack.getCapability(BLADESTATE);
        return state.filter(s -> s.getRarity() != Rarity.COMMON).map(s -> s.getRarity()).orElseGet(() -> super.func_77613_e(stack));
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        boolean result = itemstack.getCapability(BLADESTATE).map(state -> {
            playerIn.getCapability(INPUT_STATE).ifPresent(s -> s.getCommands().add(InputCommand.R_CLICK));
            ComboState combo = state.progressCombo((LivingEntity)playerIn);
            if (combo != ComboState.NONE) {
                state.setLastActionTime(worldIn.func_82737_E());
            }
            combo.clickAction((LivingEntity)playerIn);
            playerIn.getCapability(INPUT_STATE).ifPresent(s -> s.getCommands().remove((Object)InputCommand.R_CLICK));
            if (combo != ComboState.NONE) {
                playerIn.func_184609_a(handIn);
            }
            return true;
        }).orElse(false);
        playerIn.func_184598_c(handIn);
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    public boolean onLeftClickEntity(ItemStack itemstack, PlayerEntity playerIn, Entity entity) {
        World worldIn = playerIn.field_70170_p;
        Optional stateHolder = itemstack.getCapability(BLADESTATE).filter(state -> !state.onClick());
        stateHolder.ifPresent(state -> {
            playerIn.getCapability(INPUT_STATE).ifPresent(s -> s.getCommands().add(InputCommand.L_CLICK));
            ComboState combo = state.progressCombo((LivingEntity)playerIn);
            state.setLastActionTime(worldIn.func_82737_E());
            combo.clickAction((LivingEntity)playerIn);
            playerIn.getCapability(INPUT_STATE).ifPresent(s -> s.getCommands().remove((Object)InputCommand.L_CLICK));
        });
        return stateHolder.isPresent();
    }

    private Consumer<LivingEntity> getOnBroken(ItemStack stack) {
        return user -> {
            user.func_213334_d(user.func_184600_cs());
            ItemStack soul = new ItemStack((IItemProvider)SBItems.proudsoul);
            CompoundNBT blade = stack.func_77955_b(new CompoundNBT());
            soul.func_77983_a("BladeData", (INBT)blade);
            stack.getCapability(BLADESTATE).ifPresent(s -> {
                s.getTexture().ifPresent(r -> soul.func_77983_a("Texture", (INBT)StringNBT.func_229705_a_((String)r.toString())));
                s.getModel().ifPresent(r -> soul.func_77983_a("Model", (INBT)StringNBT.func_229705_a_((String)r.toString())));
            });
            ItemEntity itementity = new ItemEntity(user.field_70170_p, user.func_226277_ct_(), user.func_226278_cu_(), user.func_226281_cx_(), soul);
            BladeItemEntity e = new BladeItemEntity(SlashBlade.RegistryEvents.BladeItem, user.field_70170_p);
            e.func_180432_n((Entity)itementity);
            e.init();
            e.func_70024_g(0.0, 0.4, 0.0);
            e.func_174867_a(40);
            e.func_184195_f(true);
            e.func_70050_g(-1);
            user.field_70170_p.func_217376_c((Entity)e);
        };
    }

    public boolean func_77644_a(ItemStack stackF, LivingEntity target, LivingEntity attacker) {
        ItemStack stack = attacker.func_184614_ca();
        stack.getCapability(BLADESTATE).ifPresent(state -> {
            state.resolvCurrentComboState(attacker).hitEffect(target, attacker);
            state.damageBlade(stack, 1, attacker, this.getOnBroken(stack));
        });
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            stack.getCapability(BLADESTATE).ifPresent(s -> s.damageBlade(stack, 1, entityLiving, this.getOnBroken(stack)));
        }
        return true;
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        int elapsed = this.func_77626_a(stack) - timeLeft;
        if (!worldIn.field_72995_K) {
            stack.getCapability(BLADESTATE).ifPresent(state -> {
                ComboState sa = state.doChargeAction(entityLiving, elapsed);
                if (sa != ComboState.NONE) {
                    state.damageBlade(stack, 1, entityLiving, this.getOnBroken(stack));
                    entityLiving.func_184609_a(Hand.MAIN_HAND);
                }
            });
        }
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        stack.getCapability(BLADESTATE).ifPresent(state -> {
            int ticks;
            state.getComboSeq().holdAction(player);
            if (!player.field_70170_p.field_72995_K && 0 < (ticks = player.func_184612_cw()) && ticks == 20) {
                Vector3d pos = player.func_174824_e(1.0f).func_178787_e(player.func_70040_Z());
                ((ServerWorld)player.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197599_J, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 7, 0.7, 0.7, 0.7, 0.02);
            }
        });
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!isSelected) {
            return;
        }
        if (stack == null) {
            return;
        }
        if (entityIn == null) {
            return;
        }
        stack.getCapability(BLADESTATE).ifPresent(state -> {
            if (entityIn instanceof LivingEntity) {
                state.resolvCurrentComboState((LivingEntity)entityIn).tickAction((LivingEntity)entityIn);
                state.sendChanges(entityIn);
            }
        });
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        return stack.getCapability(BLADESTATE).filter(s -> s.getShareTag() != null).map(s -> {
            CompoundNBT tag = s.getShareTag();
            tag.func_74778_a("translationKey", s.getTranslationKey());
            if (tag.func_74767_n("isBroken") != s.isBroken()) {
                tag.func_74778_a("isBroken", Boolean.toString(s.isBroken()));
            }
            stack.func_77983_a("ShareTag", (INBT)tag);
            return stack.func_77978_p();
        }).orElseGet(() -> {
            CompoundNBT tag = stack.getCapability(BLADESTATE).map(s -> NBTHelper.getNBTCoupler(stack.func_196082_o()).getChild("ShareTag").put("translationKey", s.getTranslationKey()).put("isBroken", Boolean.toString(s.isBroken())).put("isNoScabbard", Boolean.toString(s.isNoScabbard())).getRawCompound()).orElseGet(() -> new CompoundNBT());
            stack.getCapability(BLADESTATE).ifPresent(s -> s.setShareTag(tag));
            return stack.func_77978_p();
        });
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        super.readShareTag(stack, nbt);
        if (nbt == null) {
            return;
        }
        if (nbt.func_74764_b(ICON_TAG_KEY)) {
            stack.deserializeNBT(nbt.func_74775_l(ICON_TAG_KEY));
            return;
        }
    }

    int getHalfMaxdamage() {
        return this.func_77612_l() / 2;
    }

    public int getDamage(ItemStack stack) {
        return this.getHalfMaxdamage();
    }

    public void setDamage(ItemStack stack, int damage) {
        if (damage == this.getHalfMaxdamage()) {
            return;
        }
        if (damage > stack.func_77958_k()) {
            stack.func_190920_e(2);
        }
        stack.getCapability(BLADESTATE).ifPresent(s -> {
            float amount = (float)(damage - this.getHalfMaxdamage()) / (float)this.func_77612_l();
            s.setDamage(s.getDamage() + amount);
        });
    }

    public boolean isDamaged(ItemStack stack) {
        return stack.getCapability(BLADESTATE).map(s -> 0.0f < s.getDamage()).orElse(false);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return Math.min(amount, this.getHalfMaxdamage() / 2);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return Minecraft.func_71410_x().field_71439_g.func_184614_ca() == stack;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return stack.getCapability(BLADESTATE).map(s -> Float.valueOf(s.getDamage())).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        boolean isBroken = stack.getCapability(BLADESTATE).filter(s -> s.isBroken()).isPresent();
        return isBroken ? 16737966 : 188654;
    }

    public String func_77667_c(ItemStack stack) {
        return stack.getCapability(BLADESTATE).filter(s -> !s.getTranslationKey().isEmpty()).map(state -> state.getTranslationKey()).orElseGet(() -> super.func_77667_c(stack));
    }

    protected boolean func_194125_a(ItemGroup group) {
        if (group == SlashBlade.SLASHBLADE) {
            return true;
        }
        return super.func_194125_a(group);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RecipeManager getClientRM() {
        ClientWorld cw = Minecraft.func_71410_x().field_71441_e;
        if (cw != null) {
            return cw.func_199532_z();
        }
        return null;
    }

    public static RecipeManager getServerRM() {
        MinecraftServer sw = ServerLifecycleHooks.getCurrentServer();
        if (sw != null) {
            return sw.func_199529_aN();
        }
        return null;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        super.func_150895_a(group, items);
        if (group == SlashBlade.SLASHBLADE) {
            RecipeManager rm = (RecipeManager)DistExecutor.runForDist(() -> ItemSlashBlade::getClientRM, () -> ItemSlashBlade::getServerRM);
            if (rm == null) {
                return;
            }
            Set keys = rm.func_215378_c().filter(loc -> loc.func_110624_b().equals("slashblade") && !loc.func_110623_a().startsWith("material") && !loc.func_110623_a().startsWith("bladestand") && !loc.func_110623_a().startsWith("simple_slashblade")).collect(Collectors.toSet());
            List allItems = keys.stream().map(key -> rm.func_215367_a(key).map(r -> {
                ItemStack stack = r.func_77571_b().func_77946_l();
                stack.readShareTag(stack.getShareTag());
                return stack;
            }).orElseGet(() -> ItemStack.field_190927_a)).sorted(Comparator.comparing(s -> ((ItemStack)s).func_77977_a()).reversed()).collect(Collectors.toList());
            items.addAll(allItems);
        }
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return super.func_82789_a(toRepair, repair);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        stack.getCapability(BLADESTATE).ifPresent(s -> {
            if (0 < s.getKillCount()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("slashblade.tooltip.killcount", new Object[]{s.getKillCount()}));
            }
            if (0 < s.getRefine()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("slashblade.tooltip.refine", new Object[]{s.getRefine()}).func_240699_a_((TextFormatting)this.refineColor.get((Comparable)Integer.valueOf(s.getRefine()))));
            }
        });
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return !stack.getCapability(BLADESTATE).filter(s -> s.getLastActionTime() == entity.field_70170_p.func_82737_E()).isPresent();
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Nullable
    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        BladeItemEntity e = new BladeItemEntity(SlashBlade.RegistryEvents.BladeItem, world);
        e.func_180432_n(location);
        e.init();
        return e;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return super.getEntityLifespan(itemStack, world);
    }

    private static /* synthetic */ void lambda$getAttributeModifiers$0(Multimap result, ISlashBladeState s) {
        float baseAttackModifier = s.getBaseAttackModifier();
        AttributeModifier base = new AttributeModifier(field_111210_e, "Weapon modifier", (double)baseAttackModifier, AttributeModifier.Operation.ADDITION);
        result.remove((Object)Attributes.field_233823_f_, (Object)base);
        result.put((Object)Attributes.field_233823_f_, (Object)base);
        float rankAttackAmplifier = s.getAttackAmplifier();
        result.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(ATTACK_DAMAGE_AMPLIFIER, "Weapon amplifier", (double)rankAttackAmplifier, AttributeModifier.Operation.ADDITION));
        result.put((Object)ForgeMod.REACH_DISTANCE.get(), (Object)new AttributeModifier(PLAYER_REACH_AMPLIFIER, "Reach amplifer", s.isBroken() ? 0.0 : 1.5, AttributeModifier.Operation.ADDITION));
    }
}

