/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.network;

import java.util.function.Consumer;
import java.util.function.Supplier;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class RankSyncMessage {
    public long rawPoint;

    public static RankSyncMessage decode(PacketBuffer buf) {
        RankSyncMessage msg = new RankSyncMessage();
        msg.rawPoint = buf.readLong();
        return msg;
    }

    public static void encode(RankSyncMessage msg, PacketBuffer buf) {
        buf.writeLong(msg.rawPoint);
    }

    public static void handle(RankSyncMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().setPacketHandled(true);
        if (ctx.get().getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            return;
        }
        Consumer handler = (Consumer)DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> RankSyncMessage::setPoint);
        if (handler != null) {
            ctx.get().enqueueWork(() -> handler.accept(msg.rawPoint));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setPoint(long point) {
        ClientPlayerEntity pl = Minecraft.func_71410_x().field_71439_g;
        pl.getCapability(CapabilityConcentrationRank.RANK_POINT).ifPresent(arg_0 -> RankSyncMessage.lambda$setPoint$3((PlayerEntity)pl, point, arg_0));
    }

    private static /* synthetic */ void lambda$setPoint$3(PlayerEntity pl, long point, IConcentrationRank cr) {
        long time = pl.field_70170_p.func_82737_E();
        IConcentrationRank.ConcentrationRanks oldRank = cr.getRank(time);
        cr.setRawRankPoint(point);
        cr.setLastUpdte(time);
        if (oldRank.level < cr.getRank((long)time).level) {
            cr.setLastRankRise(time);
        }
    }
}

