/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.util;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.ability.ArrowReflector;
import mods.flammpfeil.slashblade.ability.TNTExtinguisher;
import mods.flammpfeil.slashblade.capability.concentrationrank.ConcentrationRankCapabilityProvider;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import mods.flammpfeil.slashblade.entity.EntitySlashEffect;
import mods.flammpfeil.slashblade.entity.IShootable;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.KnockBacks;
import mods.flammpfeil.slashblade.util.TargetSelector;
import mods.flammpfeil.slashblade.util.VectorHelper;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;

public class AttackManager {
    public static void areaAttack(LivingEntity playerIn, Consumer<LivingEntity> beforeHit) {
        AttackManager.areaAttack(playerIn, beforeHit, 1.0f, true, true, false);
    }

    public static void doSlash(LivingEntity playerIn, float roll) {
        AttackManager.doSlash(playerIn, roll, false);
    }

    public static void doSlash(LivingEntity playerIn, float roll, boolean mute) {
        AttackManager.doSlash(playerIn, roll, mute, false);
    }

    public static void doSlash(LivingEntity playerIn, float roll, boolean mute, boolean critical) {
        AttackManager.doSlash(playerIn, roll, mute, critical, 1.0);
    }

    public static void doSlash(LivingEntity playerIn, float roll, boolean mute, boolean critical, double damage) {
        AttackManager.doSlash(playerIn, roll, Vector3d.field_186680_a, mute, critical, damage);
    }

    public static void doSlash(LivingEntity playerIn, float roll, Vector3d centerOffset, boolean mute, boolean critical, double damage) {
        AttackManager.doSlash(playerIn, roll, centerOffset, mute, critical, damage, KnockBacks.cancel);
    }

    public static void doSlash(LivingEntity playerIn, float roll, Vector3d centerOffset, boolean mute, boolean critical, double damage, KnockBacks knockback) {
        int colorCode = playerIn.func_184614_ca().getCapability(ItemSlashBlade.BLADESTATE).map(state -> state.getColorCode()).orElseGet(() -> 0xFFFFFF);
        AttackManager.doSlash(playerIn, roll, colorCode, centerOffset, mute, critical, damage, knockback);
    }

    public static void doSlash(LivingEntity playerIn, float roll, int colorCode, Vector3d centerOffset, boolean mute, boolean critical, double damage, KnockBacks knockback) {
        if (playerIn.field_70170_p.field_72995_K) {
            return;
        }
        Vector3d pos = playerIn.func_213303_ch().func_72441_c(0.0, (double)playerIn.func_70047_e() * 0.75, 0.0).func_178787_e(playerIn.func_70040_Z().func_186678_a((double)0.3f));
        pos = pos.func_178787_e(VectorHelper.getVectorForRotation(-90.0f, playerIn.func_195046_g(0.0f)).func_186678_a(centerOffset.field_72448_b)).func_178787_e(VectorHelper.getVectorForRotation(0.0f, playerIn.func_195046_g(0.0f) + 90.0f).func_186678_a(centerOffset.field_72449_c)).func_178787_e(playerIn.func_70040_Z().func_186678_a(centerOffset.field_72449_c));
        EntitySlashEffect jc = new EntitySlashEffect(SlashBlade.RegistryEvents.SlashEffect, playerIn.field_70170_p);
        jc.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        jc.func_212361_a((Entity)playerIn);
        jc.setRotationRoll(roll);
        jc.field_70177_z = playerIn.field_70177_z;
        jc.field_70125_A = 0.0f;
        jc.setColor(colorCode);
        jc.setMute(mute);
        jc.setIsCritical(critical);
        jc.setDamage(damage);
        jc.setKnockBack(knockback);
        playerIn.field_70170_p.func_217376_c((Entity)jc);
    }

    public static List<Entity> areaAttack(LivingEntity playerIn, Consumer<LivingEntity> beforeHit, float ratio, boolean forceHit, boolean resetHit, boolean mute) {
        return AttackManager.areaAttack(playerIn, beforeHit, ratio, forceHit, resetHit, mute, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Entity> areaAttack(LivingEntity playerIn, Consumer<LivingEntity> beforeHit, float ratio, boolean forceHit, boolean resetHit, boolean mute, List<Entity> exclude) {
        List<Object> founds = Lists.newArrayList();
        float modifiedRatio = (1.0f + EnchantmentHelper.func_191527_a((LivingEntity)playerIn) * 0.5f) * ratio;
        AttributeModifier am = new AttributeModifier("SweepingDamageRatio", (double)modifiedRatio, AttributeModifier.Operation.MULTIPLY_BASE);
        if (!playerIn.field_70170_p.func_201670_d()) {
            try {
                playerIn.func_110148_a(Attributes.field_233823_f_).func_233767_b_(am);
                founds = TargetSelector.getTargettableEntitiesWithinAABB(playerIn.field_70170_p, playerIn);
                if (exclude != null) {
                    founds.removeAll(exclude);
                }
                for (Entity entity : founds) {
                    if (entity instanceof LivingEntity) {
                        beforeHit.accept((LivingEntity)entity);
                    }
                    AttackManager.doMeleeAttack(playerIn, entity, forceHit, resetHit);
                }
            }
            finally {
                playerIn.func_110148_a(Attributes.field_233823_f_).func_111124_b(am);
            }
        }
        if (!mute) {
            playerIn.field_70170_p.func_184148_a((PlayerEntity)null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187730_dW, SoundCategory.PLAYERS, 0.5f, 0.4f / (playerIn.func_70681_au().nextFloat() * 0.4f + 0.8f));
        }
        return founds;
    }

    public static <E extends Entity> List<Entity> areaAttack(E owner, Consumer<LivingEntity> beforeHit, double reach, boolean forceHit, boolean resetHit) {
        return AttackManager.areaAttack(owner, beforeHit, reach, forceHit, resetHit, null);
    }

    public static <E extends Entity> List<Entity> areaAttack(E owner, Consumer<LivingEntity> beforeHit, double reach, boolean forceHit, boolean resetHit, List<Entity> exclude) {
        List<Object> founds = Lists.newArrayList();
        AxisAlignedBB bb = owner.func_174813_aQ();
        if (!owner.field_70170_p.func_201670_d()) {
            founds = TargetSelector.getTargettableEntitiesWithinAABB(owner.field_70170_p, reach, owner);
            if (exclude != null) {
                founds.removeAll(exclude);
            }
            for (Entity entity : founds) {
                if (entity instanceof LivingEntity) {
                    beforeHit.accept((LivingEntity)entity);
                }
                float baseAmount = (float)((IShootable)owner).getDamage();
                AttackManager.doAttackWith(DamageSource.func_76354_b(owner, (Entity)((IShootable)owner).getShooter()), baseAmount, entity, forceHit, resetHit);
            }
        }
        return founds;
    }

    public static void doManagedAttack(Consumer<Entity> attack, Entity target, boolean forceHit, boolean resetHit) {
        if (forceHit) {
            target.field_70172_ad = 0;
        }
        attack.accept(target);
        if (resetHit) {
            target.field_70172_ad = 0;
        }
    }

    public static void doAttackWith(DamageSource src, float amount, Entity target, boolean forceHit, boolean resetHit) {
        AttackManager.doManagedAttack(t -> t.func_70097_a(src, amount), target, forceHit, resetHit);
    }

    public static void doMeleeAttack(LivingEntity attacker, Entity target, boolean forceHit, boolean resetHit) {
        if (attacker instanceof PlayerEntity) {
            AttackManager.doManagedAttack(t -> attacker.func_184614_ca().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
                IConcentrationRank.ConcentrationRanks rankBonus = attacker.getCapability(ConcentrationRankCapabilityProvider.RANK_POINT).map(rp -> rp.getRank(attacker.func_130014_f_().func_82737_E())).orElse(IConcentrationRank.ConcentrationRanks.NONE);
                float modifiedRatio = (float)rankBonus.level / 2.0f;
                if (attacker instanceof PlayerEntity && IConcentrationRank.ConcentrationRanks.S.level <= rankBonus.level) {
                    int level = ((PlayerEntity)attacker).field_71068_ca;
                    modifiedRatio = Math.max(modifiedRatio, (float)Math.min(level, state.getRefine()));
                }
                AttributeModifier am = new AttributeModifier("RankDamageBonus", (double)modifiedRatio, AttributeModifier.Operation.ADDITION);
                try {
                    state.setOnClick(true);
                    attacker.func_110148_a(Attributes.field_233823_f_).func_233767_b_(am);
                    ((PlayerEntity)attacker).func_71059_n(t);
                }
                finally {
                    attacker.func_110148_a(Attributes.field_233823_f_).func_111124_b(am);
                    state.setOnClick(false);
                }
            }), target, forceHit, resetHit);
        } else {
            float baseAmount = (float)attacker.func_110148_a(Attributes.field_233823_f_).func_111126_e();
            AttackManager.doAttackWith(DamageSource.func_76358_a((LivingEntity)attacker), baseAmount, target, forceHit, resetHit);
        }
        ArrowReflector.doReflect(target, (Entity)attacker);
        TNTExtinguisher.doExtinguishing(target, attacker);
    }
}

