/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.util;

import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;

public class JSONUtil {
    private static final Pattern SIMPLE_VALUE = Pattern.compile("[A-Za-z0-9._+-]+");

    static String handleEscape(String str) {
        return SIMPLE_VALUE.matcher(str).matches() ? str : StringNBT.func_197654_a((String)str);
    }

    public static String NBTtoJsonString(INBT childTag) {
        String str;
        byte i = childTag.func_74732_a();
        if (childTag instanceof CompoundNBT) {
            str = JSONUtil.NBTtoJsonString((CompoundNBT)childTag);
        } else if (childTag instanceof ListNBT) {
            str = JSONUtil.NBTtoJsonString((ListNBT)childTag);
        } else if (i == 1 || i == 2 || i == 3 || i == 4 || i == 5 || i == 6) {
            str = childTag.toString();
            str = str.replaceAll("[fdbsL]", "");
        } else {
            str = childTag.toString();
        }
        return str;
    }

    public static String NBTtoJsonString(ListNBT list) {
        StringBuilder stringbuilder = new StringBuilder("[");
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                stringbuilder.append(',');
            }
            stringbuilder.append(JSONUtil.NBTtoJsonString(list.get(i)));
        }
        return stringbuilder.append(']').toString();
    }

    public static String NBTtoJsonString(CompoundNBT tag) {
        StringBuilder stringbuilder = new StringBuilder("{");
        Set collection = tag.func_150296_c();
        for (String s : collection) {
            if (stringbuilder.length() != 1) {
                stringbuilder.append(',');
            }
            stringbuilder.append(JSONUtil.handleEscape(s)).append(':').append(JSONUtil.NBTtoJsonString(tag.func_74781_a(s)));
        }
        return stringbuilder.append('}').toString();
    }
}

