/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.util;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class RayTraceHelper {
    public static Optional<RayTraceResult> rayTrace(World worldIn, Entity entityIn, Vector3d start, Vector3d dir, double blockReach, double entityReach, Predicate<Entity> selector) {
        Vector3d end = start.func_178787_e(dir.func_186678_a(blockReach));
        BlockRayTraceResult raytraceresult = worldIn.func_217299_a(new RayTraceContext(start, end, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entityIn));
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
            end = raytraceresult.func_216347_e();
            entityReach = start.func_72438_d(end);
        } else {
            end = start.func_178787_e(dir.func_186678_a(entityReach));
        }
        AxisAlignedBB area = entityIn.func_174813_aQ().func_216361_a(dir.func_186678_a(entityReach)).func_186662_g(1.0);
        EntityRayTraceResult entityraytraceresult = RayTraceHelper.rayTrace(worldIn, entityIn, start, end, area, selector);
        if (entityraytraceresult != null) {
            raytraceresult = entityraytraceresult;
        }
        return Optional.ofNullable(raytraceresult);
    }

    @Nullable
    public static EntityRayTraceResult rayTrace(World worldIn, Entity entityIn, Vector3d start, Vector3d end, AxisAlignedBB boundingBox, Predicate<Entity> selector) {
        return RayTraceHelper.rayTrace(worldIn, entityIn, start, end, boundingBox, selector, Double.MAX_VALUE);
    }

    @Nullable
    public static EntityRayTraceResult rayTrace(World worldIn, Entity entityIn, Vector3d start, Vector3d end, AxisAlignedBB boundingBox, Predicate<Entity> selector, double limitDist) {
        double currentDist = limitDist;
        Entity resultEntity = null;
        for (Entity foundEntity : worldIn.func_175674_a(entityIn, boundingBox, selector)) {
            double newDist;
            AxisAlignedBB axisalignedbb = foundEntity.func_174813_aQ().func_186662_g((double)0.3f);
            Optional optional = axisalignedbb.func_216365_b(start, end);
            if (!optional.isPresent() || !((newDist = start.func_72436_e((Vector3d)optional.get())) < currentDist)) continue;
            resultEntity = foundEntity;
            currentDist = newDist;
        }
        if (resultEntity == null) {
            return null;
        }
        return new EntityRayTraceResult(resultEntity);
    }
}

