/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.block;

import com.minecraftabnormals.environmental.common.tile.SlabfishEffigyTileEntity;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalTileEntities;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class SlabfishEffigyBlock
extends ContainerBlock
implements IWaterLoggable {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.field_208157_J;

    public SlabfishEffigyBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof SlabfishEffigyTileEntity) {
            SlabfishEffigyTileEntity mudvasetileentity = (SlabfishEffigyTileEntity)tileentity;
            ItemStack itemstack = player.func_184586_b(handIn);
            if (itemstack.func_190926_b()) {
                if (mudvasetileentity.removeItem(player, handIn)) {
                    return ActionResultType.SUCCESS;
                }
            } else if (mudvasetileentity.addItem(player.field_71075_bZ.field_75098_d ? itemstack.func_77946_l() : itemstack)) {
                worldIn.func_184133_a(player, pos, SoundEvents.field_187719_p, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof SlabfishEffigyTileEntity) {
                InventoryHelper.func_219961_a((World)worldIn, (BlockPos)pos, ((SlabfishEffigyTileEntity)tileentity).getInventory());
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{HORIZONTAL_FACING, WATERLOGGED});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos;
        World iworld = context.func_195991_k();
        boolean flag = iworld.func_204610_c(blockpos = context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).func_206870_a((Property)HORIZONTAL_FACING, (Comparable)context.func_195992_f());
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof SlabfishEffigyTileEntity) {
            ((SlabfishEffigyTileEntity)tileentity).func_213903_a(stack.func_200301_q());
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return SlabfishEffigyTileEntity.calcRedstone(worldIn.func_175625_s(pos));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)HORIZONTAL_FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)));
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return ((TileEntityType)EnvironmentalTileEntities.SLABFISH_EFFIGY.get()).func_200968_a();
    }
}

