/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.entity;

import com.minecraftabnormals.environmental.common.entity.util.DeerCoatColors;
import com.minecraftabnormals.environmental.common.entity.util.DeerCoatTypes;
import com.minecraftabnormals.environmental.core.other.EnvironmentalTags;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalEntities;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalItems;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public class DeerEntity
extends AnimalEntity {
    private static final DataParameter<Integer> DEER_COAT_COLOR = EntityDataManager.func_187226_a(DeerEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DEER_COAT_TYPE = EntityDataManager.func_187226_a(DeerEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> HAS_ANTLERS = EntityDataManager.func_187226_a(DeerEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final Predicate<Entity> SHOULD_AVOID = entity -> !entity.func_226273_bm_() && EntityPredicates.field_188444_d.test(entity);
    private static final UUID SPEED_MODIFIER = UUID.fromString("a21208ef-5399-4341-800f-d5a9152afe98");
    private int floweringTime = 0;
    private List<BlockState> flowers = new ArrayList<BlockState>();

    public DeerEntity(EntityType<? extends AnimalEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 2.5));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 22.0f, 2.0, 2.7, SHOULD_AVOID::test));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.25, false, Ingredient.func_199805_a(EnvironmentalTags.Items.DEER_TEMPTATION_ITEMS)));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DEER_COAT_COLOR, (Object)0);
        this.field_70180_af.func_187214_a(DEER_COAT_TYPE, (Object)0);
        this.field_70180_af.func_187214_a(HAS_ANTLERS, (Object)true);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("CoatColor", this.getCoatColor());
        compound.func_74768_a("CoatType", this.getCoatType());
        compound.func_74757_a("Antlers", this.hasAntlers());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setCoatColor(compound.func_74762_e("CoatColor"));
        this.setCoatType(compound.func_74762_e("CoatType"));
        this.setHasAntlers(compound.func_74767_n("Antlers"));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            AttributeModifier floweringModifier = new AttributeModifier(SPEED_MODIFIER, "Flowering speed boost", (double)0.07f, AttributeModifier.Operation.ADDITION);
            if (this.floweringTime > 0) {
                --this.floweringTime;
                if (!this.func_110148_a(Attributes.field_233821_d_).func_180374_a(floweringModifier)) {
                    this.func_110148_a(Attributes.field_233821_d_).func_233767_b_(floweringModifier);
                }
                if (!this.flowers.isEmpty() && this.field_70170_p.func_82737_E() % 30L == 0L) {
                    BlockPos position = this.func_233580_cy_();
                    BlockState state = this.flowers.get(this.field_70146_Z.nextInt(this.flowers.size()));
                    if (state.func_177230_c() instanceof DoublePlantBlock) {
                        DoublePlantBlock block = (DoublePlantBlock)state.func_177230_c();
                        if (state.func_196955_c((IWorldReader)this.field_70170_p, position) && this.field_70170_p.func_175623_d(position) && this.field_70170_p.func_175623_d(position.func_177984_a())) {
                            block.func_196390_a((IWorld)this.field_70170_p, position, 2);
                            this.field_70170_p.func_217379_c(2005, position, 0);
                        }
                    } else if (state.func_196955_c((IWorldReader)this.field_70170_p, position) && this.field_70170_p.func_175623_d(position)) {
                        this.field_70170_p.func_180501_a(position, state, 3);
                        this.field_70170_p.func_217379_c(2005, position, 0);
                    }
                }
            } else {
                this.flowers.clear();
                if (this.func_110148_a(Attributes.field_233821_d_).func_180374_a(floweringModifier)) {
                    this.func_110148_a(Attributes.field_233821_d_).func_111124_b(floweringModifier);
                }
            }
        }
    }

    private void particleCloud(IParticleData particle) {
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a(particle, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d0, d1, d2);
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        Item item = stack.func_77973_b();
        if (!this.func_70631_g_()) {
            if (item == Items.field_151127_ba) {
                this.floweringTime += 200;
                this.particleCloud((IParticleData)ParticleTypes.field_197632_y);
                this.func_175505_a(player, stack);
                return ActionResultType.SUCCESS;
            }
            if (item == Items.field_151060_bw) {
                this.floweringTime += 600;
                this.particleCloud((IParticleData)ParticleTypes.field_197632_y);
                this.func_175505_a(player, stack);
                return ActionResultType.SUCCESS;
            }
            if (this.floweringTime > 0 && item.func_206844_a((ITag)ItemTags.field_226159_I_) && item instanceof BlockItem) {
                BlockItem block = (BlockItem)item;
                if (!this.flowers.contains(block.func_179223_d().func_176223_P())) {
                    this.flowers.add(block.func_179223_d().func_176223_P());
                    this.particleCloud((IParticleData)ParticleTypes.field_197632_y);
                }
                this.func_175505_a(player, stack);
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_230254_b_(player, hand);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_219631_du;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_219635_dy;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_219633_dw;
    }

    private void setCoatColor(int id) {
        this.field_70180_af.func_187227_b(DEER_COAT_COLOR, (Object)id);
    }

    public int getCoatColor() {
        return (Integer)this.field_70180_af.func_187225_a(DEER_COAT_COLOR);
    }

    private void setCoatType(int id) {
        this.field_70180_af.func_187227_b(DEER_COAT_TYPE, (Object)id);
    }

    public int getCoatType() {
        return (Integer)this.field_70180_af.func_187225_a(DEER_COAT_TYPE);
    }

    private void setHasAntlers(boolean antlers) {
        this.field_70180_af.func_187227_b(HAS_ANTLERS, (Object)antlers);
    }

    public boolean hasAntlers() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_ANTLERS);
    }

    public void setDeerData(DeerCoatColors coatColor, DeerCoatTypes coatType, boolean antlers) {
        this.setCoatColor(coatColor.getId());
        this.setCoatType(coatType.getId());
        this.setHasAntlers(antlers);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b().func_206844_a(EnvironmentalTags.Items.DEER_BREEDING_ITEMS);
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity ageable) {
        DeerEntity entity = (DeerEntity)((EntityType)EnvironmentalEntities.DEER.get()).func_200721_a((World)world);
        if (this.isHolidayDeer()) {
            entity.setCoatColor(DeerCoatColors.HOLIDAY.getId());
        } else {
            entity.setCoatColor(((DeerEntity)ageable).getCoatColor());
        }
        entity.setCoatType(this.getCoatType());
        entity.setHasAntlers(this.field_70146_Z.nextBoolean());
        return entity;
    }

    public boolean isHolidayDeer() {
        LocalDate localdate = LocalDate.now();
        int day = localdate.get(ChronoField.DAY_OF_MONTH);
        int month = localdate.get(ChronoField.MONTH_OF_YEAR);
        return month == 12 && day >= 21 && day <= 31 && this.field_70146_Z.nextFloat() < 0.5f && this.field_70170_p.func_226691_t_(this.func_233580_cy_()).func_201856_r() == Biome.Category.ICY;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return AnimalEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, 0.15);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)EnvironmentalItems.DEER_SPAWN_EGG.get());
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficulty, reason, spawnDataIn, dataTag);
        if (this.isHolidayDeer()) {
            this.setCoatColor(DeerCoatColors.HOLIDAY.getId());
        } else {
            this.setCoatColor(this.field_70146_Z.nextInt(2));
        }
        this.setCoatType(this.field_70146_Z.nextInt(DeerCoatTypes.values().length));
        this.setHasAntlers(this.field_70146_Z.nextBoolean());
        return super.func_213386_a(worldIn, difficulty, reason, spawnDataIn, dataTag);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

