/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.entity;

import com.minecraftabnormals.environmental.api.IEggLayingEntity;
import com.minecraftabnormals.environmental.common.entity.goals.DuckSwimGoal;
import com.minecraftabnormals.environmental.common.entity.goals.LayEggInNestGoal;
import com.minecraftabnormals.environmental.core.other.EnvironmentalTags;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalEntities;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalItems;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalSounds;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class DuckEntity
extends AnimalEntity
implements IEggLayingEntity {
    private static final DataParameter<Integer> EATING = EntityDataManager.func_187226_a(DuckEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private float wingRotation;
    private float destPos;
    private float oFlapSpeed;
    private float oFlap;
    private float wingRotDelta = 1.0f;
    private float headLean;
    private float prevHeadLean;
    public int timeUntilNextEgg = this.field_70146_Z.nextInt(6000) + 6000;
    public boolean duckJockey;

    public DuckEntity(EntityType<? extends AnimalEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new DuckSwimGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.4));
        this.field_70714_bg.func_75776_a(2, (Goal)new LayEggInNestGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.0, false, Ingredient.func_199805_a(EnvironmentalTags.Items.DUCK_BREEDING_ITEMS)));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(EATING, (Object)0);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? sizeIn.field_220316_b * 0.85f : sizeIn.field_220316_b * 0.92f;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 4.0).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    public void func_70636_d() {
        super.func_70636_d();
        double d0 = this.func_233571_b_((ITag)FluidTags.field_206959_a);
        boolean flag = !this.func_70631_g_() && d0 > 0.3 || this.func_70631_g_() && d0 > 0.15;
        this.oFlap = this.wingRotation;
        this.oFlapSpeed = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E || this.field_70171_ac ? -1 : 4) * 0.3);
        this.destPos = MathHelper.func_76131_a((float)this.destPos, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && !flag && this.wingRotDelta < 1.0f) {
            this.wingRotDelta = 1.0f;
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        this.wingRotation += this.wingRotDelta * 2.0f;
        this.prevHeadLean = this.headLean;
        if (this.isEating()) {
            this.headLean += (1.0f - this.headLean) * 0.4f + 0.05f;
            if (this.headLean > 1.0f) {
                this.headLean = 1.0f;
            }
        } else {
            this.headLean += (0.0f - this.headLean) * 0.4f - 0.05f;
            if (this.headLean < 0.0f) {
                this.headLean = 0.0f;
            }
        }
        Vector3d vector3d = this.func_213322_ci();
        if (!this.field_70122_E && vector3d.field_72448_b < 0.0) {
            this.func_213317_d(vector3d.func_216372_d(1.0, 0.6, 1.0));
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70089_S() && !this.func_70631_g_() && !this.field_70171_ac && !this.isDuckJockey() && --this.timeUntilNextEgg <= 0) {
                this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                this.func_199703_a((IItemProvider)this.getEggItem());
                this.timeUntilNextEgg = this.getNextEggTime(this.field_70146_Z);
            }
            if (this.isEating()) {
                if (this.field_70171_ac && !this.func_70880_s()) {
                    this.setEatingTime(this.getEatingTime() - 1);
                } else {
                    this.setEatingTime(0);
                }
            } else if (!this.func_70880_s() && this.field_70146_Z.nextInt(300) == 0 && this.field_70171_ac) {
                this.setEatingTime(40 + this.field_70146_Z.nextInt(20));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getWingRotation(float partialTicks) {
        float f = MathHelper.func_219799_g((float)partialTicks, (float)this.oFlap, (float)this.wingRotation);
        float f1 = MathHelper.func_219799_g((float)partialTicks, (float)this.oFlapSpeed, (float)this.destPos);
        return (MathHelper.func_76126_a((float)f) + 1.0f) * f1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadLean(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevHeadLean, (float)this.headLean);
    }

    public boolean isEating() {
        return this.getEatingTime() > 0;
    }

    public int getEatingTime() {
        return (Integer)this.field_70180_af.func_187225_a(EATING);
    }

    public void setEatingTime(int eatingTimeIn) {
        this.field_70180_af.func_187227_b(EATING, (Object)eatingTimeIn);
    }

    public static boolean canDuckSpawn(EntityType<? extends AnimalEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return (worldIn.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_196658_i) || worldIn.func_204610_c(pos.func_177977_b()).func_206884_a((ITag)FluidTags.field_206959_a)) && worldIn.func_226659_b_(pos, 0) > 8;
    }

    protected float func_189749_co() {
        return 0.9f;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187660_W;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187666_Z;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187663_X;
    }

    @Override
    public SoundEvent getEggLayingSound() {
        return (SoundEvent)EnvironmentalSounds.ENTITY_DUCK_EGG.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 1.0f);
    }

    public boolean func_70877_b(ItemStack stack) {
        return Ingredient.func_199805_a(EnvironmentalTags.Items.DUCK_BREEDING_ITEMS).test(stack);
    }

    protected int func_70693_a(PlayerEntity player) {
        return this.isDuckJockey() ? 10 : super.func_70693_a(player);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.duckJockey = compound.func_74767_n("IsDuckJockey");
        if (compound.func_74764_b("EggLayTime")) {
            this.timeUntilNextEgg = compound.func_74762_e("EggLayTime");
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("IsDuckJockey", this.duckJockey);
        compound.func_74768_a("EggLayTime", this.timeUntilNextEgg);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return this.isDuckJockey();
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        float f = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        float f1 = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        passenger.func_70107_b(this.func_226277_ct_() + (double)(0.1f * f), this.func_226283_e_(0.5) + passenger.func_70033_W() + 0.0, this.func_226281_cx_() - (double)(0.1f * f1));
        if (passenger instanceof LivingEntity) {
            ((LivingEntity)passenger).field_70761_aq = this.field_70761_aq;
        }
    }

    public boolean isDuckJockey() {
        return this.duckJockey;
    }

    public void setDuckJockey(boolean jockey) {
        this.duckJockey = jockey;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity ageable) {
        return (AgeableEntity)((EntityType)EnvironmentalEntities.DUCK.get()).func_200721_a((World)world);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)EnvironmentalItems.DUCK_SPAWN_EGG.get());
    }

    @Override
    public int getEggTimer() {
        return this.timeUntilNextEgg;
    }

    @Override
    public void setEggTimer(int time) {
        this.timeUntilNextEgg = time;
    }

    @Override
    public boolean isBirdJockey() {
        return this.isDuckJockey();
    }

    @Override
    public Item getEggItem() {
        return (Item)EnvironmentalItems.DUCK_EGG.get();
    }

    @Override
    public int getNextEggTime(Random rand) {
        return rand.nextInt(6000) + 6000;
    }
}

