/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.item.explorer;

import com.minecraftabnormals.environmental.api.IExplorerArmorItem;
import com.minecraftabnormals.environmental.core.other.EnvironmentalCriteriaTriggers;
import com.minecraftabnormals.environmental.core.other.EnvironmentalTiers;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.DyeableArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ExplorerArmorItem
extends DyeableArmorItem
implements IExplorerArmorItem {
    public ExplorerArmorItem(EquipmentSlotType slot, Item.Properties properties) {
        super((IArmorMaterial)EnvironmentalTiers.Armor.EXPLORER, slot, properties);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return ExplorerArmorItem.getCorrectTexture(this.getRegistryName().func_110623_a(), type);
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        super.onArmorTick(stack, world, player);
        if (stack.func_77978_p() != null && this.getIncreaseForUses(this.getUses(stack.func_77978_p())) == 5 && player instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)player;
            if (!world.func_201670_d()) {
                EnvironmentalCriteriaTriggers.UPGRADE_GEAR.trigger(serverplayerentity, (Item)this);
            }
        }
    }

    public static String getCorrectTexture(String armor, String type) {
        if ("overlay".equals(type)) {
            return "environmental:textures/models/armor/" + armor + "_overlay.png";
        }
        return "environmental:textures/models/armor/" + armor + ".png";
    }

    public int func_200886_f(ItemStack stack) {
        if (!this.func_200883_f_(stack)) {
            return 7820095;
        }
        return super.func_200886_f(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT nbt = stack.func_196082_o();
        int uses = this.getUses(nbt);
        int nextLevel = this.getLevelsUntilUpgrade(uses);
        StringTextComponent counter = nextLevel != 0 ? new StringTextComponent(uses + "/" + nextLevel) : new StringTextComponent(String.valueOf(uses));
        counter.func_240699_a_(this.getFormattingForLevel(uses));
        IFormattableTextComponent description = new StringTextComponent(" " + this.getDescriptionString()).func_240699_a_(TextFormatting.GRAY);
        tooltip.add((ITextComponent)counter.func_230529_a_((ITextComponent)description));
    }

    @Override
    public int getIncreaseForUses(int uses) {
        int increase = 0;
        for (int level : this.getLevelCaps()) {
            if (uses < level) continue;
            ++increase;
        }
        return increase;
    }

    public int getLevelsUntilUpgrade(int uses) {
        int increase;
        int[] levels = this.getLevelCaps();
        if (levels.length > (increase = this.getIncreaseForUses(uses))) {
            return levels[increase];
        }
        return 0;
    }

    public int getUses(CompoundNBT nbt) {
        return nbt.func_74762_e(this.getUsesTag());
    }

    public TextFormatting getFormattingForLevel(int uses) {
        TextFormatting[] formatting = new TextFormatting[]{TextFormatting.DARK_GRAY, TextFormatting.GREEN, TextFormatting.BLUE, TextFormatting.LIGHT_PURPLE, TextFormatting.GOLD};
        return formatting[this.getIncreaseForUses(uses) - 1];
    }

    public Rarity func_77613_e(ItemStack stack) {
        boolean maxed;
        boolean bl = maxed = this.getIncreaseForUses(this.getUses(stack.func_196082_o())) == 5;
        if (stack.func_77948_v()) {
            if (maxed) {
                return Rarity.EPIC;
            }
            return Rarity.RARE;
        }
        if (maxed) {
            return Rarity.RARE;
        }
        return Rarity.COMMON;
    }
}

