/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.item.explorer;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.minecraftabnormals.environmental.client.model.ThiefHoodModel;
import com.minecraftabnormals.environmental.common.item.explorer.ExplorerArmorItem;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalAttributes;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalItems;
import java.util.UUID;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="environmental")
public class ThiefHoodItem
extends ExplorerArmorItem {
    private static final String NBT_TAG = "ThiefHoodUses";

    public ThiefHoodItem(Item.Properties properties) {
        super(EquipmentSlotType.HEAD, properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack stack, EquipmentSlotType armorSlot, A _default) {
        return ThiefHoodModel.get(1.0f);
    }

    public boolean isEnderMask(ItemStack stack, PlayerEntity player, EndermanEntity endermanEntity) {
        return true;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(super.func_111205_h(this.func_185083_B_()));
        UUID uuid = UUID.fromString("1D45B301-E65D-47A2-B63F-6EC5FCAC9316");
        int uses = Math.round(stack.func_196082_o().func_74760_g(NBT_TAG));
        double increase = 0.15 * (double)this.getIncreaseForUses(uses);
        builder.put((Object)EnvironmentalAttributes.STEALTH.get(), (Object)new AttributeModifier(uuid, "Stealth", increase, AttributeModifier.Operation.ADDITION));
        return slot == this.field_77881_a ? builder.build() : super.func_111205_h(slot);
    }

    @SubscribeEvent
    public static void playerNameEvent(PlayerEvent.NameFormat event) {
        ItemStack stack = event.getPlayer().func_184582_a(EquipmentSlotType.HEAD);
        if (stack.func_77973_b() == EnvironmentalItems.THIEF_HOOD.get()) {
            event.setDisplayname((ITextComponent)(stack.func_82837_s() ? new StringTextComponent(stack.func_200301_q().getString()).func_240699_a_(TextFormatting.ITALIC) : new StringTextComponent("???")));
        }
    }

    @SubscribeEvent
    public static void hoodEquippedEvent(LivingEquipmentChangeEvent event) {
        if ((event.getTo().func_77973_b() == EnvironmentalItems.THIEF_HOOD.get() || event.getFrom().func_77973_b() == EnvironmentalItems.THIEF_HOOD.get()) && event.getEntityLiving() instanceof PlayerEntity) {
            ((PlayerEntity)event.getEntityLiving()).refreshDisplayName();
        }
    }

    @SubscribeEvent
    public static void onEvent(LivingDeathEvent event) {
        LivingEntity attacker;
        ItemStack stack;
        LivingEntity entity = event.getEntityLiving();
        if (event.getSource().func_76346_g() instanceof LivingEntity && entity instanceof MobEntity && (stack = (attacker = (LivingEntity)event.getSource().func_76346_g()).func_184582_a(EquipmentSlotType.HEAD)).func_77973_b() instanceof ThiefHoodItem) {
            ((ThiefHoodItem)stack.func_77973_b()).levelUp(stack, attacker);
        }
    }

    @Override
    public String getUsesTag() {
        return NBT_TAG;
    }

    @Override
    public String getDescriptionString() {
        return "monsters slain";
    }

    @Override
    public int[] getLevelCaps() {
        return new int[]{0, 10, 50, 100, 500};
    }
}

