/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.slabfish.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.minecraftabnormals.environmental.common.slabfish.condition.SlabfishCondition;
import com.minecraftabnormals.environmental.common.slabfish.condition.SlabfishConditionContext;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public class SlabfishBiomeCondition
implements SlabfishCondition {
    private final ResourceLocation[] biomes;

    private SlabfishBiomeCondition(ResourceLocation biomeRegistryName) {
        this.biomes = ForgeRegistries.BIOMES.containsKey(biomeRegistryName) ? new ResourceLocation[]{biomeRegistryName} : new ResourceLocation[0];
    }

    private SlabfishBiomeCondition(@Nullable Biome.Category biomeCategory) {
        ArrayList<ResourceLocation> validBiomes = new ArrayList<ResourceLocation>();
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (biomeCategory != null && biome.func_201856_r() != biomeCategory) continue;
            validBiomes.add(biome.getRegistryName());
        }
        this.biomes = validBiomes.toArray(new ResourceLocation[0]);
    }

    private static Biome.Category deserializeBiomeType(JsonElement element) throws JsonParseException {
        if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
            throw new JsonSyntaxException("Biome type expected to be a string");
        }
        String name = element.getAsString();
        for (Biome.Category biomeCategory : Biome.Category.values()) {
            if (!biomeCategory.name().equalsIgnoreCase(name)) continue;
            return biomeCategory;
        }
        throw new JsonSyntaxException("Unknown biome category: " + name);
    }

    public static SlabfishCondition deserialize(JsonObject json, JsonDeserializationContext context) {
        if (json.has("biome") && json.has("category")) {
            throw new JsonSyntaxException("Either 'biome' or 'category' can be present.");
        }
        if (json.has("biome")) {
            return new SlabfishBiomeCondition((ResourceLocation)context.deserialize(json.get("biome"), ResourceLocation.class));
        }
        if (json.has("category") || json.has("tempCategory")) {
            Biome.Category biomeCategory = SlabfishBiomeCondition.deserializeBiomeType(json.get("category"));
            return new SlabfishBiomeCondition(biomeCategory);
        }
        throw new JsonSyntaxException("Either 'biome' or 'category' and 'tempCategory' must be present.");
    }

    @Override
    public boolean test(SlabfishConditionContext context) {
        for (ResourceLocation biomeRegistryName : this.biomes) {
            if (!biomeRegistryName.equals((Object)context.getBiome().getRegistryName())) continue;
            return true;
        }
        return false;
    }
}

