/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.slabfish.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.minecraftabnormals.environmental.common.slabfish.SlabfishType;
import com.minecraftabnormals.environmental.common.slabfish.condition.SlabfishCondition;
import com.minecraftabnormals.environmental.common.slabfish.condition.SlabfishConditionContext;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class SlabfishParentCondition
implements SlabfishCondition {
    private final ResourceLocation parentA;
    private final ResourceLocation parentB;

    private SlabfishParentCondition(ResourceLocation parentA, @Nullable ResourceLocation parentB) {
        this.parentA = parentA;
        this.parentB = parentB;
    }

    public static SlabfishCondition deserialize(JsonObject json, JsonDeserializationContext context) {
        if ((json.has("parentA") || json.has("parentB")) && json.has("parent")) {
            throw new JsonSyntaxException("Either 'parentA' and 'parentB' or 'parent' can be present.");
        }
        if (!(json.has("parentA") || json.has("parentB") || json.has("parent"))) {
            throw new JsonSyntaxException("Either 'parentA' and 'parentB' or 'parent' must be present.");
        }
        return json.has("parent") ? new SlabfishParentCondition((ResourceLocation)context.deserialize(json.get("parent"), ResourceLocation.class), null) : new SlabfishParentCondition((ResourceLocation)context.deserialize(json.get("parentA"), ResourceLocation.class), (ResourceLocation)context.deserialize(json.get("parentB"), ResourceLocation.class));
    }

    @Override
    public boolean test(SlabfishConditionContext context) {
        Pair<SlabfishType, SlabfishType> parentTypes = context.getParentTypes();
        if (parentTypes == null) {
            return false;
        }
        if (!this.parentA.equals((Object)((SlabfishType)parentTypes.getLeft()).getRegistryName()) && !this.parentA.equals((Object)((SlabfishType)parentTypes.getRight()).getRegistryName())) {
            return false;
        }
        if (this.parentB == null) {
            return true;
        }
        return this.parentA.equals((Object)((SlabfishType)parentTypes.getLeft()).getRegistryName()) && this.parentB.equals((Object)((SlabfishType)parentTypes.getRight()).getRegistryName()) || this.parentA.equals((Object)((SlabfishType)parentTypes.getRight()).getRegistryName()) && this.parentB.equals((Object)((SlabfishType)parentTypes.getLeft()).getRegistryName());
    }
}

