/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.core.registry;

import com.minecraftabnormals.environmental.client.model.SlabfishBucketModel;
import com.minecraftabnormals.environmental.client.particle.CherryBlossomParticle;
import com.minecraftabnormals.environmental.client.particle.KilnSmokeParticle;
import com.minecraftabnormals.environmental.client.particle.LotusBlossomParticle;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalItems;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalParticles;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="environmental", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class EnvironmentalClientRegistry {
    @SubscribeEvent
    public static void registerParticleFactorys(ParticleFactoryRegisterEvent event) {
        ParticleManager manager = Minecraft.func_71410_x().field_71452_i;
        EnvironmentalClientRegistry.registerParticleFactory(manager, EnvironmentalParticles.KILN_SMOKE, (ParticleManager.IParticleMetaFactory<BasicParticleType>)((ParticleManager.IParticleMetaFactory)KilnSmokeParticle.Factory::new));
        EnvironmentalClientRegistry.registerParticleFactory(manager, EnvironmentalParticles.CHERRY_BLOSSOM, (ParticleManager.IParticleMetaFactory<BasicParticleType>)((ParticleManager.IParticleMetaFactory)CherryBlossomParticle.Factory::new));
        EnvironmentalClientRegistry.registerParticleFactory(manager, EnvironmentalParticles.RED_LOTUS_BLOSSOM, (ParticleManager.IParticleMetaFactory<BasicParticleType>)((ParticleManager.IParticleMetaFactory)LotusBlossomParticle.Factory::new));
        EnvironmentalClientRegistry.registerParticleFactory(manager, EnvironmentalParticles.WHITE_LOTUS_BLOSSOM, (ParticleManager.IParticleMetaFactory<BasicParticleType>)((ParticleManager.IParticleMetaFactory)LotusBlossomParticle.Factory::new));
    }

    @SubscribeEvent
    public static void onEvent(ModelRegistryEvent event) {
        for (ResourceLocation location : Minecraft.func_71410_x().func_195551_G().func_199003_a("models/item/slabfish_bucket", s -> s.endsWith(".json"))) {
            ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation(location.func_110624_b(), location.func_110623_a().substring("models/".length(), location.func_110623_a().length() - ".json".length())));
        }
    }

    @SubscribeEvent
    public static void onEvent(ModelBakeEvent event) {
        event.getModelRegistry().put(new ModelResourceLocation(EnvironmentalItems.SLABFISH_BUCKET.getId(), "inventory"), new SlabfishBucketModel(event.getModelManager()));
    }

    private static <T extends IParticleData> void registerParticleFactory(ParticleManager manager, RegistryObject<BasicParticleType> particleTypeIn, ParticleManager.IParticleMetaFactory<BasicParticleType> particleMetaFactoryIn) {
        if (EnvironmentalClientRegistry.checkForNonNull(particleTypeIn)) {
            manager.func_215234_a((ParticleType)particleTypeIn.get(), particleMetaFactoryIn);
        }
    }

    private static boolean checkForNonNull(RegistryObject<BasicParticleType> registryObject) {
        return ObfuscationReflectionHelper.getPrivateValue(RegistryObject.class, registryObject, (String)"value") != null;
    }
}

