/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.util;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.config.ConfigHandler;
import com.chaosthedude.naturescompass.items.NaturesCompassItem;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.WorldWorkerManager;

public class BiomeSearchWorker
implements WorldWorkerManager.IWorker {
    public final int sampleSpace;
    public final int maxRadius;
    public World world;
    public Biome biome;
    public ResourceLocation biomeKey;
    public BlockPos startPos;
    public int samples;
    public int nextLength;
    public Direction direction;
    public ItemStack stack;
    public PlayerEntity player;
    public int x;
    public int z;
    public int length;
    public boolean finished;
    public int lastRadiusThreshold;

    public BiomeSearchWorker(World world, PlayerEntity player, ItemStack stack, Biome biome, BlockPos startPos) {
        this.world = world;
        this.player = player;
        this.stack = stack;
        this.biome = biome;
        this.startPos = startPos;
        this.x = startPos.func_177958_n();
        this.z = startPos.func_177952_p();
        this.sampleSpace = (Integer)ConfigHandler.GENERAL.sampleSpaceModifier.get() * BiomeUtils.getBiomeSize(world);
        this.maxRadius = (Integer)ConfigHandler.GENERAL.radiusModifier.get() * BiomeUtils.getBiomeSize(world);
        this.nextLength = this.sampleSpace;
        this.length = 0;
        this.samples = 0;
        this.direction = Direction.UP;
        this.finished = false;
        this.biomeKey = BiomeUtils.getKeyForBiome(world, biome);
        this.lastRadiusThreshold = 0;
    }

    public void start() {
        if (!this.stack.func_190926_b() && this.stack.func_77973_b() == NaturesCompass.naturesCompass) {
            if (this.maxRadius > 0 && this.sampleSpace > 0) {
                NaturesCompass.logger.info("Starting search: " + this.sampleSpace + " sample space, " + this.maxRadius + " max radius");
                WorldWorkerManager.addWorker((WorldWorkerManager.IWorker)this);
            } else {
                this.finish(false);
            }
        }
    }

    public boolean hasWork() {
        return !this.finished && this.getRadius() <= this.maxRadius && this.samples <= (Integer)ConfigHandler.GENERAL.maxSamples.get();
    }

    public boolean doWork() {
        if (this.hasWork()) {
            int radius;
            if (this.direction == Direction.NORTH) {
                this.z -= this.sampleSpace;
            } else if (this.direction == Direction.EAST) {
                this.x += this.sampleSpace;
            } else if (this.direction == Direction.SOUTH) {
                this.z += this.sampleSpace;
            } else if (this.direction == Direction.WEST) {
                this.x -= this.sampleSpace;
            }
            BlockPos pos = new BlockPos(this.x, this.world.func_217301_I(), this.z);
            Biome biomeAtPos = this.world.func_225523_d_().func_226836_a_(pos);
            ResourceLocation biomeAtPosKey = BiomeUtils.getKeyForBiome(this.world, biomeAtPos);
            if (biomeAtPosKey != null && biomeAtPosKey.equals((Object)this.biomeKey)) {
                this.finish(true);
                return false;
            }
            ++this.samples;
            this.length += this.sampleSpace;
            if (this.length >= this.nextLength) {
                if (this.direction != Direction.UP) {
                    this.nextLength += this.sampleSpace;
                    this.direction = this.direction.func_176746_e();
                } else {
                    this.direction = Direction.NORTH;
                }
                this.length = 0;
            }
            if ((radius = this.getRadius()) > 500 && radius / 500 > this.lastRadiusThreshold) {
                ((NaturesCompassItem)this.stack.func_77973_b()).setSearchRadius(this.stack, this.roundRadius(radius, 500), this.player);
                this.lastRadiusThreshold = radius / 500;
            }
        }
        if (this.hasWork()) {
            return true;
        }
        this.finish(false);
        return false;
    }

    private void finish(boolean found) {
        if (!this.stack.func_190926_b() && this.stack.func_77973_b() == NaturesCompass.naturesCompass) {
            if (found) {
                NaturesCompass.logger.info("Search succeeded: " + this.getRadius() + " radius, " + this.samples + " samples");
                ((NaturesCompassItem)this.stack.func_77973_b()).setFound(this.stack, this.x, this.z, this.samples, this.player);
            } else {
                NaturesCompass.logger.info("Search failed: " + this.getRadius() + " radius, " + this.samples + " samples");
                ((NaturesCompassItem)this.stack.func_77973_b()).setNotFound(this.stack, this.player, this.roundRadius(this.getRadius(), 500), this.samples);
            }
        } else {
            NaturesCompass.logger.error("Invalid compass after search");
        }
        this.finished = true;
    }

    private int getRadius() {
        return BiomeUtils.getDistanceToBiome(this.startPos, this.x, this.z);
    }

    private int roundRadius(int radius, int roundTo) {
        return radius / roundTo * roundTo;
    }
}

