/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.util;

import com.chaosthedude.naturescompass.config.ConfigHandler;
import com.chaosthedude.naturescompass.util.BiomeSearchWorker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeUtils {
    public static MutableRegistry<Biome> getBiomeRegistry(World world) {
        return world.func_241828_r().func_243612_b(ForgeRegistries.Keys.BIOMES);
    }

    public static ResourceLocation getKeyForBiome(World world, Biome biome) {
        return BiomeUtils.getBiomeRegistry(world).func_177774_c((Object)biome);
    }

    public static Optional<Biome> getBiomeForKey(World world, ResourceLocation key) {
        return BiomeUtils.getBiomeRegistry(world).func_241873_b(key);
    }

    public static List<Biome> getAllowedBiomes(World world) {
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        for (Map.Entry entry : BiomeUtils.getBiomeRegistry(world).func_239659_c_()) {
            Biome biome = (Biome)entry.getValue();
            if (biome == null || BiomeUtils.getKeyForBiome(world, biome) == null || BiomeUtils.biomeIsBlacklisted(world, biome)) continue;
            biomes.add(biome);
        }
        return biomes;
    }

    public static void searchForBiome(World world, PlayerEntity player, ItemStack stack, Biome biome, BlockPos startPos) {
        BiomeSearchWorker worker = new BiomeSearchWorker(world, player, stack, biome, startPos);
        worker.start();
    }

    public static int getBiomeSize(World world) {
        return 4;
    }

    public static int getDistanceToBiome(PlayerEntity player, int biomeX, int biomeZ) {
        return BiomeUtils.getDistanceToBiome(player.func_233580_cy_(), biomeX, biomeZ);
    }

    public static int getDistanceToBiome(BlockPos startPos, int biomeX, int biomeZ) {
        return (int)MathHelper.func_76133_a((double)startPos.func_177951_i((Vector3i)new BlockPos(biomeX, startPos.func_177956_o(), biomeZ)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getBiomeNameForDisplay(World world, ResourceLocation biome) {
        if (BiomeUtils.getBiomeForKey(world, biome).isPresent()) {
            return BiomeUtils.getBiomeNameForDisplay(world, BiomeUtils.getBiomeForKey(world, biome).get());
        }
        return "";
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getBiomeNameForDisplay(World world, Biome biome) {
        if (biome != null) {
            if (((Boolean)ConfigHandler.CLIENT.fixBiomeNames.get()).booleanValue()) {
                String original = BiomeUtils.getBiomeName(world, biome);
                String fixed = "";
                char pre = ' ';
                for (int i = 0; i < original.length(); ++i) {
                    char c = original.charAt(i);
                    if (Character.isUpperCase(c) && Character.isLowerCase(pre) && Character.isAlphabetic(pre)) {
                        fixed = fixed + " ";
                    }
                    fixed = fixed + String.valueOf(c);
                    pre = c;
                }
                return fixed;
            }
            if (BiomeUtils.getKeyForBiome(world, biome) != null) {
                return I18n.func_135052_a((String)BiomeUtils.getKeyForBiome(world, biome).toString(), (Object[])new Object[0]);
            }
        }
        return "";
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getBiomeName(World world, Biome biome) {
        return I18n.func_135052_a((String)Util.func_200697_a((String)"biome", (ResourceLocation)BiomeUtils.getKeyForBiome(world, biome)), (Object[])new Object[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getBiomeName(World world, ResourceLocation key) {
        if (BiomeUtils.getBiomeForKey(world, key).isPresent()) {
            return BiomeUtils.getBiomeName(world, BiomeUtils.getBiomeForKey(world, key).get());
        }
        return "";
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getBiomeSource(World world, Biome biome) {
        if (BiomeUtils.getKeyForBiome(world, biome) == null) {
            return "";
        }
        String registryEntry = BiomeUtils.getKeyForBiome(world, biome).toString();
        String modid = registryEntry.substring(0, registryEntry.indexOf(":"));
        if (modid.equals("minecraft")) {
            return "Minecraft";
        }
        Optional sourceContainer = ModList.get().getModContainerById(modid);
        if (sourceContainer.isPresent()) {
            return ((ModContainer)sourceContainer.get()).getModInfo().getDisplayName();
        }
        return modid;
    }

    public static boolean biomeIsBlacklisted(World world, Biome biome) {
        List biomeBlacklist = (List)ConfigHandler.GENERAL.biomeBlacklist.get();
        for (String biomeKey : biomeBlacklist) {
            if (!BiomeUtils.getKeyForBiome(world, biome).toString().matches(BiomeUtils.convertToRegex(biomeKey))) continue;
            return true;
        }
        return false;
    }

    private static String convertToRegex(String glob) {
        String regex = "^";
        for (int i = 0; i < glob.length(); i = (int)((char)(i + 1))) {
            char c = glob.charAt(i);
            regex = c == '*' ? regex + ".*" : (c == '?' ? regex + "." : (c == '.' ? regex + "\\." : regex + c));
        }
        regex = regex + "$";
        return regex;
    }
}

