/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.common.entities.booflo;

import com.minecraftabnormals.abnormals_core.core.api.IAgeableEntity;
import com.minecraftabnormals.abnormals_core.core.endimator.Endimation;
import com.minecraftabnormals.abnormals_core.core.endimator.entity.EndimatedEntity;
import com.minecraftabnormals.abnormals_core.core.util.NetworkUtil;
import com.minecraftabnormals.endergetic.api.entity.pathfinding.EndergeticFlyingPathNavigator;
import com.minecraftabnormals.endergetic.api.entity.util.EntityItemStackHelper;
import com.minecraftabnormals.endergetic.common.blocks.CorrockBlock;
import com.minecraftabnormals.endergetic.common.entities.bolloom.BolloomFruitEntity;
import com.minecraftabnormals.endergetic.common.entities.booflo.BoofloBabyEntity;
import com.minecraftabnormals.endergetic.common.entities.booflo.BoofloEntity;
import com.minecraftabnormals.endergetic.common.entities.booflo.ai.AdolescentAttackGoal;
import com.minecraftabnormals.endergetic.common.entities.booflo.ai.AdolescentEatGoal;
import com.minecraftabnormals.endergetic.common.entities.booflo.ai.BoofloNearestAttackableTargetGoal;
import com.minecraftabnormals.endergetic.core.registry.EEEntities;
import com.minecraftabnormals.endergetic.core.registry.EEItems;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BoofloAdolescentEntity
extends EndimatedEntity
implements IAgeableEntity {
    private static final DataParameter<Boolean> MOVING = EntityDataManager.func_187226_a(BoofloAdolescentEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HAS_FRUIT = EntityDataManager.func_187226_a(BoofloAdolescentEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DESCENTING = EntityDataManager.func_187226_a(BoofloAdolescentEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> EATING = EntityDataManager.func_187226_a(BoofloAdolescentEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HUNGRY = EntityDataManager.func_187226_a(BoofloAdolescentEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> EATEN = EntityDataManager.func_187226_a(BoofloAdolescentEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> WANTS_TO_GROW = EntityDataManager.func_187226_a(BoofloAdolescentEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> FALL_SPEED = EntityDataManager.func_187226_a(BoofloAdolescentEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> BOOF_BOOST_COOLDOWN = EntityDataManager.func_187226_a(BoofloAdolescentEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final Endimation BOOF_ANIMATION = new Endimation(10);
    public static final Endimation EATING_ANIMATION = new Endimation(10);
    private Entity boofloAttackTarget;
    public int growingAge;
    public int forcedAge;
    public int forcedAgeTimer;
    private float prevTailAnimation;
    private float tailAnimation;
    private float tailSpeed;
    private float prevSwimmingAnimation;
    private float swimmingAnimation;
    private float swimmingAnimationSpeed;
    public boolean wasBred;

    public BoofloAdolescentEntity(EntityType<? extends BoofloAdolescentEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new BoofloAdolescentMoveController(this);
        this.prevTailAnimation = this.tailAnimation = this.field_70146_Z.nextFloat();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MOVING, (Object)false);
        this.field_70180_af.func_187214_a(HAS_FRUIT, (Object)false);
        this.field_70180_af.func_187214_a(DESCENTING, (Object)false);
        this.field_70180_af.func_187214_a(EATING, (Object)false);
        this.field_70180_af.func_187214_a(HUNGRY, (Object)true);
        this.field_70180_af.func_187214_a(EATEN, (Object)false);
        this.field_70180_af.func_187214_a(WANTS_TO_GROW, (Object)false);
        this.field_70180_af.func_187214_a(FALL_SPEED, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(BOOF_BOOST_COOLDOWN, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new AdolescentEatGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new AdolescentAttackGoal(this, 1.1, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new RandomFlyingGoal((CreatureEntity)this, 1.1, 5));
        this.field_70715_bh.func_75776_a(4, new BoofloNearestAttackableTargetGoal<BolloomFruitEntity>((MobEntity)this, BolloomFruitEntity.class, true));
    }

    public void func_213352_e(Vector3d vec3d) {
        if (this.func_70613_aW() && !this.func_70090_H()) {
            this.func_213309_a(0.015f, vec3d);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            this.func_213317_d(this.func_213322_ci().func_178786_a(0.0, 0.005 * (double)this.getFallSpeed(), 0.0));
        } else {
            super.func_213352_e(vec3d);
        }
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new EndergeticFlyingPathNavigator((MobEntity)this, worldIn){

            @Override
            public boolean func_188555_b(BlockPos pos) {
                return !this.field_75515_a.func_233570_aj_();
            }
        };
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.65f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isEndimationPlaying(EATING_ANIMATION) && this.getAnimationTick() == 9) {
            if (this.field_70170_p instanceof ServerWorld) {
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)EEItems.BOLLOOM_FRUIT.get())), this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_213302_cg() / 1.5, this.func_226281_cx_(), 10, (double)(this.func_213311_cf() / 4.0f), (double)(this.func_213302_cg() / 4.0f), (double)(this.func_213311_cf() / 4.0f), 0.05);
            }
            this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_184187_bx() == null) {
            this.setFallSpeed(this.getFallSpeed() + 0.1f);
        }
        if (this.func_70681_au().nextInt(50000) < 10 && !this.isHungry() && !this.hasFruit()) {
            this.setHungry(true);
        }
        if (this.field_70170_p.field_72995_K) {
            this.prevTailAnimation = this.tailAnimation;
            this.prevSwimmingAnimation = this.swimmingAnimation;
            if (!this.func_70090_H()) {
                this.tailSpeed = 1.0f;
                this.swimmingAnimationSpeed = 1.0f;
            } else {
                this.tailSpeed = this.isMoving() ? (this.tailSpeed < 0.5f ? 1.0f : (this.tailSpeed += (0.25f - this.tailSpeed) * 0.1f)) : (this.tailSpeed += (0.1875f - this.tailSpeed) * 0.1f);
            }
            this.swimmingAnimationSpeed = this.getFallSpeed() > 0.0f ? (this.swimmingAnimationSpeed < 0.5f ? 1.0f : (this.swimmingAnimationSpeed += (this.swimmingAnimationSpeed * 2.5f - this.getFallSpeed()) * 0.1f)) : 1.0f;
            this.tailAnimation += this.tailSpeed;
            this.swimmingAnimation += this.swimmingAnimationSpeed;
        }
        if (this.getBoofBoostCooldown() > 0) {
            this.setBoofBoostCooldown(this.getBoofBoostCooldown() - 1);
        }
        if ((this.field_70122_E || this.func_184218_aH()) && this.doesWantToGrow() && this.field_70170_p.func_226664_a_(this.func_174813_aQ().func_72314_b(2.0, 0.0, 2.0))) {
            this.growUp();
        }
        if (!(this.isWorldRemote() || this.isDescenting() || this.isEating() || this.getBoofBoostCooldown() > 0 || !this.field_70122_E && !this.func_208600_a((ITag)FluidTags.field_206959_a))) {
            this.func_70024_g(-MathHelper.func_76126_a((float)((float)((double)this.field_70177_z * Math.PI / 180.0))) * (5.0f * (this.field_70146_Z.nextFloat() + 0.1f)) * 0.1f, this.field_70146_Z.nextFloat() * 0.45f + 0.65f, MathHelper.func_76134_b((float)((float)((double)this.field_70177_z * Math.PI / 180.0))) * (5.0f * (this.field_70146_Z.nextFloat() + 0.1f)) * 0.1f);
            this.setPlayingEndimation(BOOF_ANIMATION);
            NetworkUtil.setPlayingAnimationMessage((Entity)this, (Endimation)BOOF_ANIMATION);
            this.setFallSpeed(0.0f);
            if (this.field_205013_W) {
                this.setBoofBoostCooldown(20);
            }
        }
        if (this.getBoofBoostCooldown() <= 0 && !this.field_70122_E && this.field_70170_p.func_230315_m_() == CorrockBlock.DimensionTypeAccessor.THE_END && !this.isSafePos(this.func_233580_cy_(), 3)) {
            this.setBoofBoostCooldown(20);
            this.setFallSpeed(0.0f);
            if (this.func_226278_cu_() <= 50.0) {
                this.func_70024_g(-MathHelper.func_76126_a((float)((float)((double)this.field_70177_z * Math.PI / 180.0))) * (5.0f * (this.field_70146_Z.nextFloat() + 0.1f)) * 0.1f, this.field_70146_Z.nextFloat() * 0.45f + 0.65f, MathHelper.func_76134_b((float)((float)((double)this.field_70177_z * Math.PI / 180.0))) * (5.0f * (this.field_70146_Z.nextFloat() + 0.1f)) * 0.1f);
                this.setPlayingEndimation(BOOF_ANIMATION);
            }
        }
        if (!(this.field_70122_E || this.field_70170_p.func_230315_m_() != CorrockBlock.DimensionTypeAccessor.THE_END || this.isSafePos(this.func_233580_cy_(), 3) || this.isWorldRemote())) {
            this.func_70024_g(-MathHelper.func_76126_a((float)((float)((double)this.field_70177_z * Math.PI / 180.0))) * 0.01f, 0.0, MathHelper.func_76134_b((float)((float)((double)this.field_70177_z * Math.PI / 180.0))) * 0.01f);
        }
        if (this.getBoofloAttackTarget() != null && this.func_70685_l(this.getBoofloAttackTarget())) {
            this.field_70177_z = this.field_70759_as;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.forcedAgeTimer > 0) {
                if (this.forcedAgeTimer % 4 == 0) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
                }
                --this.forcedAgeTimer;
            }
        } else if (this.func_70089_S() && this.hasEaten()) {
            int growingAge = this.getGrowingAge();
            if (growingAge < 0) {
                this.setGrowingAge(++growingAge);
            } else if (growingAge > 0) {
                this.setGrowingAge(--growingAge);
            }
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)EEItems.BOOFLO_SPAWN_EGG.get());
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void func_70645_a(DamageSource cause) {
        if (this.hasFruit() && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            this.dropFruit();
        }
        super.func_70645_a(cause);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Moving", this.isMoving());
        compound.func_74757_a("HasFruit", this.hasFruit());
        compound.func_74757_a("Descenting", this.isDescenting());
        compound.func_74757_a("IsEating", this.isEating());
        compound.func_74757_a("IsHungry", this.isHungry());
        compound.func_74757_a("HasEaten", this.hasEaten());
        compound.func_74757_a("WantsToGrow", this.doesWantToGrow());
        compound.func_74776_a("FallSpeed", this.getFallSpeed());
        compound.func_74768_a("BoofBoostCooldown", this.getBoofBoostCooldown());
        compound.func_74768_a("Age", this.getGrowingAge());
        compound.func_74768_a("ForcedAge", this.forcedAge);
        compound.func_74757_a("WasBred", this.wasBred);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setMoving(compound.func_74767_n("Moving"));
        this.setHasFruit(compound.func_74767_n("HasFruit"));
        this.setDescenting(compound.func_74767_n("Descenting"));
        this.setEating(compound.func_74767_n("IsEating"));
        this.setHungry(compound.func_74767_n("IsHungry"));
        this.setEaten(compound.func_74767_n("HasEaten"));
        this.setWantsToGrow(compound.func_74767_n("WantsToGrow"));
        this.setFallSpeed(compound.func_74760_g("FallSpeed"));
        this.setBoofBoostCooldown(compound.func_74762_e("BoofBoostCooldown"));
        this.setGrowingAge(compound.func_74762_e("Age"));
        this.forcedAge = compound.func_74762_e("ForcedAge");
        this.wasBred = compound.func_74767_n("WasBred");
    }

    public boolean isMoving() {
        return (Boolean)this.field_70180_af.func_187225_a(MOVING);
    }

    public void setMoving(boolean moving) {
        this.field_70180_af.func_187227_b(MOVING, (Object)moving);
    }

    public boolean hasFruit() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_FRUIT);
    }

    public void setHasFruit(boolean hasFruit) {
        this.field_70180_af.func_187227_b(HAS_FRUIT, (Object)hasFruit);
    }

    public boolean isDescenting() {
        return (Boolean)this.field_70180_af.func_187225_a(DESCENTING);
    }

    public void setDescenting(boolean descenting) {
        this.field_70180_af.func_187227_b(DESCENTING, (Object)descenting);
    }

    public boolean isEating() {
        return (Boolean)this.field_70180_af.func_187225_a(EATING);
    }

    public void setEating(boolean eating) {
        this.field_70180_af.func_187227_b(EATING, (Object)eating);
    }

    public boolean isHungry() {
        return (Boolean)this.field_70180_af.func_187225_a(HUNGRY);
    }

    public void setHungry(boolean hungry) {
        this.field_70180_af.func_187227_b(HUNGRY, (Object)hungry);
    }

    public boolean hasEaten() {
        return (Boolean)this.field_70180_af.func_187225_a(EATEN);
    }

    public void setEaten(boolean eaten) {
        this.field_70180_af.func_187227_b(EATEN, (Object)eaten);
    }

    public boolean doesWantToGrow() {
        return (Boolean)this.field_70180_af.func_187225_a(WANTS_TO_GROW);
    }

    public void setWantsToGrow(boolean wantsToGrow) {
        this.field_70180_af.func_187227_b(WANTS_TO_GROW, (Object)wantsToGrow);
    }

    public float getFallSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(FALL_SPEED)).floatValue();
    }

    public void setFallSpeed(float speed) {
        this.field_70180_af.func_187227_b(FALL_SPEED, (Object)Float.valueOf(speed));
    }

    public int getBoofBoostCooldown() {
        return (Integer)this.field_70180_af.func_187225_a(BOOF_BOOST_COOLDOWN);
    }

    public void setBoofBoostCooldown(int ticks) {
        this.field_70180_af.func_187227_b(BOOF_BOOST_COOLDOWN, (Object)ticks);
    }

    @Nullable
    public Entity getBoofloAttackTarget() {
        return this.boofloAttackTarget;
    }

    public void setBoofloAttackTarget(@Nullable Entity entity) {
        this.boofloAttackTarget = entity;
    }

    public int getGrowingAge() {
        if (this.field_70170_p.field_72995_K) {
            return -1;
        }
        return this.growingAge;
    }

    public void setGrowingAge(int age) {
        int oldAge = this.growingAge;
        this.growingAge = age;
        if ((oldAge < 0 && age >= 0 || oldAge > 0 && age < 0) && this.hasEaten()) {
            this.setWantsToGrow(true);
        }
    }

    public void addGrowth(int growth) {
        this.ageUp(growth, false);
    }

    public void ageUp(int growthSeconds, boolean updateForcedAge) {
        int growingAge;
        int j = growingAge = this.getGrowingAge();
        if ((growingAge += growthSeconds * 20) > 0) {
            growingAge = 0;
        }
        int k = growingAge - j;
        this.setGrowingAge(growingAge);
        if (updateForcedAge) {
            this.forcedAge += k;
            if (this.forcedAgeTimer == 0) {
                this.forcedAgeTimer = 40;
            }
        }
        if (this.getGrowingAge() == 0) {
            this.setGrowingAge(this.forcedAge);
        }
    }

    public LivingEntity growUp() {
        if (this.func_70089_S()) {
            this.func_199702_a((IItemProvider)EEItems.BOOFLO_HIDE.get(), 1);
            BoofloEntity booflo = (BoofloEntity)((EntityType)EEEntities.BOOFLO.get()).func_200721_a(this.field_70170_p);
            booflo.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
            if (this.func_145818_k_()) {
                booflo.func_200203_b(this.func_200201_e());
                booflo.func_174805_g(this.func_174833_aM());
            }
            if (this.func_110167_bD()) {
                booflo.func_110162_b(this.func_110166_bE(), true);
                this.func_110160_i(true, false);
            }
            if (this.func_184187_bx() != null) {
                booflo.func_184220_m(this.func_184187_bx());
            }
            booflo.wasBred = this.wasBred;
            booflo.func_70606_j(booflo.func_110138_aP());
            this.field_70170_p.func_217376_c((Entity)booflo);
            this.func_70106_y();
            return booflo;
        }
        return this;
    }

    public LivingEntity growDown() {
        if (this.func_70089_S()) {
            BoofloBabyEntity boofloBaby = (BoofloBabyEntity)((EntityType)EEEntities.BOOFLO_BABY.get()).func_200721_a(this.field_70170_p);
            boofloBaby.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
            if (this.func_145818_k_()) {
                boofloBaby.func_200203_b(this.func_200201_e());
                boofloBaby.func_174805_g(this.func_174833_aM());
            }
            if (this.func_110167_bD()) {
                boofloBaby.func_110162_b(this.func_110166_bE(), true);
                this.func_110160_i(true, false);
            }
            if (this.func_184187_bx() != null) {
                boofloBaby.func_184220_m(this.func_184187_bx());
            }
            boofloBaby.wasBred = this.wasBred;
            boofloBaby.func_70606_j(boofloBaby.func_110138_aP());
            this.field_70170_p.func_217376_c((Entity)boofloBaby);
            this.func_70106_y();
            return boofloBaby;
        }
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getTailAnimation(float ptc) {
        return MathHelper.func_219799_g((float)ptc, (float)this.prevTailAnimation, (float)this.tailAnimation);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getSwimmingAnimation(float ptc) {
        return MathHelper.func_219799_g((float)ptc, (float)this.prevSwimmingAnimation, (float)this.swimmingAnimation);
    }

    public boolean isSafePos(BlockPos pos, int muliplier) {
        BlockPos newPos = pos;
        for (int y = 0; y < 10 * muliplier; ++y) {
            BlockState state = this.field_70170_p.func_180495_p(newPos = newPos.func_177979_c(y));
            if (!state.func_200132_m() && (state.func_204520_s().func_206888_e() || state.func_204520_s().func_206884_a((ITag)FluidTags.field_206960_b))) continue;
            return true;
        }
        return false;
    }

    public void dropFruit() {
        if (!this.isWorldRemote()) {
            this.func_199703_a((IItemProvider)EEItems.BOLLOOM_FRUIT.get());
            this.setHasFruit(false);
        }
    }

    public boolean isPlayerNear() {
        return this.field_70170_p.func_175647_a(PlayerEntity.class, this.func_174813_aQ().func_186662_g(2.0), BoofloEntity.IS_SCARED_BY).size() > 0;
    }

    public boolean func_180431_b(DamageSource source) {
        return source == DamageSource.field_76368_d || source == DamageSource.field_188406_j || super.func_180431_b(source);
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (item instanceof SpawnEggItem && ((SpawnEggItem)item).func_208077_a(itemstack.func_77978_p(), (EntityType)EEEntities.BOOFLO.get())) {
            if (!this.field_70170_p.field_72995_K) {
                BoofloBabyEntity baby = (BoofloBabyEntity)((EntityType)EEEntities.BOOFLO_BABY.get()).func_200721_a(this.field_70170_p);
                baby.setGrowingAge(-24000);
                baby.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0f, 0.0f);
                this.field_70170_p.func_217376_c((Entity)baby);
                if (itemstack.func_82837_s()) {
                    baby.func_200203_b(itemstack.func_200301_q());
                }
                EntityItemStackHelper.consumeItemFromStack(player, itemstack);
            }
            return ActionResultType.PASS;
        }
        if (item == EEItems.BOLLOOM_FRUIT.get()) {
            EntityItemStackHelper.consumeItemFromStack(player, itemstack);
            this.ageUp((int)((float)(-this.getGrowingAge() / 20) * 0.1f), true);
            this.setEaten(true);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.setGrowingAge(-24000);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public Endimation[] getEndimations() {
        return new Endimation[]{BOOF_ANIMATION, EATING_ANIMATION};
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.wasBred;
    }

    public boolean hasGrowthProgress() {
        return true;
    }

    public void resetGrowthProgress() {
        this.setGrowingAge(-24000);
    }

    public boolean canAge(boolean isGrowing) {
        return true;
    }

    public LivingEntity attemptAging(boolean isGrowing) {
        return isGrowing ? this.growUp() : this.growDown();
    }

    static class BoofloAdolescentMoveController
    extends MovementController {
        private final BoofloAdolescentEntity booflo;

        BoofloAdolescentMoveController(BoofloAdolescentEntity booflo) {
            super((MobEntity)booflo);
            this.booflo = booflo;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.booflo.func_70661_as().func_75500_f()) {
                Vector3d vec3d = this.booflo.getMoveControllerPathDistance(this.field_75646_b, this.field_75647_c, this.field_75644_d);
                this.booflo.field_70761_aq = this.booflo.field_70177_z = this.func_75639_a(this.booflo.field_70177_z, this.booflo.getTargetAngleForPathDistance(vec3d), 10.0f);
                this.booflo.field_70759_as = this.booflo.field_70177_z;
                float f1 = (float)(2.0 * this.booflo.func_110148_a(Attributes.field_233821_d_).func_111126_e());
                float f2 = MathHelper.func_219799_g((float)0.125f, (float)this.booflo.func_70689_ay(), (float)f1);
                this.booflo.func_70659_e(f2);
                this.booflo.setMoving(true);
            } else {
                this.booflo.setMoving(false);
            }
        }
    }

    static class RandomFlyingGoal
    extends RandomWalkingGoal {
        public RandomFlyingGoal(CreatureEntity booflo, double speed, int chance) {
            super(booflo, speed, chance);
        }

        @Nullable
        protected Vector3d func_190864_f() {
            Vector3d vec3d = RandomPositionGenerator.func_75463_a((CreatureEntity)this.field_75457_a, (int)10, (int)0);
            int i = 0;
            while (vec3d != null && !this.field_75457_a.field_70170_p.func_180495_p(new BlockPos(vec3d)).func_196957_g((IBlockReader)this.field_75457_a.field_70170_p, new BlockPos(vec3d), PathType.AIR) && i++ < 10) {
                vec3d = RandomPositionGenerator.func_75463_a((CreatureEntity)this.field_75457_a, (int)10, (int)0);
            }
            return vec3d;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.field_75457_a.func_70090_H();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && !this.field_75457_a.func_70090_H();
        }
    }
}

