/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.common.items;

import com.minecraftabnormals.abnormals_core.core.util.EntityUtil;
import com.minecraftabnormals.endergetic.common.entities.bolloom.BalloonColor;
import com.minecraftabnormals.endergetic.common.entities.bolloom.BolloomBalloonEntity;
import com.minecraftabnormals.endergetic.common.entities.bolloom.BolloomKnotEntity;
import com.minecraftabnormals.endergetic.core.interfaces.BalloonHolder;
import com.minecraftabnormals.endergetic.core.registry.EEEntities;
import com.minecraftabnormals.endergetic.core.registry.other.EETags;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeMod;

public class BolloomBalloonItem
extends Item {
    private final BalloonColor balloonColor;

    public BolloomBalloonItem(Item.Properties properties, BalloonColor balloonColor) {
        super(properties);
        this.balloonColor = balloonColor;
    }

    public BalloonColor getBalloonColor() {
        return this.balloonColor;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && BolloomBalloonItem.hasNoEntityTarget(player) && EntityUtil.rayTrace((Entity)player, (double)BolloomBalloonItem.getPlayerReach(player), (float)1.0f).func_216346_c() == RayTraceResult.Type.MISS && !player.func_225608_bj_()) {
            Entity ridingEntity = player.func_184187_bx();
            boolean isRidingBoat = ridingEntity instanceof BoatEntity;
            if (isRidingBoat && BolloomBalloonItem.canAttachBalloonToTarget(ridingEntity)) {
                BolloomBalloonItem.attachToEntity(this.balloonColor, ridingEntity);
                player.func_226292_a_(hand, true);
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                return ActionResult.func_226249_b_((Object)stack);
            }
            if (!isRidingBoat && BolloomBalloonItem.canAttachBalloonToTarget((Entity)player)) {
                BolloomBalloonItem.attachToEntity(this.balloonColor, (Entity)player);
                player.func_226292_a_(hand, true);
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                return ActionResult.func_226249_b_((Object)stack);
            }
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block instanceof FenceBlock) {
            if (this.isAirUpwards(world, pos)) {
                ItemStack stack;
                if (!world.field_72995_K && this.attachToFence(pos, world, stack = context.func_195996_i())) {
                    stack.func_190918_g(1);
                    return ActionResultType.SUCCESS;
                }
            } else {
                return ActionResultType.FAIL;
            }
            for (Entity entity : world.func_217357_a(Entity.class, new AxisAlignedBB(pos))) {
                if (!(entity instanceof BolloomKnotEntity) || !((BolloomKnotEntity)entity).hasMaxBalloons()) continue;
                return ActionResultType.FAIL;
            }
        }
        return ActionResultType.PASS;
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        World world = player.field_70170_p;
        if (!world.field_72995_K && BolloomBalloonItem.canAttachBalloonToTarget((Entity)target)) {
            player.func_226292_a_(hand, true);
            BolloomBalloonItem.attachToEntity(this.balloonColor, (Entity)target);
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    public static boolean canAttachBalloonToTarget(Entity target) {
        return !EETags.EntityTypes.NOT_BALLOON_ATTACHABLE.func_230235_a_((Object)target.func_200600_R()) && ((BalloonHolder)target).getBalloons().size() < (target instanceof BoatEntity ? 4 : 6);
    }

    public static void attachToEntity(BalloonColor color, Entity target) {
        World world = target.field_70170_p;
        BolloomBalloonEntity balloon = (BolloomBalloonEntity)((EntityType)EEEntities.BOLLOOM_BALLOON.get()).func_200721_a(world);
        if (balloon != null) {
            balloon.setColor(color);
            balloon.attachToEntity(target);
            balloon.updateAttachedPosition();
            balloon.setUntied(true);
            world.func_217376_c((Entity)balloon);
        }
    }

    private boolean attachToFence(BlockPos fencePos, World world, ItemStack stack) {
        BolloomKnotEntity setKnot = BolloomKnotEntity.getKnotForPosition(world, fencePos);
        if (setKnot != null && !setKnot.hasMaxBalloons()) {
            setKnot.addBalloon(this.getBalloonColor());
            return true;
        }
        if (setKnot == null) {
            BolloomKnotEntity.createStartingKnot(world, fencePos, this.getBalloonColor());
            return true;
        }
        return false;
    }

    private boolean isAirUpwards(World world, BlockPos pos) {
        BlockPos.Mutable mutable = new BlockPos.Mutable(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        for (int i = 0; i < 4; ++i) {
            if (world.func_175623_d((BlockPos)mutable.func_196234_d(0, 1, 0))) continue;
            return false;
        }
        return true;
    }

    public static double getPlayerReach(PlayerEntity player) {
        double reach = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        return player.func_184812_l_() ? reach : reach - 0.5;
    }

    public static boolean hasNoEntityTarget(PlayerEntity player) {
        double sqrDistance;
        Predicate<Entity> predicate;
        AxisAlignedBB axisalignedbb;
        Vector3d vec3d1;
        Vector3d vec3d2;
        double distance = BolloomBalloonItem.getPlayerReach(player);
        Vector3d vec3d = player.func_174824_e(1.0f);
        EntityRayTraceResult entityraytraceresult = BolloomBalloonItem.rayTraceEntities((Entity)player, vec3d, vec3d2 = vec3d.func_178787_e(vec3d1 = player.func_70676_i(1.0f).func_186678_a(distance)), axisalignedbb = player.func_174813_aQ().func_216361_a(vec3d1).func_186662_g(1.0), predicate = entity -> !entity.func_175149_v() && entity.func_70067_L(), sqrDistance = distance * distance);
        if (entityraytraceresult == null) {
            return true;
        }
        return vec3d.func_72436_e(entityraytraceresult.func_216347_e()) > sqrDistance;
    }

    private static EntityRayTraceResult rayTraceEntities(Entity shooter, Vector3d startVec, Vector3d endVec, AxisAlignedBB boundingBox, Predicate<Entity> filter, double distance) {
        World world = shooter.field_70170_p;
        double d0 = distance;
        Entity entity = null;
        Vector3d vector3d = null;
        for (Entity entity1 : world.func_175674_a(shooter, boundingBox, filter)) {
            Vector3d vector3d1;
            double d1;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y());
            Optional optional = axisalignedbb.func_216365_b(startVec, endVec);
            if (axisalignedbb.func_72318_a(startVec)) {
                if (!(d0 >= 0.0)) continue;
                entity = entity1;
                vector3d = optional.orElse(startVec);
                d0 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d1 = startVec.func_72436_e(vector3d1 = (Vector3d)optional.get())) < d0) && d0 != 0.0) continue;
            if (entity1.func_184208_bv() == shooter.func_184208_bv() && !entity1.canRiderInteract()) {
                if (d0 != 0.0) continue;
                entity = entity1;
                vector3d = vector3d1;
                continue;
            }
            entity = entity1;
            vector3d = vector3d1;
            d0 = d1;
        }
        return entity == null ? null : new EntityRayTraceResult(entity, vector3d);
    }

    public static class BalloonDispenseBehavior
    extends DefaultDispenseItemBehavior {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            BlockPos blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a));
            ServerWorld world = source.func_197524_h();
            BlockState state = world.func_180495_p(blockpos);
            for (Entity entity : world.func_217357_a(Entity.class, new AxisAlignedBB(blockpos))) {
                if (world.field_72995_K || !(entity instanceof LivingEntity) && !(entity instanceof BoatEntity) || !BolloomBalloonItem.canAttachBalloonToTarget(entity)) continue;
                BolloomBalloonItem.attachToEntity(((BolloomBalloonItem)stack.func_77973_b()).getBalloonColor(), entity);
                stack.func_190918_g(1);
                return stack;
            }
            if (state.func_185904_a().func_76222_j()) {
                BolloomBalloonEntity balloon = new BolloomBalloonEntity((World)world, blockpos);
                balloon.setColor(((BolloomBalloonItem)stack.func_77973_b()).getBalloonColor());
                world.func_217376_c((Entity)balloon);
                stack.func_190918_g(1);
                return stack;
            } else {
                if (!state.func_185904_a().func_76222_j() && !state.func_177230_c().func_203417_a((ITag)BlockTags.field_219748_G)) {
                    return super.func_82487_b(source, stack);
                }
                if (!state.func_177230_c().func_203417_a((ITag)BlockTags.field_219748_G)) return super.func_82487_b(source, stack);
                BolloomKnotEntity setKnot = BolloomKnotEntity.getKnotForPosition((World)world, blockpos);
                if (setKnot == null) {
                    BolloomKnotEntity.createStartingKnot((World)world, blockpos, ((BolloomBalloonItem)stack.func_77973_b()).getBalloonColor());
                    stack.func_190918_g(1);
                    return stack;
                }
                if (setKnot.hasMaxBalloons()) return super.func_82487_b(source, stack);
                setKnot.addBalloon(((BolloomBalloonItem)stack.func_77973_b()).getBalloonColor());
                stack.func_190918_g(1);
            }
            return stack;
        }
    }
}

