/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.common.world.features;

import com.minecraftabnormals.abnormals_core.core.util.MathUtil;
import com.minecraftabnormals.endergetic.api.util.GenerationUtils;
import com.minecraftabnormals.endergetic.common.blocks.poise.BolloomBudBlock;
import com.minecraftabnormals.endergetic.common.tileentities.BolloomBudTileEntity;
import com.minecraftabnormals.endergetic.core.registry.EEBlocks;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class BolloomBudFeature
extends Feature<NoFeatureConfig> {
    private static final Supplier<BlockState> BOLLOOM_BUD = () -> ((Block)EEBlocks.BOLLOOM_BUD.get()).func_176223_P();

    public BolloomBudFeature(Codec<NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if ((double)rand.nextFloat() > 0.75) {
            if (this.isValidPos((IWorld)world, pos)) {
                world.func_180501_a(pos, BOLLOOM_BUD.get(), 2);
                return true;
            }
        } else {
            int maxHeight = this.calculateFruitMaxHeight((IWorld)world, pos);
            if (this.isValidPos((IWorld)world, pos) && this.canFitCross((IWorld)world, pos) && GenerationUtils.isAreaAir((IWorld)world, pos.func_177958_n() - 1, pos.func_177956_o() + 1, pos.func_177952_p() - 1, pos.func_177958_n() + 1, pos.func_177956_o() + 2, pos.func_177952_p() + 1) && maxHeight > 1) {
                world.func_180501_a(pos, (BlockState)BOLLOOM_BUD.get().func_206870_a((Property)BolloomBudBlock.OPENED, (Comparable)Boolean.valueOf(true)), 2);
                TileEntity te = world.func_175625_s(pos);
                if (te instanceof BolloomBudTileEntity) {
                    ((BolloomBudTileEntity)te).startGrowing(rand, maxHeight, true);
                }
                return true;
            }
        }
        return false;
    }

    private boolean isValidPos(IWorld world, BlockPos pos) {
        Block block = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        return world.func_175623_d(pos) && world.func_175623_d(pos.func_177984_a()) && block == EEBlocks.POISMOSS.get() || block == EEBlocks.EUMUS_POISMOSS.get() || block == EEBlocks.EUMUS.get();
    }

    private int calculateFruitMaxHeight(IWorld world, BlockPos pos) {
        int[] maxHeights = new int[4];
        for (BolloomBudTileEntity.BudSide sides : BolloomBudTileEntity.BudSide.values()) {
            int y = 1;
            while (y < 7 && world.func_175623_d(sides.offsetPosition(pos.func_177981_b(y)))) {
                maxHeights[sides.id] = y++;
            }
        }
        return MathUtil.getLowestValueInIntArray((int[])maxHeights);
    }

    private boolean canFitCross(IWorld world, BlockPos pos) {
        for (BolloomBudTileEntity.BudSide sides : BolloomBudTileEntity.BudSide.values()) {
            if (world.func_175623_d(sides.offsetPosition(pos))) continue;
            return false;
        }
        return !BolloomBudBlock.isAcrossOrAdjacentToBud((IWorldReader)world, pos);
    }
}

