/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.common.world.features;

import com.minecraftabnormals.endergetic.common.blocks.poise.PoiseTallBushBlock;
import com.minecraftabnormals.endergetic.core.registry.EEBlocks;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class TallPoiseBushFeature
extends Feature<NoFeatureConfig> {
    private static final Supplier<BlockState> TALL_POISE_BUSH = () -> ((Block)EEBlocks.TALL_POISE_BUSH.get()).func_176223_P();

    public TallPoiseBushFeature(Codec<NoFeatureConfig> config) {
        super(config);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        boolean flag = false;
        for (int i = 0; i < 64; ++i) {
            BlockPos blockpos = pos.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
            if (this.isTouchingBolloomBud((IWorld)world, blockpos) || !world.func_175623_d(blockpos) || blockpos.func_177956_o() >= world.func_217301_I() - 2 || !TALL_POISE_BUSH.get().func_196955_c((IWorldReader)world, blockpos)) continue;
            ((PoiseTallBushBlock)TALL_POISE_BUSH.get().func_177230_c()).placeAt((IWorld)world, blockpos, 2);
            flag = true;
        }
        return flag;
    }

    private boolean isTouchingBolloomBud(IWorld world, BlockPos pos) {
        BlockPos.Mutable mutable = pos.func_239590_i_();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos offset = mutable.func_177972_a(direction);
            if (world.func_180495_p(offset).func_177230_c() != EEBlocks.BOLLOOM_BUD.get() && world.func_180495_p(offset.func_177984_a()).func_177230_c() != EEBlocks.BOLLOOM_BUD.get()) continue;
            return true;
        }
        return false;
    }
}

