/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.common.world.features.corrock;

import com.minecraftabnormals.abnormals_core.core.util.GenerationPiece;
import com.minecraftabnormals.endergetic.common.blocks.CorrockCrownBlock;
import com.minecraftabnormals.endergetic.common.blocks.CorrockCrownStandingBlock;
import com.minecraftabnormals.endergetic.common.blocks.CorrockCrownWallBlock;
import com.minecraftabnormals.endergetic.core.registry.EEBlocks;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChorusFlowerBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.LazyValue;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;

public abstract class AbstractCorrockFeature<FC extends IFeatureConfig>
extends Feature<FC> {
    protected static final Block CORROCK_BLOCK = (Block)EEBlocks.CORROCK_END.get();
    protected static final Block CORROCK_BLOCK_BLOCK = (Block)EEBlocks.CORROCK_END_BLOCK.get();
    protected static final LazyValue<BlockState> CORROCK_STATE = new LazyValue(() -> ((Block)EEBlocks.CORROCK_END.get()).func_176223_P());
    protected static final LazyValue<BlockState> CORROCK_BLOCK_STATE = new LazyValue(() -> ((Block)EEBlocks.CORROCK_END_BLOCK.get()).func_176223_P());

    protected static Supplier<BlockState> getCorrockCrown(boolean wall) {
        return wall ? () -> ((CorrockCrownWallBlock)EEBlocks.CORROCK_CROWN_END_WALL.get()).func_176223_P() : () -> ((CorrockCrownBlock)EEBlocks.CORROCK_CROWN_END_STANDING.get()).func_176223_P();
    }

    protected static BlockState getCorrockCrownWall(Direction facing) {
        return (BlockState)((CorrockCrownWallBlock)EEBlocks.CORROCK_CROWN_END_WALL.get()).func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)facing);
    }

    protected static BlockState getCorrockCrownStanding(int rotation) {
        return (BlockState)((CorrockCrownBlock)EEBlocks.CORROCK_CROWN_END_STANDING.get()).func_176223_P().func_206870_a((Property)CorrockCrownStandingBlock.ROTATION, (Comparable)Integer.valueOf(rotation));
    }

    public AbstractCorrockFeature(Codec<FC> configFactory) {
        super(configFactory);
    }

    protected static boolean isNotCloseToAnotherGrowth(List<ChorusPlantPart> growths, BlockPos pos) {
        for (ChorusPlantPart part : growths) {
            if (!(MathHelper.func_76133_a((double)part.pos.func_177951_i((Vector3i)pos)) < 2.0f)) continue;
            return false;
        }
        return true;
    }

    protected static boolean tryToFillWithCorrockBlock(ISeedReader world, int x1, int y1, int z1, int x2, int y2, int z2, List<BlockPos> positions) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int yy = y1; yy <= y2; ++yy) {
            for (int xx = x1; xx <= x2; ++xx) {
                for (int zz = z1; zz <= z2; ++zz) {
                    if (!world.func_175623_d((BlockPos)mutable.func_181079_c(xx, yy, zz))) {
                        return false;
                    }
                    positions.add(mutable.func_185334_h());
                }
            }
        }
        return true;
    }

    protected static boolean tryToPlaceCorrockBlock(ISeedReader world, BlockPos pos, List<BlockPos> positions) {
        if (world.func_175623_d(pos)) {
            positions.add(pos.func_185334_h());
            return true;
        }
        return false;
    }

    protected static boolean tryToPlaceCorrockBlockWithCrown(ISeedReader world, Random rand, BlockPos pos, List<BlockPos> positions, Direction direction, GenerationPiece crowns, @Nullable List<BlockPos> corners, float crownChance) {
        if (world.func_175623_d(pos)) {
            BlockPos immutable = pos.func_185334_h();
            positions.add(immutable);
            if (corners != null) {
                corners.add(immutable);
            }
            if (rand.nextFloat() < crownChance) {
                if (rand.nextBoolean()) {
                    BlockPos up = pos.func_177984_a();
                    if (world.func_175623_d(up)) {
                        crowns.addBlockPiece(AbstractCorrockFeature.getCorrockCrownStanding(rand.nextInt(16)), up);
                    }
                } else {
                    BlockPos offset = pos.func_177972_a(direction);
                    if (world.func_175623_d(offset)) {
                        crowns.addBlockPiece(AbstractCorrockFeature.getCorrockCrownWall(direction), offset);
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected static boolean tryToPlaceCrownedCorrockSquare(ISeedReader world, Random rand, int y, int x1, int z1, int x2, int z2, List<BlockPos> positions, Direction direction, GenerationPiece crowns, float crownChance) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int x = x1; x <= x2; ++x) {
            for (int z = z1; z <= z2; ++z) {
                if (AbstractCorrockFeature.tryToPlaceCorrockBlockWithCrown(world, rand, (BlockPos)mutable.func_181079_c(x, y, z), positions, direction, crowns, null, crownChance)) continue;
                return false;
            }
        }
        return true;
    }

    protected static class ChorusPlantPart {
        public final BlockPos pos;

        public ChorusPlantPart(BlockPos pos) {
            this.pos = pos;
        }

        public void placeGrowth(IWorld world, Random rand) {
            world.func_180501_a(this.pos, (BlockState)CORROCK_BLOCK_STATE.func_179281_c(), 2);
            ChorusFlowerBlock.func_185603_a((IWorld)world, (BlockPos)this.pos.func_177984_a(), (Random)rand, (int)8);
        }
    }
}

