/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.common.world.features.corrock;

import com.minecraftabnormals.endergetic.api.util.GenerationUtils;
import com.minecraftabnormals.endergetic.common.blocks.CorrockCrownStandingBlock;
import com.minecraftabnormals.endergetic.common.world.configs.CorrockArchConfig;
import com.minecraftabnormals.endergetic.common.world.features.corrock.AbstractCorrockFeature;
import com.minecraftabnormals.endergetic.core.registry.EEBlocks;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;

public class CorrockArchFeature
extends AbstractCorrockFeature<CorrockArchConfig> {
    public CorrockArchFeature(Codec<CorrockArchConfig> configFactory) {
        super(configFactory);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, CorrockArchConfig config) {
        int originZ;
        int originY;
        int originX;
        Block below = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if ((below == CORROCK_BLOCK_BLOCK || below == EEBlocks.EUMUS.get()) && world.func_175623_d(pos) && CorrockArchFeature.isGroundSolid(world, originX = pos.func_177958_n(), (originY = pos.func_177956_o()) - 1, originZ = pos.func_177952_p())) {
            BlockPos.Mutable mutable = pos.func_239590_i_();
            BlockPos end = null;
            float maxDistance = config.getMaxDistance();
            int maxDistanceInt = (int)maxDistance;
            float minDistance = config.getMinDistance();
            double distance = 0.0;
            for (int i = 0; i < 6; ++i) {
                int xPos = originX + rand.nextInt(maxDistanceInt) - rand.nextInt(maxDistanceInt);
                int zPos = originZ + rand.nextInt(maxDistanceInt) - rand.nextInt(maxDistanceInt);
                mutable.func_181079_c(xPos, originY, zPos);
                mutable.func_185336_p(world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, xPos, zPos));
                below = world.func_180495_p(mutable.func_177977_b()).func_177230_c();
                if (below != CORROCK_BLOCK_BLOCK && below != EEBlocks.EUMUS.get() && below != Blocks.field_150377_bs || !CorrockArchFeature.isGroundSolid(world, xPos, mutable.func_177956_o() - 1, zPos) || !((distance = (double)MathHelper.func_76133_a((double)mutable.func_177951_i((Vector3i)pos))) >= (double)minDistance) || !(distance <= (double)maxDistance) || !CorrockArchFeature.isGroundSolid(world, xPos, mutable.func_177956_o() - 1, zPos) || !world.func_175623_d((BlockPos)mutable)) continue;
                end = mutable.func_185334_h();
                break;
            }
            if (end != null) {
                HashSet<BlockPos> corrockBlockPositions = new HashSet<BlockPos>();
                ArchSpline archSpline = new ArchSpline(pos, end, rand, config.getMaxArchHeight());
                int steps = (int)(20.0 + distance * 4.0);
                BlockPos prevPos = null;
                int failedPositions = 0;
                int startY = pos.func_177956_o();
                int endY = end.func_177956_o();
                for (int i = 0; i < steps; ++i) {
                    float progress = (float)i / (float)steps;
                    BlockPos interpolatedPos = archSpline.interpolate(progress);
                    if (interpolatedPos.equals(prevPos)) continue;
                    prevPos = interpolatedPos;
                    int radius = 2;
                    double offsetRadius = (double)radius - (rand.nextDouble() - 0.5) * 0.25;
                    for (int y = -radius; y <= radius; ++y) {
                        for (int x = -radius; x <= radius; ++x) {
                            for (int z = -radius; z <= radius; ++z) {
                                BlockPos placingPos = interpolatedPos.func_177982_a(x, y, z);
                                if (!((double)MathHelper.func_76133_a((double)pos.func_177951_i((Vector3i)placingPos)) <= 32.0) || !((double)(x * x + y * y + z * z) <= offsetRadius)) continue;
                                if (world.func_175623_d(placingPos)) {
                                    corrockBlockPositions.add(placingPos);
                                    continue;
                                }
                                int placingPosY = placingPos.func_177956_o();
                                if (placingPosY < endY || placingPosY < startY || failedPositions++ <= 6) continue;
                                return false;
                            }
                        }
                    }
                }
                BlockState corrockBlockState = (BlockState)CORROCK_BLOCK_STATE.func_179281_c();
                BlockState corrockState = ((Block)EEBlocks.CORROCK_END.get()).func_176223_P();
                float crownChance = config.getCrownChance();
                float plantChance = config.getPlantChance();
                corrockBlockPositions.forEach(corrockPos -> {
                    BlockPos up;
                    world.func_180501_a(corrockPos, corrockBlockState, 2);
                    if (rand.nextFloat() < crownChance) {
                        BlockPos up2 = corrockPos.func_177984_a();
                        if (!corrockBlockPositions.contains(up2) && world.func_175623_d(up2)) {
                            world.func_180501_a(up2, CorrockArchFeature.getCorrockCrownStanding(rand.nextInt(16)), 2);
                        } else {
                            BlockPos down = corrockPos.func_177977_b();
                            if (!corrockBlockPositions.contains(down) && world.func_175623_d(down)) {
                                world.func_180501_a(down, (BlockState)CorrockArchFeature.getCorrockCrownStanding(rand.nextInt(16)).func_206870_a((Property)CorrockCrownStandingBlock.UPSIDE_DOWN, (Comparable)Boolean.valueOf(true)), 2);
                            } else {
                                for (Direction horizontal : Direction.Plane.HORIZONTAL) {
                                    BlockPos offset = corrockPos.func_177972_a(horizontal);
                                    if (corrockBlockPositions.contains(offset) || !world.func_175623_d(offset)) continue;
                                    world.func_180501_a(offset, CorrockArchFeature.getCorrockCrownWall(horizontal), 2);
                                }
                            }
                        }
                    } else if (rand.nextFloat() < plantChance && !corrockBlockPositions.contains(up = corrockPos.func_177984_a()) && world.func_175623_d(up)) {
                        world.func_180501_a(up, corrockState, 2);
                    }
                });
                return true;
            }
        }
        return false;
    }

    private static boolean isGroundSolid(ISeedReader world, int x, int y, int z) {
        return GenerationUtils.isAreaCompletelySolid((IWorld)world, x - 2, y, z - 2, x + 2, y, z + 2);
    }

    static class ArchSpline {
        private final Vector3d[] points;

        private ArchSpline(BlockPos start, BlockPos end, Random rand, float maxArchHeight) {
            ArrayList<Vector3d> points = new ArrayList<Vector3d>();
            Vector3d startVec = Vector3d.func_237491_b_((Vector3i)start);
            Vector3d endVec = Vector3d.func_237491_b_((Vector3i)end);
            Vector3d difference = endVec.func_178788_d(startVec);
            Vector3d normalizedDifference = difference.func_72432_b();
            Vector3d anchorStart = startVec.func_178788_d(normalizedDifference).func_72441_c(0.0, -6.0, 0.0);
            Vector3d anchorEnd = endVec.func_178787_e(normalizedDifference).func_72441_c(0.0, -6.0, 0.0);
            points.add(anchorStart);
            points.add(startVec);
            Vector3d offset = new Vector3d(0.0, 1.0, 0.0).func_72431_c(normalizedDifference);
            double offsetX = offset.field_72450_a;
            double offsetZ = offset.field_72449_c;
            for (int i = 0; i < 5; ++i) {
                points.add(startVec.func_178787_e(difference.func_186678_a((double)((float)i / 5.0f))).func_72441_c(offsetX * (rand.nextDouble() - 0.5) * 3.0, (rand.nextDouble() - 0.25) * 8.0 + (double)(MathHelper.func_76126_a((float)((float)((double)((float)i / 5.0f) * Math.PI))) * maxArchHeight), offsetZ * (rand.nextDouble() - 0.5) * 3.0));
            }
            points.add(endVec);
            points.add(anchorEnd);
            this.points = points.toArray(new Vector3d[0]);
        }

        private BlockPos interpolate(float progress) {
            Vector3d[] points = this.points;
            float sections = points.length - 3;
            int currentPoint = (int)Math.min(Math.floor(progress * sections), (double)(sections - 1.0f));
            Vector3d point0 = points[currentPoint];
            Vector3d point1 = points[currentPoint + 1];
            float t0 = ArchSpline.computeT(point0, point1, 0.0f);
            Vector3d point2 = points[currentPoint + 2];
            Vector3d point3 = points[currentPoint + 3];
            float t1 = ArchSpline.computeT(point1, point2, t0);
            float t = t0 + (progress * sections - (float)currentPoint) * (t1 - t0);
            double A1multiplier1 = (t0 - t) / t0;
            double A1multiplier2 = t / t0;
            double A1x = ArchSpline.multiplyPoints(point0.field_72450_a, point1.field_72450_a, A1multiplier1, A1multiplier2);
            double A1y = ArchSpline.multiplyPoints(point0.field_72448_b, point1.field_72448_b, A1multiplier1, A1multiplier2);
            double A1z = ArchSpline.multiplyPoints(point0.field_72449_c, point1.field_72449_c, A1multiplier1, A1multiplier2);
            double A2Denominator = t1 - t0;
            double A2Multiplier1 = (double)(t1 - t) / A2Denominator;
            double A2Multiplier2 = (double)(t - t0) / A2Denominator;
            double A2x = ArchSpline.multiplyPoints(point1.field_72450_a, point2.field_72450_a, A2Multiplier1, A2Multiplier2);
            double A2y = ArchSpline.multiplyPoints(point1.field_72448_b, point2.field_72448_b, A2Multiplier1, A2Multiplier2);
            double A2z = ArchSpline.multiplyPoints(point1.field_72449_c, point2.field_72449_c, A2Multiplier1, A2Multiplier2);
            float t3 = ArchSpline.computeT(point2, point3, t1);
            double A3Denominator = t3 - t1;
            double A3Multiplier1 = (double)(t3 - t) / A3Denominator;
            double A3Multiplier2 = (double)(t - t1) / A3Denominator;
            double A3x = ArchSpline.multiplyPoints(point2.field_72450_a, point3.field_72450_a, A3Multiplier1, A3Multiplier2);
            double A3y = ArchSpline.multiplyPoints(point2.field_72448_b, point3.field_72448_b, A3Multiplier1, A3Multiplier2);
            double A3z = ArchSpline.multiplyPoints(point2.field_72449_c, point3.field_72449_c, A3Multiplier1, A3Multiplier2);
            double B1Multiplier1 = (t1 - t) / t1;
            double B1Multiplier2 = t / t1;
            double B1x = ArchSpline.multiplyPoints(A1x, A2x, B1Multiplier1, B1Multiplier2);
            double B1y = ArchSpline.multiplyPoints(A1y, A2y, B1Multiplier1, B1Multiplier2);
            double B1z = ArchSpline.multiplyPoints(A1z, A2z, B1Multiplier1, B1Multiplier2);
            double B2Denominator = t3 - t0;
            double B2Multiplier1 = (double)(t3 - t) / B2Denominator;
            double B2Multiplier2 = (double)(t - t0) / B2Denominator;
            double B2x = ArchSpline.multiplyPoints(A2x, A3x, B2Multiplier1, B2Multiplier2);
            double B2y = ArchSpline.multiplyPoints(A2y, A3y, B2Multiplier1, B2Multiplier2);
            double B2z = ArchSpline.multiplyPoints(A2z, A3z, B2Multiplier1, B2Multiplier2);
            double CDenominator = t1 - t0;
            double CMultiplier1 = (double)(t1 - t) / CDenominator;
            double CMultiplier2 = (double)(t - t0) / CDenominator;
            return new BlockPos(ArchSpline.multiplyPoints(B1x, B2x, CMultiplier1, CMultiplier2), ArchSpline.multiplyPoints(B1y, B2y, CMultiplier1, CMultiplier2), ArchSpline.multiplyPoints(B1z, B2z, CMultiplier1, CMultiplier2));
        }

        private static double multiplyPoints(double point1, double point2, double multiplier1, double multiplier2) {
            return point1 * multiplier1 + point2 * multiplier2;
        }

        private static float computeT(Vector3d point1, Vector3d point2, float offset) {
            return MathHelper.func_76133_a((double)point2.func_178788_d(point1).func_72433_c()) + offset;
        }
    }
}

