/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.core;

import com.minecraftabnormals.abnormals_core.common.world.modification.BiomeFeatureModifier;
import com.minecraftabnormals.abnormals_core.common.world.modification.BiomeModificationManager;
import com.minecraftabnormals.abnormals_core.common.world.modification.BiomeModificationPredicates;
import com.minecraftabnormals.abnormals_core.common.world.modification.IBiomeModifier;
import com.minecraftabnormals.abnormals_core.core.util.registry.ISubRegistryHelper;
import com.minecraftabnormals.abnormals_core.core.util.registry.RegistryHelper;
import com.minecraftabnormals.endergetic.client.particles.EEParticles;
import com.minecraftabnormals.endergetic.client.renderers.entity.BolloomBalloonRenderer;
import com.minecraftabnormals.endergetic.client.renderers.entity.BolloomFruitRenderer;
import com.minecraftabnormals.endergetic.client.renderers.entity.BolloomKnotRenderer;
import com.minecraftabnormals.endergetic.client.renderers.entity.BoofBlockRenderer;
import com.minecraftabnormals.endergetic.client.renderers.entity.PoiseClusterRender;
import com.minecraftabnormals.endergetic.client.renderers.entity.PuffBugRenderer;
import com.minecraftabnormals.endergetic.client.renderers.entity.booflo.BoofloAdolescentRenderer;
import com.minecraftabnormals.endergetic.client.renderers.entity.booflo.BoofloBabyRenderer;
import com.minecraftabnormals.endergetic.client.renderers.entity.booflo.BoofloRenderer;
import com.minecraftabnormals.endergetic.client.renderers.tile.BolloomBudTileEntityRenderer;
import com.minecraftabnormals.endergetic.client.renderers.tile.CorrockCrownTileEntityRenderer;
import com.minecraftabnormals.endergetic.client.renderers.tile.DispensedBoofBlockTileEntityRenderer;
import com.minecraftabnormals.endergetic.client.renderers.tile.FrisbloomStemTileEntityRenderer;
import com.minecraftabnormals.endergetic.client.renderers.tile.PuffBugHiveTileEntityRenderer;
import com.minecraftabnormals.endergetic.common.network.C2SInflateBoofloVestMessage;
import com.minecraftabnormals.endergetic.common.network.entity.S2CUpdateBalloonsMessage;
import com.minecraftabnormals.endergetic.common.network.entity.booflo.C2SBoostMessage;
import com.minecraftabnormals.endergetic.common.network.entity.booflo.C2SInflateMessage;
import com.minecraftabnormals.endergetic.common.network.entity.booflo.C2SSlamMessage;
import com.minecraftabnormals.endergetic.common.network.entity.puffbug.RotateMessage;
import com.minecraftabnormals.endergetic.common.world.features.EEFeatures;
import com.minecraftabnormals.endergetic.common.world.placements.EEPlacements;
import com.minecraftabnormals.endergetic.common.world.surfacebuilders.EESurfaceBuilders;
import com.minecraftabnormals.endergetic.core.config.EEConfig;
import com.minecraftabnormals.endergetic.core.keybinds.KeybindHandler;
import com.minecraftabnormals.endergetic.core.registry.EEBiomes;
import com.minecraftabnormals.endergetic.core.registry.EEEntities;
import com.minecraftabnormals.endergetic.core.registry.EETileEntities;
import com.minecraftabnormals.endergetic.core.registry.other.EECompostables;
import com.minecraftabnormals.endergetic.core.registry.other.EEDataProcessors;
import com.minecraftabnormals.endergetic.core.registry.other.EEDataSerializers;
import com.minecraftabnormals.endergetic.core.registry.other.EEDispenserBehaviors;
import com.minecraftabnormals.endergetic.core.registry.other.EEEntityAttributes;
import com.minecraftabnormals.endergetic.core.registry.other.EEFlammables;
import com.minecraftabnormals.endergetic.core.registry.other.EELootInjectors;
import com.minecraftabnormals.endergetic.core.registry.other.EERenderLayers;
import com.minecraftabnormals.endergetic.core.registry.util.EndergeticBlockSubRegistryHelper;
import java.util.EnumSet;
import java.util.function.BiPredicate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EnderCrystalRenderer;
import net.minecraft.client.renderer.tileentity.CampfireTileEntityRenderer;
import net.minecraft.entity.EntityType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="endergetic")
public class EndergeticExpansion {
    public static final String MOD_ID = "endergetic";
    public static final Logger LOGGER = LogManager.getLogger((String)"endergetic".toUpperCase());
    public static final String NETWORK_PROTOCOL = "EE1";
    public static EndergeticExpansion instance;
    public static final RegistryHelper REGISTRY_HELPER;
    public static final SimpleChannel CHANNEL;

    public EndergeticExpansion() {
        instance = this;
        this.setupMessages();
        EEDataProcessors.registerTrackedData();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        REGISTRY_HELPER.register(modEventBus);
        EEParticles.PARTICLES.register(modEventBus);
        EESurfaceBuilders.SURFACE_BUILDERS.register(modEventBus);
        EEFeatures.FEATURES.register(modEventBus);
        EEPlacements.PLACEMENTS.register(modEventBus);
        EEDataSerializers.SERIALIZERS.register(modEventBus);
        modEventBus.addListener(event -> {
            ModConfig config = event.getConfig();
            if (config.getSpec() == EEConfig.COMMON_SPEC) {
                EEConfig.ValuesHolder.updateCommonValuesFromConfig(config);
            }
        });
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> modEventBus.addListener(EventPriority.LOWEST, this::setupClient));
        modEventBus.addListener(EventPriority.LOWEST, this::setupCommon);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, EEConfig.COMMON_SPEC);
    }

    void setupCommon(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            EEDispenserBehaviors.registerAll();
            EELootInjectors.registerLootInjectors();
            EESurfaceBuilders.Configs.registerConfiguredSurfaceBuilders();
            EEFeatures.Configured.registerConfiguredFeatures();
            EEBiomes.setupBiomeInfo();
            EEFlammables.registerFlammables();
            EECompostables.registerCompostables();
            EEEntityAttributes.putAttributes();
        });
        EndergeticExpansion.modifyBiomes();
    }

    private static void modifyBiomes() {
        BiomeModificationManager modificationManager = BiomeModificationManager.INSTANCE;
        BiPredicate highlandsOnly = BiomeModificationPredicates.forBiomeKey((RegistryKey)Biomes.field_201938_R);
        modificationManager.addModifier((IBiomeModifier)BiomeFeatureModifier.createFeatureReplacer((BiPredicate)highlandsOnly, EnumSet.of(GenerationStage.Decoration.SURFACE_STRUCTURES), () -> Feature.field_202299_as, () -> EEFeatures.Configured.END_GATEWAY));
    }

    @OnlyIn(value=Dist.CLIENT)
    void setupClient(FMLClientSetupEvent event) {
        EERenderLayers.setupRenderLayers();
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)EETileEntities.FRISBLOOM_STEM.get()), FrisbloomStemTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)EETileEntities.CORROCK_CROWN.get()), CorrockCrownTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)EETileEntities.BOLLOOM_BUD.get()), BolloomBudTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)EETileEntities.PUFFBUG_HIVE.get()), PuffBugHiveTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)EETileEntities.BOOF_BLOCK_DISPENSED.get()), DispensedBoofBlockTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)EETileEntities.ENDER_CAMPFIRE.get()), CampfireTileEntityRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EEEntities.BOLLOOM_FRUIT.get()), BolloomFruitRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EEEntities.POISE_CLUSTER.get()), PoiseClusterRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EEEntities.BOOF_BLOCK.get()), BoofBlockRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EEEntities.BOLLOOM_KNOT.get()), BolloomKnotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EEEntities.BOLLOOM_BALLOON.get()), BolloomBalloonRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EEEntities.PUFF_BUG.get()), PuffBugRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EEEntities.BOOFLO_BABY.get()), BoofloBabyRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EEEntities.BOOFLO_ADOLESCENT.get()), BoofloAdolescentRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EEEntities.BOOFLO.get()), BoofloRenderer::new);
        KeybindHandler.registerKeys();
        EnderCrystalRenderer.field_229046_e_ = RenderType.func_228640_c_((ResourceLocation)new ResourceLocation(MOD_ID, "textures/entity/end_crystal.png"));
    }

    private void setupMessages() {
        int id = -1;
        CHANNEL.registerMessage(id++, C2SInflateMessage.class, C2SInflateMessage::serialize, C2SInflateMessage::deserialize, C2SInflateMessage::handle);
        CHANNEL.registerMessage(id++, C2SBoostMessage.class, C2SBoostMessage::serialize, C2SBoostMessage::deserialize, C2SBoostMessage::handle);
        CHANNEL.registerMessage(id++, C2SSlamMessage.class, C2SSlamMessage::serialize, C2SSlamMessage::deserialize, C2SSlamMessage::handle);
        CHANNEL.registerMessage(id++, RotateMessage.class, RotateMessage::serialize, RotateMessage::deserialize, RotateMessage::handle);
        CHANNEL.registerMessage(id++, S2CUpdateBalloonsMessage.class, S2CUpdateBalloonsMessage::serialize, S2CUpdateBalloonsMessage::deserialize, S2CUpdateBalloonsMessage::handle);
        CHANNEL.registerMessage(id++, C2SInflateBoofloVestMessage.class, C2SInflateBoofloVestMessage::serialize, C2SInflateBoofloVestMessage::deserialize, C2SInflateBoofloVestMessage::handle);
    }

    static {
        REGISTRY_HELPER = RegistryHelper.create((String)MOD_ID, helper -> helper.putSubHelper(ForgeRegistries.BLOCKS, (ISubRegistryHelper)new EndergeticBlockSubRegistryHelper((RegistryHelper)helper)));
        CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(MOD_ID, "net")).networkProtocolVersion(() -> NETWORK_PROTOCOL).clientAcceptedVersions(NETWORK_PROTOCOL::equals).serverAcceptedVersions(NETWORK_PROTOCOL::equals).simpleChannel();
    }
}

