/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.core.mixin;

import com.minecraftabnormals.endergetic.common.entities.bolloom.BolloomBalloonEntity;
import com.minecraftabnormals.endergetic.core.interfaces.BalloonHolder;
import net.minecraft.client.multiplayer.ClientChunkProvider;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientWorld.class})
public abstract class ClientWorldMixin {
    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;isPassenger()Z"), method={"tickEntities"})
    private boolean shouldNotTick(Entity entity) {
        return entity.func_184218_aH() || entity instanceof BolloomBalloonEntity && ((BolloomBalloonEntity)entity).isAttachedToEntity();
    }

    @Inject(at={@At(value="FIELD", target="Lnet/minecraft/entity/Entity;addedToChunk:Z", ordinal=1, shift=At.Shift.AFTER)}, method={"updateEntity"})
    private void updateBalloons(Entity entity, CallbackInfo info) {
        BalloonHolder balloonHolder = (BalloonHolder)entity;
        ClientChunkProvider chunkProvider = ((ClientWorld)this).func_72863_F();
        for (BolloomBalloonEntity balloon : balloonHolder.getBalloons()) {
            if (!balloon.field_70128_L && balloon.getAttachedEntity() == entity) {
                if (!chunkProvider.func_217204_a((Entity)balloon)) continue;
                balloon.func_226286_f_(balloon.func_226277_ct_(), balloon.func_226278_cu_(), balloon.func_226281_cx_());
                balloon.field_70126_B = balloon.field_70177_z;
                balloon.field_70127_C = balloon.field_70125_A;
                if (balloon.field_70175_ag) {
                    ++balloon.field_70173_aa;
                    balloon.updateAttachedPosition();
                }
                this.callCheckChunk(balloon);
                continue;
            }
            balloon.detachFromEntity();
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;updateRidden()V", shift=At.Shift.AFTER)}, method={"updateEntityRidden"})
    private void updateEntityRiddenBalloons(Entity ridingEntity, Entity passenger, CallbackInfo info) {
        BalloonHolder balloonHolder = (BalloonHolder)passenger;
        ClientChunkProvider chunkProvider = ((ClientWorld)this).func_72863_F();
        for (BolloomBalloonEntity balloon : balloonHolder.getBalloons()) {
            if (!balloon.field_70128_L && balloon.getAttachedEntity() == passenger) {
                if (!chunkProvider.func_217204_a((Entity)balloon)) continue;
                balloon.func_226286_f_(balloon.func_226277_ct_(), balloon.func_226278_cu_(), balloon.func_226281_cx_());
                balloon.field_70126_B = balloon.field_70177_z;
                balloon.field_70127_C = balloon.field_70125_A;
                if (balloon.field_70175_ag) {
                    ++balloon.field_70173_aa;
                    balloon.updateAttachedPosition();
                }
                this.callCheckChunk(balloon);
                continue;
            }
            balloon.detachFromEntity();
        }
    }

    @Invoker
    public abstract void callCheckChunk(Entity var1);
}

